/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;

public class ActivationClassBuilder
extends ExpressionClassBuilder {
    private LocalField targetResultSetField;
    private LocalField cursorResultSetField;
    private MethodBuilder closeActivationMethod;

    ActivationClassBuilder(String superClass, CompilerContext cc) throws StandardException {
        super(superClass, null, cc);
        this.executeMethod = this.beginExecuteMethod();
    }

    @Override
    public String getPackageName() {
        return "com.pivotal.gemfirexd.internal.exe.";
    }

    @Override
    protected String getBaseClassName() {
        return "com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation";
    }

    @Override
    public int getRowCount() throws StandardException {
        return this.myCompCtx.getNumResultSets();
    }

    @Override
    public void setNumSubqueries() {
        int numSubqueries = this.myCompCtx.getNumSubquerys();
        if (numSubqueries == 0) {
            return;
        }
        this.constructor.pushThis();
        this.constructor.push(numSubqueries);
        this.constructor.putField("com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", "numSubqueries", "int");
        this.constructor.endStatement();
    }

    private MethodBuilder beginExecuteMethod() throws StandardException {
        MethodBuilder mb = this.cb.newMethodBuilder(1, "com.pivotal.gemfirexd.internal.iapi.sql.ResultSet", "execute");
        mb.addThrownException("com.pivotal.gemfirexd.internal.iapi.error.StandardException");
        mb.pushThis();
        mb.push("execute");
        mb.callMethod((short)182, "com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", "throwIfClosed", "void", 1);
        mb.pushThis();
        mb.callMethod((short)182, "com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", "startExecution", "void", 0);
        return mb;
    }

    MethodBuilder startResetMethod() {
        MethodBuilder mb = this.cb.newMethodBuilder(1, "void", "reset", new String[]{"boolean"});
        mb.addThrownException("com.pivotal.gemfirexd.internal.iapi.error.StandardException");
        mb.pushThis();
        mb.getParameter(0);
        mb.callMethod((short)183, "com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", "reset", "void", 1);
        return mb;
    }

    void finishExecuteMethod(boolean genMarkAsTopNode) {
        if (genMarkAsTopNode) {
            this.executeMethod.dup();
            this.executeMethod.cast("com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet");
            this.executeMethod.callMethod((short)185, null, "markAsTopResultSet", "void", 0);
        }
        this.executeMethod.methodReturn();
        this.executeMethod.complete();
        this.getClassBuilder().newFieldWithAccessors("getExecutionCount", "setExecutionCount", 4, true, "int");
        this.getClassBuilder().newFieldWithAccessors("getRowCountCheckVector", "setRowCountCheckVector", 4, true, "java.util.Vector");
        this.getClassBuilder().newFieldWithAccessors("getStalePlanCheckInterval", "setStalePlanCheckInterval", 4, true, "int");
        if (this.closeActivationMethod != null) {
            this.closeActivationMethod.methodReturn();
            this.closeActivationMethod.complete();
        }
    }

    void addCursorPositionCode() {
        MethodBuilder getter = this.cb.newMethodBuilder(1, "com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet", "getTargetResultSet");
        getter.getField(this.targetResultSetField);
        getter.methodReturn();
        getter.complete();
        getter = this.cb.newMethodBuilder(1, "com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet", "getCursorResultSet");
        getter.getField(this.cursorResultSetField);
        getter.methodReturn();
        getter.complete();
    }

    void rememberCursorTarget(MethodBuilder mb) {
        this.targetResultSetField = this.cb.addField("com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet", "targetResultSet", 2);
        mb.cast("com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet");
        mb.putField(this.targetResultSetField);
        mb.cast("com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet");
    }

    void rememberCursor(MethodBuilder mb) {
        this.cursorResultSetField = this.cb.addField("com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet", "cursorResultSet", 2);
        mb.cast("com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet");
        mb.putField(this.cursorResultSetField);
        mb.cast("com.pivotal.gemfirexd.internal.iapi.sql.ResultSet");
    }

    @Override
    protected LocalField getCurrentSetup() {
        if (this.cdtField != null) {
            return this.cdtField;
        }
        LocalField lf = super.getCurrentSetup();
        this.executeMethod.getField(lf);
        this.executeMethod.callMethod((short)182, null, "forget", "void", 0);
        return lf;
    }

    MethodBuilder getCloseActivationMethod() {
        if (this.closeActivationMethod == null) {
            this.closeActivationMethod = this.cb.newMethodBuilder(1, "void", "closeActivationAction");
            this.closeActivationMethod.addThrownException("java.lang.Exception");
        }
        return this.closeActivationMethod;
    }
}

