/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.Cacheable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DataDictionaryImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.TDCacheable;

class OIDTDCacheable
extends TDCacheable {
    private UUID identity;

    OIDTDCacheable(DataDictionaryImpl dd) {
        super(dd);
    }

    @Override
    public void clearIdentity() {
        this.identity = null;
        this.td = null;
    }

    @Override
    public Object getIdentity() {
        return this.identity;
    }

    @Override
    public Cacheable createIdentity(Object key, Object createParameter) {
        if (!(key instanceof UUID)) {
            SanityManager.THROWASSERT((String)("Key for an OIDTDCacheElement is a " + key.getClass().getName() + " instead of an UUID"));
        }
        if (!(createParameter instanceof TableDescriptor)) {
            SanityManager.THROWASSERT((String)("Create parameter for an OIDTDCacheElement is a " + createParameter.getClass().getName() + "instead of a TableDescriptorImpl"));
        }
        this.identity = ((UUID)key).cloneMe();
        this.td = (TableDescriptor)createParameter;
        if (this.td != null) {
            return this;
        }
        return null;
    }

    @Override
    public Cacheable setIdentity(Object key) throws StandardException {
        if (!(key instanceof UUID)) {
            SanityManager.THROWASSERT((String)("Key for an OIDTDCacheElement is a " + key.getClass().getName() + " instead of an UUID"));
        }
        this.identity = ((UUID)key).cloneMe();
        this.td = this.dd.getUncachedTableDescriptor(this.identity);
        if (this.td != null) {
            this.dd.addTableDescriptorToOtherCache(this.td, this);
            return this;
        }
        return null;
    }
}

