/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.cache;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.DaemonService;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.Serviceable;
import com.pivotal.gemfirexd.internal.impl.services.cache.CacheEntry;
import com.pivotal.gemfirexd.internal.impl.services.cache.ConcurrentCache;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

final class BackgroundCleaner
implements Serviceable {
    private final DaemonService daemonService;
    private final int clientNumber;
    private final AtomicBoolean scheduled = new AtomicBoolean();
    private final ArrayBlockingQueue<CacheEntry> queue;
    private volatile boolean shrink;
    private final ConcurrentCache cacheManager;

    BackgroundCleaner(ConcurrentCache cache, DaemonService daemon, int queueSize) {
        this.queue = new ArrayBlockingQueue(queueSize);
        this.daemonService = daemon;
        this.cacheManager = cache;
        this.clientNumber = daemon.subscribe(this, true);
    }

    boolean scheduleClean(CacheEntry entry) {
        boolean queued = this.queue.offer(entry);
        if (queued) {
            this.requestService();
        }
        return queued;
    }

    void scheduleShrink() {
        this.shrink = true;
        this.requestService();
    }

    private void requestService() {
        if (this.scheduled.compareAndSet(false, true)) {
            this.daemonService.serviceNow(this.clientNumber);
        }
    }

    void unsubscribe() {
        this.daemonService.unsubscribe(this.clientNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int performWork(ContextManager context) throws StandardException {
        CacheEntry e;
        this.scheduled.set(false);
        if (this.shrink) {
            this.shrink = false;
            this.cacheManager.getReplacementPolicy().doShrink();
        }
        if ((e = this.queue.poll()) != null) {
            try {
                this.cacheManager.cleanEntry(e);
            }
            finally {
                if (!this.queue.isEmpty() || this.shrink) {
                    this.requestService();
                }
            }
        }
        return 1;
    }

    @Override
    public boolean serviceASAP() {
        return true;
    }

    @Override
    public boolean serviceImmediately() {
        return false;
    }
}

