/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.load;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class PartialFileInputStream
extends FileInputStream {
    private long numBytesToRead;

    public PartialFileInputStream(String fileName, long offset, long endPosition) throws IOException {
        super(fileName);
        this.initialize(offset, endPosition);
    }

    public PartialFileInputStream(File file, long offset, long endPosition) throws IOException {
        super(file);
        this.initialize(offset, endPosition);
    }

    private void initialize(long offset, long endPosition) throws IOException {
        if (offset > 0L) {
            super.getChannel().position(offset);
        }
        this.numBytesToRead = endPosition - offset;
        if (this.numBytesToRead < 0L) {
            throw new IOException("invalid offset=" + offset + ", endPosition=" + endPosition);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.numBytesToRead > 0L) {
            --this.numBytesToRead;
            return super.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.numBytesToRead > 0L) {
            int readLen = this.numBytesToRead >= (long)len ? super.read(b, off, len) : super.read(b, off, (int)this.numBytesToRead);
            if (readLen > 0) {
                this.numBytesToRead -= (long)readLen;
            }
            return readLen;
        }
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        long skippedLen = n >= this.numBytesToRead ? super.skip(n) : super.skip(this.numBytesToRead);
        if (skippedLen > 0L) {
            this.numBytesToRead -= skippedLen;
        }
        return skippedLen;
    }

    @Override
    public int available() throws IOException {
        int avail = super.available();
        return (long)avail <= this.numBytesToRead ? avail : (int)this.numBytesToRead;
    }
}

