/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.pivotal.gemfirexd.internal.catalog.DependableFinder;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Dependent;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Provider;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GenericDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexLister;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.UniqueSQLObjectDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ViewDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;

public class TableDescriptor
extends TupleDescriptor
implements UniqueSQLObjectDescriptor,
Provider,
Dependent {
    public static final int BASE_TABLE_TYPE = 0;
    public static final int SYSTEM_TABLE_TYPE = 1;
    public static final int VIEW_TYPE = 2;
    public static final int GLOBAL_TEMPORARY_TABLE_TYPE = 3;
    public static final int SYNONYM_TYPE = 4;
    public static final int VTI_TYPE = 5;
    public static final int COLUMN_TABLE_TYPE = 6;
    public static final char ROW_LOCK_GRANULARITY = 'R';
    public static final char TABLE_LOCK_GRANULARITY = 'T';
    public static final char DEFAULT_LOCK_GRANULARITY = 'R';
    private char lockGranularity;
    private boolean onCommitDeleteRows;
    private boolean onRollbackDeleteRows;
    SchemaDescriptor schema;
    String tableName;
    UUID oid;
    int tableType;
    long heapConglomNumber = -1L;
    ColumnDescriptorList columnDescriptorList;
    ConglomerateDescriptorList conglomerateDescriptorList;
    ConstraintDescriptorList constraintDescriptorList;
    private GenericDescriptorList triggerDescriptorList;
    ViewDescriptor viewDescriptor;
    FormatableBitSet referencedColumnMap;
    private List statisticsDescriptorList;
    private DistributionDescriptor distributionDesc = null;
    private boolean skipRouteQueryToAllNodes;

    public TableDescriptor(DataDictionary dataDictionary, String tableName, SchemaDescriptor schema, int tableType, boolean onCommitDeleteRows, boolean onRollbackDeleteRows) {
        this(dataDictionary, tableName, schema, tableType, '\u0000');
        this.onCommitDeleteRows = onCommitDeleteRows;
        this.onRollbackDeleteRows = onRollbackDeleteRows;
    }

    public TableDescriptor(DataDictionary dataDictionary, String tableName, SchemaDescriptor schema, int tableType, char lockGranularity) {
        super(dataDictionary);
        this.schema = schema;
        this.tableName = tableName;
        this.tableType = tableType;
        this.lockGranularity = lockGranularity;
        this.conglomerateDescriptorList = new ConglomerateDescriptorList();
        this.columnDescriptorList = new ColumnDescriptorList();
        this.constraintDescriptorList = new ConstraintDescriptorList();
        this.triggerDescriptorList = new GenericDescriptorList();
    }

    public String getSchemaName() {
        return this.schema.getSchemaName();
    }

    @Override
    public SchemaDescriptor getSchemaDescriptor() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.tableName;
    }

    public void setTableName(String newTableName) {
        this.tableName = newTableName;
    }

    public String getQualifiedName() {
        return this.quoteProtectName(this.getSchemaName()) + "." + this.quoteProtectName(this.getName());
    }

    @Override
    public UUID getUUID() {
        return this.oid;
    }

    public int getTableType() {
        return this.tableType;
    }

    public long getHeapConglomerateId() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        ConglomerateDescriptor cd = null;
        if (this.heapConglomNumber != -1L) {
            return this.heapConglomNumber;
        }
        ConglomerateDescriptor[] cds = this.getConglomerateDescriptors();
        for (int index = 0; index < cds.length && (cd = cds[index]).isIndex(); ++index) {
        }
        if (cd == null) {
            SanityManager.THROWASSERT((String)("cd is expected to be non-null for " + this.tableName));
        }
        if (cd.isIndex()) {
            SanityManager.THROWASSERT((String)("Did not find heap conglomerate for " + this.tableName));
        }
        this.heapConglomNumber = cd.getConglomerateNumber();
        return this.heapConglomNumber;
    }

    public int getNumberOfColumns() {
        return this.getColumnDescriptorList().size();
    }

    public FormatableBitSet getReferencedColumnMap() {
        return this.referencedColumnMap;
    }

    public void setReferencedColumnMap(FormatableBitSet referencedColumnMap) {
        this.referencedColumnMap = referencedColumnMap;
    }

    public int getMaxColumnID() throws StandardException {
        int maxColumnID = 1;
        int cdlSize = this.getColumnDescriptorList().size();
        for (int index = 0; index < cdlSize; ++index) {
            ColumnDescriptor cd = this.columnDescriptorList.elementAt(index);
            maxColumnID = Math.max(maxColumnID, cd.getPosition());
        }
        return maxColumnID;
    }

    public void setUUID(UUID oid) {
        this.oid = oid;
    }

    public char getLockGranularity() {
        return this.lockGranularity;
    }

    public void setLockGranularity(char lockGranularity) {
        this.lockGranularity = lockGranularity;
    }

    public boolean isOnRollbackDeleteRows() {
        return this.onRollbackDeleteRows;
    }

    public boolean isOnCommitDeleteRows() {
        return this.onCommitDeleteRows;
    }

    public void resetHeapConglomNumber() {
        if (this.tableType != 3) {
            SanityManager.THROWASSERT((String)("tableType expected to be TableDescriptor.GLOBAL_TEMPORARY_TABLE_TYPE, not " + this.tableType));
        }
        this.heapConglomNumber = -1L;
    }

    public ExecRow getEmptyExecRow() throws StandardException {
        int columnCount = this.getNumberOfColumns();
        ExecRow result = this.getDataDictionary().getExecutionFactory().getValueRow(columnCount);
        for (int index = 0; index < columnCount; ++index) {
            ColumnDescriptor cd = this.columnDescriptorList.elementAt(index);
            DataValueDescriptor dataValue = cd.getType().getNull();
            result.setColumn(index + 1, dataValue);
        }
        return result;
    }

    public int[] getColumnCollationIds() throws StandardException {
        int[] collation_ids = new int[this.getNumberOfColumns()];
        for (int index = 0; index < collation_ids.length; ++index) {
            ColumnDescriptor cd = this.columnDescriptorList.elementAt(index);
            collation_ids[index] = cd.getType().getCollationType();
        }
        return collation_ids;
    }

    public ConglomerateDescriptorList getConglomerateDescriptorList() {
        return this.conglomerateDescriptorList;
    }

    public ViewDescriptor getViewDescriptor() {
        return this.viewDescriptor;
    }

    public void setViewDescriptor(ViewDescriptor viewDescriptor) {
        if (this.tableType != 2) {
            SanityManager.THROWASSERT((String)("tableType expected to be TableDescriptor.VIEW_TYPE, not " + this.tableType));
        }
        this.viewDescriptor = viewDescriptor;
    }

    @Override
    public boolean isDescriptorPersistent() {
        if (this.tableType == 3) {
            return false;
        }
        return super.isDescriptorPersistent();
    }

    public boolean isSynonymDescriptor() {
        return this.tableType == 4;
    }

    public int getTotalNumberOfIndexes() throws StandardException {
        int totalNumberOfIndexes = 0;
        ConglomerateDescriptor[] cds = this.getConglomerateDescriptors();
        for (int index = 0; index < cds.length; ++index) {
            if (!cds[index].isIndex()) continue;
            ++totalNumberOfIndexes;
        }
        return totalNumberOfIndexes;
    }

    public void getAllRelevantTriggers(int statementType, int[] changedColumnIds, GenericDescriptorList relevantTriggers) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        Enumeration descs = dd.getTriggerDescriptors(this).elements();
        while (descs.hasMoreElements()) {
            TriggerDescriptor tgr = (TriggerDescriptor)descs.nextElement();
            if (!tgr.needsToFire(statementType, changedColumnIds)) continue;
            relevantTriggers.add(tgr);
        }
    }

    public void getAllRelevantConstraints(int statementType, boolean skipCheckConstraints, int[] changedColumnIds, boolean[] needsDeferredProcessing, ConstraintDescriptorList relevantConstraints) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        ConstraintDescriptorList cdl = dd.getConstraintDescriptors(this);
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ConstraintDescriptor cd = cdl.elementAt(index);
            if (skipCheckConstraints && cd.getConstraintType() == 4) continue;
            if (!needsDeferredProcessing[0] && cd instanceof ReferencedKeyConstraintDescriptor && statementType != 3 && statementType != 2) {
                needsDeferredProcessing[0] = ((ReferencedKeyConstraintDescriptor)cd).hasSelfReferencingFK(cdl, 1);
            }
            if (!cd.needsToFire(statementType, changedColumnIds)) continue;
            if (cd instanceof ReferencedKeyConstraintDescriptor && (statementType == 3 || statementType == 2)) {
                needsDeferredProcessing[0] = true;
            }
            relevantConstraints.add(cd);
        }
    }

    @Override
    public DependableFinder getDependableFinder() {
        if (this.referencedColumnMap == null) {
            return this.getDependableFinder(137);
        }
        return this.getColumnDependableFinder(393, this.referencedColumnMap.getByteArray());
    }

    @Override
    public String getObjectName() {
        if (this.referencedColumnMap == null) {
            return this.tableName;
        }
        String name = new String(this.tableName);
        boolean first = true;
        for (int i = 0; i < this.columnDescriptorList.size(); ++i) {
            ColumnDescriptor cd = this.columnDescriptorList.elementAt(i);
            if (!this.referencedColumnMap.isSet(cd.getPosition())) continue;
            if (first) {
                name = name + "(" + cd.getColumnName();
                first = false;
                continue;
            }
            name = name + ", " + cd.getColumnName();
        }
        if (!first) {
            name = name + ")";
        }
        return name;
    }

    @Override
    public UUID getObjectID() {
        return this.oid;
    }

    @Override
    public String getClassType() {
        return "Table";
    }

    public String toString() {
        String tempString = "SCHEMA:\n" + this.schema + "\ntableName: " + this.tableName + "\n" + "oid: " + this.oid + " tableType: " + this.tableType + "\n" + "conglomerateDescriptorList: " + this.conglomerateDescriptorList + "\n" + "columnDescriptorList: " + this.columnDescriptorList + "\n" + "constraintDescriptorList: " + this.constraintDescriptorList + "\n" + "heapConglomNumber: " + this.heapConglomNumber + "\n";
        if (this.tableType == 3) {
            tempString = tempString + "onCommitDeleteRows: " + "\n" + this.onCommitDeleteRows + "\n";
            tempString = tempString + "onRollbackDeleteRows: " + "\n" + this.onRollbackDeleteRows + "\n";
        } else {
            tempString = tempString + "lockGranularity: " + this.lockGranularity + "\n";
        }
        return tempString;
    }

    public ColumnDescriptorList getColumnDescriptorList() {
        return this.columnDescriptorList;
    }

    public ConstraintDescriptorList getConstraintDescriptorList() throws StandardException {
        return this.constraintDescriptorList;
    }

    public void setConstraintDescriptorList(ConstraintDescriptorList newCDL) {
        this.constraintDescriptorList = newCDL;
    }

    public void emptyConstraintDescriptorList() throws StandardException {
        this.constraintDescriptorList = new ConstraintDescriptorList();
    }

    public ReferencedKeyConstraintDescriptor getPrimaryKey() throws StandardException {
        ConstraintDescriptorList cdl = this.getDataDictionary().getConstraintDescriptors(this);
        return cdl.getPrimaryKey();
    }

    public long getPrimaryKeyIndexID() throws StandardException {
        ReferencedKeyConstraintDescriptor rkcd = this.getPrimaryKey();
        return rkcd == null ? -1L : rkcd.getIndexConglomerateDescriptor(this.getDataDictionary()).getConglomerateNumber();
    }

    public GenericDescriptorList getTriggerDescriptorList() throws StandardException {
        return this.triggerDescriptorList;
    }

    public void setTriggerDescriptorList(GenericDescriptorList newCDL) {
        this.triggerDescriptorList = newCDL;
    }

    public void emptyTriggerDescriptorList() throws StandardException {
        this.triggerDescriptorList = new GenericDescriptorList();
    }

    public boolean tableNameEquals(String otherTableName, String otherSchemaName) {
        String schemaName = this.getSchemaName();
        if (schemaName == null || otherSchemaName == null) {
            return this.tableName.equals(otherTableName);
        }
        return schemaName.equals(otherSchemaName) && this.tableName.equals(otherTableName);
    }

    public void removeConglomerateDescriptor(ConglomerateDescriptor cd) throws StandardException {
        this.conglomerateDescriptorList.dropConglomerateDescriptor(this.getUUID(), cd);
    }

    public void removeConstraintDescriptor(ConstraintDescriptor cd) throws StandardException {
        this.constraintDescriptorList.remove(cd);
    }

    public ColumnDescriptor getColumnDescriptor(String columnName) {
        return this.columnDescriptorList.getColumnDescriptor(this.oid, columnName);
    }

    public ColumnDescriptor getColumnDescriptor(int columnNumber) {
        return this.columnDescriptorList.getColumnDescriptor(this.oid, columnNumber);
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors() {
        int size = this.conglomerateDescriptorList.size();
        ConglomerateDescriptor[] cdls = new ConglomerateDescriptor[size];
        this.conglomerateDescriptorList.toArray(cdls);
        return cdls;
    }

    public ConglomerateDescriptor getConglomerateDescriptor(long conglomerateNumber) throws StandardException {
        return this.conglomerateDescriptorList.getConglomerateDescriptor(conglomerateNumber);
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(long conglomerateNumber) throws StandardException {
        return this.conglomerateDescriptorList.getConglomerateDescriptors(conglomerateNumber);
    }

    public ConglomerateDescriptor getConglomerateDescriptor(UUID conglomerateUUID) throws StandardException {
        return this.conglomerateDescriptorList.getConglomerateDescriptor(conglomerateUUID);
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(UUID conglomerateUUID) throws StandardException {
        return this.conglomerateDescriptorList.getConglomerateDescriptors(conglomerateUUID);
    }

    public IndexLister getIndexLister() throws StandardException {
        return new IndexLister(this);
    }

    public boolean tableHasAutoincrement() {
        int cdlSize = this.getColumnDescriptorList().size();
        for (int index = 0; index < cdlSize; ++index) {
            ColumnDescriptor cd = this.columnDescriptorList.elementAt(index);
            if (!cd.isAutoincrement()) continue;
            return true;
        }
        return false;
    }

    public String[] getColumnNamesArray() {
        int size = this.getNumberOfColumns();
        String[] s = new String[size];
        for (int i = 0; i < size; ++i) {
            s[i] = this.getColumnDescriptor(i + 1).getColumnName();
        }
        return s;
    }

    public long[] getAutoincIncrementArray() {
        if (!this.tableHasAutoincrement()) {
            return null;
        }
        int size = this.getNumberOfColumns();
        long[] inc = new long[size];
        for (int i = 0; i < size; ++i) {
            ColumnDescriptor cd = this.getColumnDescriptor(i + 1);
            if (!cd.isAutoincrement()) continue;
            inc[i] = cd.getAutoincInc();
        }
        return inc;
    }

    private synchronized List getStatistics() throws StandardException {
        if (this.statisticsDescriptorList != null) {
            return this.statisticsDescriptorList;
        }
        DataDictionary dd = this.getDataDictionary();
        this.statisticsDescriptorList = dd.getStatisticsDescriptors(this);
        return this.statisticsDescriptorList;
    }

    public boolean statisticsExist(ConglomerateDescriptor cd) throws StandardException {
        return true;
    }

    public double selectivityForConglomerate(ConglomerateDescriptor cd, int numKeys) throws StandardException {
        if (!this.statisticsExist(cd)) {
            SanityManager.THROWASSERT((String)("no statistics exist for conglomerate" + cd));
        }
        CompilerContext cc = (CompilerContext)ContextService.getContextOrNull("CompilerContext");
        assert (cc != null);
        long numRows = cc.getStoreCostController(cd.getConglomerateNumber()).getEstimatedRowCount();
        if (!cd.isIndex()) {
            return 1.0;
        }
        if (numRows == 0L) {
            return 0.1;
        }
        int numCols = cd.getIndexDescriptor().baseColumnPositions().length;
        return (double)(numCols * numCols) / ((double)numRows * (double)numKeys * (double)numKeys);
    }

    @Override
    public String getDescriptorName() {
        return this.tableName;
    }

    @Override
    public String getDescriptorType() {
        return this.tableType == 4 ? "Synonym" : "Table/View";
    }

    @Override
    public synchronized boolean isValid() {
        return true;
    }

    @Override
    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        switch (action) {
            default: 
        }
        throw StandardException.newException("X0Y29.S", (Object)dm.getActionString(action), (Object)p.getObjectName(), (Object)this.getQualifiedName());
    }

    @Override
    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        SanityManager.THROWASSERT((String)("makeInvalid(" + dm.getActionString(action) + ") not expected to get called"));
    }

    public void setDistributionDescriptor(DistributionDescriptor distributionDesc) {
        this.distributionDesc = distributionDesc;
    }

    public DistributionDescriptor getDistributionDescriptor() throws StandardException {
        return this.distributionDesc;
    }

    public void setRouteQueryToAllNodes(boolean flag) {
        this.skipRouteQueryToAllNodes = !flag;
    }

    public boolean routeQueryToAllNodes() {
        return this.tableType == 5 && !this.skipRouteQueryToAllNodes;
    }

    public DistributionDescriptor getDistributionDescriptorFromResolver() throws StandardException {
        Region<?, ?> region = this.getRegion();
        if (region == null) {
            return null;
        }
        PartitionAttributes partAttributes = region.getAttributes().getPartitionAttributes();
        if (partAttributes == null) {
            return this.getDataDictionary().getDataDescriptorGenerator().newDistributionDescriptor(1, null, 0, 0, null, false, new TreeSet<String>());
        }
        GfxdPartitionResolver partResolver = this.getPartitionResolver(partAttributes);
        assert (partResolver != null) : "Resolver is not expected to be null at this point.";
        return partResolver.getDistributionDescriptor();
    }

    public Region<?, ?> getRegion() {
        String fullName = Misc.getFullTableName(this, null);
        Region region = null;
        try {
            region = Misc.getRegionForTableByPath(fullName, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return region;
    }

    public GfxdPartitionResolver getPartitionResolver(PartitionAttributes<?, ?> pAttribs) {
        PartitionAttributes partAttributes;
        if (pAttribs == null) {
            Region<?, ?> region = this.getRegion();
            if (region == null) {
                return null;
            }
            partAttributes = region.getAttributes().getPartitionAttributes();
            if (partAttributes == null) {
                return null;
            }
        } else {
            partAttributes = pAttribs;
        }
        PartitionResolver partResolver = partAttributes.getPartitionResolver();
        assert (partResolver instanceof GfxdPartitionResolver) : "partResolver = " + partResolver + " which is expected to be non-null & instanceof GfxdPR.";
        return (GfxdPartitionResolver)partResolver;
    }

    public int hashCode() {
        SchemaDescriptor sd = this.schema;
        String name = this.tableName;
        if (sd != null) {
            return sd.getSchemaName().hashCode() ^ name.hashCode();
        }
        return name.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof TableDescriptor) {
            return this.equals((TableDescriptor)other);
        }
        return false;
    }

    public boolean equals(TableDescriptor otherTD) {
        if (otherTD == this) {
            return true;
        }
        SchemaDescriptor sd = this.schema;
        SchemaDescriptor otherSD = otherTD.schema;
        if (sd != null && otherSD != null) {
            return sd.getSchemaName().equals(otherSD.getSchemaName()) && this.tableName.equals(otherTD.tableName);
        }
        return false;
    }
}

