/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.io;

import com.pivotal.gemfirexd.internal.iapi.services.io.Limit;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;

public class CounterOutputStream
extends OutputStream
implements Limit {
    protected OutputStream out;
    private int count;
    private int limit;

    public void setOutputStream(OutputStream out) {
        this.out = out;
        this.setLimit(-1);
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public void setLimit(int limit) {
        this.count = 0;
        this.limit = limit;
    }

    @Override
    public int clearLimit() {
        int unused = this.limit - this.count;
        this.limit = 0;
        return unused;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.limit >= 0 && this.count + 1 > this.limit) {
            throw new EOFException();
        }
        this.out.write(b);
        ++this.count;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.limit >= 0 && this.count + b.length > this.limit) {
            throw new EOFException();
        }
        this.out.write(b);
        this.count += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.limit >= 0 && this.count + len > this.limit) {
            throw new EOFException();
        }
        this.out.write(b, off, len);
        this.count += len;
    }
}

