/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.internal.shared.ClientSharedData;
import com.pivotal.gemfirexd.callbacks.TableMetaData;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.NonUpdatableRowsResultSet;
import com.pivotal.gemfirexd.internal.engine.store.ProjectionMetaData;
import com.pivotal.gemfirexd.internal.engine.store.ResultWasNull;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.NewByteArrayInputStream;
import com.pivotal.gemfirexd.internal.impl.jdbc.ReaderToAscii;
import com.pivotal.gemfirexd.internal.impl.jdbc.TransactionResourceImpl;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;

public final class RawStoreResultSet
extends NonUpdatableRowsResultSet
implements ResultSet,
ResultWasNull {
    private byte[] currentRowBytes;
    private byte[][] currentRowByteArrays;
    private Iterator<Object> rows;
    private final int numColumns;
    private final RowFormatter formatter;
    private int[] changedColumns;
    private TableMetaData metadata;
    private GregorianCalendar cal;
    private boolean nextCalledForOneRowResult = false;

    public RawStoreResultSet(byte[] row, RowFormatter rf) {
        this.currentRowBytes = row;
        this.formatter = rf;
        this.numColumns = rf.getNumColumns();
    }

    public RawStoreResultSet(byte[] row, RowFormatter rf, int[] changedColumns, TableMetaData metadata) {
        this.currentRowBytes = row;
        this.formatter = rf;
        this.metadata = metadata;
        this.changedColumns = changedColumns;
        this.numColumns = changedColumns.length;
    }

    public RawStoreResultSet(byte[][] row, RowFormatter rf) {
        this.currentRowByteArrays = row;
        this.formatter = rf;
        this.numColumns = rf.getNumColumns();
    }

    public RawStoreResultSet(byte[][] row, RowFormatter rf, int[] changedColumns, TableMetaData metadata) {
        this.currentRowByteArrays = row;
        this.formatter = rf;
        this.metadata = metadata;
        this.changedColumns = changedColumns;
        this.numColumns = changedColumns.length;
    }

    public RawStoreResultSet(List<Object> rows, RowFormatter rf) {
        this.rows = rows.iterator();
        this.formatter = rf;
        this.numColumns = rf.getNumColumns();
    }

    public RawStoreResultSet(List<Object> rows, RowFormatter rf, int[] changedColumns, TableMetaData metadata) {
        this.rows = rows.iterator();
        this.formatter = rf;
        this.metadata = metadata;
        this.changedColumns = changedColumns;
        this.numColumns = changedColumns.length;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.rows != null) {
            if (this.rows.hasNext()) {
                Object next = this.rows.next();
                if (next.getClass() == byte[].class) {
                    this.currentRowBytes = (byte[])next;
                } else {
                    this.currentRowByteArrays = (byte[][])next;
                }
                return true;
            }
            return false;
        }
        boolean prevVal = this.nextCalledForOneRowResult;
        if (prevVal) {
            this.currentRowByteArrays = null;
            this.currentRowBytes = null;
        }
        this.nextCalledForOneRowResult = true;
        return !prevVal && (this.currentRowByteArrays != null || this.currentRowBytes != null);
    }

    @Override
    public void close() throws SQLException {
        this.currentRowBytes = null;
        this.currentRowByteArrays = null;
        this.rows = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.currentRowBytes == null && this.currentRowByteArrays == null && this.rows == null;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                this.wasNull = false;
                if (this.currentRowBytes != null) {
                    if (this.changedColumns == null) {
                        return this.formatter.getAsString(columnIndex, this.currentRowBytes, (ResultWasNull)this);
                    }
                    return this.formatter.getAsString(this.changedColumns[columnIndex - 1], this.currentRowBytes, (ResultWasNull)this);
                }
                if (this.changedColumns == null) {
                    return this.formatter.getAsString(columnIndex, this.currentRowByteArrays, (ResultWasNull)this);
                }
                return this.formatter.getAsString(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                this.wasNull = false;
                if (this.currentRowBytes != null) {
                    if (this.changedColumns == null) {
                        return this.formatter.getAsObject(columnIndex, this.currentRowBytes, (ResultWasNull)this);
                    }
                    return this.formatter.getAsObject(this.changedColumns[columnIndex - 1], this.currentRowBytes, (ResultWasNull)this);
                }
                if (this.changedColumns == null) {
                    return this.formatter.getAsObject(columnIndex, this.currentRowByteArrays, (ResultWasNull)this);
                }
                return this.formatter.getAsObject(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                this.wasNull = false;
                if (this.currentRowBytes != null) {
                    if (this.changedColumns == null) {
                        return this.formatter.getAsBoolean(columnIndex, this.currentRowBytes, (ResultWasNull)this);
                    }
                    return this.formatter.getAsBoolean(this.changedColumns[columnIndex - 1], this.currentRowBytes, (ResultWasNull)this);
                }
                if (this.changedColumns == null) {
                    return this.formatter.getAsBoolean(columnIndex, this.currentRowByteArrays, (ResultWasNull)this);
                }
                return this.formatter.getAsBoolean(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                this.wasNull = false;
                if (this.currentRowBytes != null) {
                    if (this.changedColumns == null) {
                        return this.formatter.getAsByte(columnIndex, this.currentRowBytes, (ResultWasNull)this);
                    }
                    return this.formatter.getAsByte(this.changedColumns[columnIndex - 1], this.currentRowBytes, (ResultWasNull)this);
                }
                if (this.changedColumns == null) {
                    return this.formatter.getAsByte(columnIndex, this.currentRowByteArrays, (ResultWasNull)this);
                }
                return this.formatter.getAsByte(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                this.wasNull = false;
                if (this.currentRowBytes != null) {
                    if (this.changedColumns == null) {
                        return this.formatter.getAsShort(columnIndex, this.currentRowBytes, (ResultWasNull)this);
                    }
                    return this.formatter.getAsShort(this.changedColumns[columnIndex - 1], this.currentRowBytes, (ResultWasNull)this);
                }
                if (this.changedColumns == null) {
                    return this.formatter.getAsShort(columnIndex, this.currentRowByteArrays, (ResultWasNull)this);
                }
                return this.formatter.getAsShort(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                this.wasNull = false;
                if (this.currentRowBytes != null) {
                    if (this.changedColumns == null) {
                        return this.formatter.getAsInt(columnIndex, this.currentRowBytes, (ResultWasNull)this);
                    }
                    return this.formatter.getAsInt(this.changedColumns[columnIndex - 1], this.currentRowBytes, (ResultWasNull)this);
                }
                if (this.changedColumns == null) {
                    return this.formatter.getAsInt(columnIndex, this.currentRowByteArrays, (ResultWasNull)this);
                }
                return this.formatter.getAsInt(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                this.wasNull = false;
                if (this.currentRowBytes != null) {
                    if (this.changedColumns == null) {
                        return this.formatter.getAsLong(columnIndex, this.currentRowBytes, (ResultWasNull)this);
                    }
                    return this.formatter.getAsLong(this.changedColumns[columnIndex - 1], this.currentRowBytes, (ResultWasNull)this);
                }
                if (this.changedColumns == null) {
                    return this.formatter.getAsLong(columnIndex, this.currentRowByteArrays, (ResultWasNull)this);
                }
                return this.formatter.getAsLong(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                this.wasNull = false;
                if (this.currentRowBytes != null) {
                    if (this.changedColumns == null) {
                        return this.formatter.getAsFloat(columnIndex, this.currentRowBytes, (ResultWasNull)this);
                    }
                    return this.formatter.getAsFloat(this.changedColumns[columnIndex - 1], this.currentRowBytes, (ResultWasNull)this);
                }
                if (this.changedColumns == null) {
                    return this.formatter.getAsFloat(columnIndex, this.currentRowByteArrays, (ResultWasNull)this);
                }
                return this.formatter.getAsFloat(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                this.wasNull = false;
                if (this.currentRowBytes != null) {
                    if (this.changedColumns == null) {
                        return this.formatter.getAsDouble(columnIndex, this.currentRowBytes, (ResultWasNull)this);
                    }
                    return this.formatter.getAsDouble(this.changedColumns[columnIndex - 1], this.currentRowBytes, (ResultWasNull)this);
                }
                if (this.changedColumns == null) {
                    return this.formatter.getAsDouble(columnIndex, this.currentRowByteArrays, (ResultWasNull)this);
                }
                return this.formatter.getAsDouble(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal ret = this.getBigDecimal(columnIndex);
        if (ret != null) {
            return ret.setScale(scale, 5);
        }
        return null;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                this.wasNull = false;
                if (this.currentRowBytes != null) {
                    if (this.changedColumns == null) {
                        return this.formatter.getAsBytes(columnIndex, this.currentRowBytes, (ResultWasNull)this);
                    }
                    return this.formatter.getAsBytes(this.changedColumns[columnIndex - 1], this.currentRowBytes, (ResultWasNull)this);
                }
                if (this.changedColumns == null) {
                    return this.formatter.getAsBytes(columnIndex, this.currentRowByteArrays, (ResultWasNull)this);
                }
                return this.formatter.getAsBytes(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                this.wasNull = false;
                GregorianCalendar cal = this.getCal();
                if (this.currentRowBytes != null) {
                    if (this.changedColumns == null) {
                        return this.formatter.getAsDate(columnIndex, this.currentRowBytes, (Calendar)cal, (ResultWasNull)this);
                    }
                    return this.formatter.getAsDate(this.changedColumns[columnIndex - 1], this.currentRowBytes, (Calendar)cal, (ResultWasNull)this);
                }
                if (this.changedColumns == null) {
                    return this.formatter.getAsDate(columnIndex, this.currentRowByteArrays, (Calendar)cal, (ResultWasNull)this);
                }
                return this.formatter.getAsDate(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, (Calendar)cal, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                this.wasNull = false;
                GregorianCalendar cal = this.getCal();
                if (this.currentRowBytes != null) {
                    if (this.changedColumns == null) {
                        return this.formatter.getAsTime(columnIndex, this.currentRowBytes, (Calendar)cal, (ResultWasNull)this);
                    }
                    return this.formatter.getAsTime(this.changedColumns[columnIndex - 1], this.currentRowBytes, (Calendar)cal, (ResultWasNull)this);
                }
                if (this.changedColumns == null) {
                    return this.formatter.getAsTime(columnIndex, this.currentRowByteArrays, (Calendar)cal, (ResultWasNull)this);
                }
                return this.formatter.getAsTime(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, (Calendar)cal, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                this.wasNull = false;
                GregorianCalendar cal = this.getCal();
                if (this.currentRowBytes != null) {
                    if (this.changedColumns == null) {
                        return this.formatter.getAsTimestamp(columnIndex, this.currentRowBytes, (Calendar)cal, (ResultWasNull)this);
                    }
                    return this.formatter.getAsTimestamp(this.changedColumns[columnIndex - 1], this.currentRowBytes, (Calendar)cal, (ResultWasNull)this);
                }
                if (this.changedColumns == null) {
                    return this.formatter.getAsTimestamp(columnIndex, this.currentRowByteArrays, (Calendar)cal, (ResultWasNull)this);
                }
                return this.formatter.getAsTimestamp(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, (Calendar)cal, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                this.wasNull = false;
                if (this.currentRowBytes != null) {
                    if (this.changedColumns == null) {
                        return this.formatter.getAsBigDecimal(columnIndex, this.currentRowBytes, (ResultWasNull)this);
                    }
                    return this.formatter.getAsBigDecimal(this.changedColumns[columnIndex - 1], this.currentRowBytes, (ResultWasNull)this);
                }
                if (this.changedColumns == null) {
                    return this.formatter.getAsBigDecimal(columnIndex, this.currentRowByteArrays, (ResultWasNull)this);
                }
                return this.formatter.getAsBigDecimal(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                this.wasNull = false;
                if (cal == null) {
                    cal = this.getCal();
                }
                if (this.currentRowBytes != null) {
                    if (this.changedColumns == null) {
                        return this.formatter.getAsDate(columnIndex, this.currentRowBytes, cal, (ResultWasNull)this);
                    }
                    return this.formatter.getAsDate(this.changedColumns[columnIndex - 1], this.currentRowBytes, cal, (ResultWasNull)this);
                }
                if (this.changedColumns == null) {
                    return this.formatter.getAsDate(columnIndex, this.currentRowByteArrays, cal, (ResultWasNull)this);
                }
                return this.formatter.getAsDate(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, cal, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                this.wasNull = false;
                if (cal == null) {
                    cal = this.getCal();
                }
                if (this.currentRowBytes != null) {
                    if (this.changedColumns == null) {
                        return this.formatter.getAsTime(columnIndex, this.currentRowBytes, cal, (ResultWasNull)this);
                    }
                    return this.formatter.getAsTime(this.changedColumns[columnIndex - 1], this.currentRowBytes, cal, (ResultWasNull)this);
                }
                if (this.changedColumns == null) {
                    return this.formatter.getAsTime(columnIndex, this.currentRowByteArrays, cal, (ResultWasNull)this);
                }
                return this.formatter.getAsTime(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, cal, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                this.wasNull = false;
                if (cal == null) {
                    cal = this.getCal();
                }
                if (this.currentRowBytes != null) {
                    if (this.changedColumns == null) {
                        return this.formatter.getAsTimestamp(columnIndex, this.currentRowBytes, cal, (ResultWasNull)this);
                    }
                    return this.formatter.getAsTimestamp(this.changedColumns[columnIndex - 1], this.currentRowBytes, cal, (ResultWasNull)this);
                }
                if (this.changedColumns == null) {
                    return this.formatter.getAsTimestamp(columnIndex, this.currentRowByteArrays, cal, (ResultWasNull)this);
                }
                return this.formatter.getAsTimestamp(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, cal, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            TableMetaData metadata = this.getMetaData();
            int colType = metadata.getColumnType(columnIndex);
            switch (colType) {
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    return this.getBinaryStream(columnIndex);
                }
                default: {
                    throw this.dataConversionException(metadata.getColumnTypeName(columnIndex), "InputStream(ASCII)", columnIndex);
                }
            }
            Reader reader = this.getCharacterStream(columnIndex);
            if (reader != null) {
                return new ReaderToAscii(reader);
            }
            return null;
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw Util.notImplemented("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            TableMetaData metadata = this.getMetaData();
            int columnType = metadata.getColumnType(columnIndex);
            switch (columnType) {
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    break;
                }
                default: {
                    throw this.dataConversionException(metadata.getColumnTypeName(columnIndex), "InputStream(BINARY)", columnIndex);
                }
            }
            try {
                this.wasNull = false;
                byte[] bytes = this.currentRowBytes != null ? (this.changedColumns == null ? this.formatter.getAsBytes(columnIndex, this.currentRowBytes, (ResultWasNull)this) : this.formatter.getAsBytes(this.changedColumns[columnIndex - 1], this.currentRowBytes, (ResultWasNull)this)) : (this.changedColumns == null ? this.formatter.getAsBytes(columnIndex, this.currentRowByteArrays, (ResultWasNull)this) : this.formatter.getAsBytes(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, (ResultWasNull)this));
                if (bytes != null) {
                    return new NewByteArrayInputStream(bytes);
                }
                return null;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            TableMetaData metadata = this.getMetaData();
            int colType = metadata.getColumnType(columnIndex);
            switch (colType) {
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    InputStream is = this.getBinaryStream(columnIndex);
                    if (is != null) {
                        try {
                            return new InputStreamReader(is, "UTF-16BE");
                        }
                        catch (UnsupportedEncodingException uee) {
                            throw TransactionResourceImpl.wrapInSQLException(uee);
                        }
                    }
                    return null;
                }
                default: {
                    throw this.dataConversionException(metadata.getColumnTypeName(columnIndex), "Reader", columnIndex);
                }
            }
            try {
                this.wasNull = false;
                String str = this.currentRowBytes != null ? (this.changedColumns == null ? this.formatter.getAsString(columnIndex, this.currentRowBytes, (ResultWasNull)this) : this.formatter.getAsString(this.changedColumns[columnIndex - 1], this.currentRowBytes, (ResultWasNull)this)) : (this.changedColumns == null ? this.formatter.getAsString(columnIndex, this.currentRowByteArrays, (ResultWasNull)this) : this.formatter.getAsString(this.changedColumns[columnIndex - 1], this.currentRowByteArrays, (ResultWasNull)this));
                if (str != null) {
                    return new StringReader(str);
                }
                return null;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            TableMetaData metadata = this.getMetaData();
            if (metadata.getColumnType(columnIndex) != 2004) {
                throw this.dataConversionException(metadata.getColumnTypeName(columnIndex), "Blob", columnIndex);
            }
            try {
                this.wasNull = false;
                return this.formatter.getAsBlob(columnIndex, this.currentRowByteArrays, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            TableMetaData metadata = this.getMetaData();
            if (metadata.getColumnType(columnIndex) != 2005) {
                throw this.dataConversionException(metadata.getColumnTypeName(columnIndex), "Clob", columnIndex);
            }
            try {
                this.wasNull = false;
                return this.formatter.getAsClob(columnIndex, this.currentRowByteArrays, (ResultWasNull)this);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.getMetaData().getColumnPosition(columnLabel);
    }

    @Override
    public TableMetaData getMetaData() throws SQLException {
        if (this.metadata != null) {
            return this.metadata;
        }
        if (this.formatter != null) {
            if (this.changedColumns == null) {
                this.metadata = this.formatter.getMetaData();
                return this.metadata;
            }
            this.metadata = new ProjectionMetaData(this.formatter.getMetaData(), this.changedColumns);
            return this.metadata;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("RawResultSet");
        try {
            boolean hasNext;
            boolean bl = hasNext = this.rows != null ? this.next() : true;
            while (hasNext) {
                sb.append(" {");
                for (int i = 1; i <= this.numColumns; ++i) {
                    sb.append(this.getObject(i)).append(',');
                }
                sb.setCharAt(sb.length() - 1, '}');
                hasNext = this.next();
            }
        }
        catch (SQLException sqle) {
            throw GemFireXDRuntimeException.newRuntimeException(null, sqle);
        }
        return sb.toString();
    }

    private GregorianCalendar getCal() {
        GregorianCalendar cal = this.cal;
        if (cal != null) {
            cal.clear();
            return cal;
        }
        this.cal = ClientSharedData.getDefaultCleanCalendar();
        return this.cal;
    }
}

