/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.catalog.ExternalCatalog;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdQueryResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdQueryStreamingResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.message.LeadNodeExecutorMsg;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.TableQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.SnappySelectResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TemporaryRowHolder;
import com.pivotal.gemfirexd.internal.impl.sql.GenericResultDescription;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.snappy.LeadNodeExecutionContext;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.List;
import java.util.Vector;

public class SnappyActivation
extends BaseActivation {
    volatile AbstractGemFireResultSet currentRS = null;
    private String sql;
    boolean returnRows;

    public SnappyActivation(LanguageConnectionContext lcc, ExecPreparedStatement eps, boolean returnRows) {
        super(lcc);
        this.sql = eps.getSource();
        this.preStmt = eps;
        this.returnRows = returnRows;
        this.connectionID = lcc.getConnectionId();
    }

    @Override
    public void setupActivation(ExecPreparedStatement ps, boolean scrollable, String stmt_text) throws StandardException {
    }

    @Override
    public final void checkStatementValidity() throws StandardException {
    }

    @Override
    public final ResultSet execute() throws StandardException {
        try {
            this.currentRS = null;
            SnappySelectResultSet rs = this.createResultSet(0);
            if (GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("SnappyActivation.execute: Created SnappySelectResultSet: " + rs));
            }
            rs.open();
            this.resultSet = rs;
            this.executeWithResultSet(rs);
            this.currentRS = rs;
            if (GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"SnappyActivation.execute: Done");
            }
            return rs;
        }
        catch (GemFireXDRuntimeException gfxdrtex) {
            StandardException cause = this.getCause(gfxdrtex);
            if (cause != null) {
                throw cause;
            }
            throw gfxdrtex;
        }
    }

    private StandardException getCause(GemFireXDRuntimeException gfxe) {
        for (Throwable cause = gfxe.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof StandardException)) continue;
            return (StandardException)cause;
        }
        return null;
    }

    protected SnappySelectResultSet createResultSet(int resultsetNumber) throws StandardException {
        return new SnappySelectResultSet(this, this.returnRows);
    }

    protected void executeWithResultSet(SnappySelectResultSet rs) throws StandardException {
        boolean enableStreaming = this.lcc.streamingEnabled();
        GfxdResultCollector<Object> rc = null;
        rc = this.getResultCollector(enableStreaming, rs);
        SnappyActivation.executeOnLeadNode(rs, rc, this.sql, enableStreaming, this.getConnectionID(), this.lcc.getCurrentSchemaName());
    }

    protected GfxdResultCollector<Object> getResultCollector(boolean enableStreaming, SnappySelectResultSet rs) throws StandardException {
        AbstractCollection rc = enableStreaming ? new GfxdQueryStreamingResultCollector() : new GfxdQueryResultCollector();
        rs.setupRC((GfxdResultCollector<?>)((Object)rc));
        return rc;
    }

    @Override
    public boolean checkIfThisActivationHasHoldCursor(String tableName) {
        return false;
    }

    @Override
    public Vector getParentResultSet(String resultSetId) {
        throw new UnsupportedOperationException("SnappyActivation::getParentResultSet: not implemented");
    }

    @Override
    public ResultDescription getResultDescription() {
        if (this.resultDescription == null) {
            this.resultDescription = SnappyActivation.makeResultDescription(this.resultSet);
        }
        return this.resultDescription;
    }

    public static ResultDescription makeResultDescription(ResultSet resultSet) {
        assert (resultSet != null) : "expected non noll result set";
        assert (resultSet instanceof SnappySelectResultSet) : "expected SnappySelectResultSet type result set";
        SnappySelectResultSet srs = (SnappySelectResultSet)resultSet;
        return srs.makeResultDescription();
    }

    @Override
    public final long estimateMemoryUsage() throws StandardException {
        return -1L;
    }

    @Override
    public void informOfRowCount(NoPutResultSet resultSet, long rowCount) throws StandardException {
        throw new UnsupportedOperationException("SnappyActivation::informOfRowCount: not implemented");
    }

    @Override
    public void setParentResultSet(TemporaryRowHolder rs, String resultSetId) {
        throw new UnsupportedOperationException("SnappyActivation::setParentResultSet: not implemented");
    }

    @Override
    protected int getExecutionCount() {
        throw new UnsupportedOperationException("SnappyActivation::getExecutionCount: not implemented");
    }

    @Override
    protected Vector getRowCountCheckVector() {
        throw new UnsupportedOperationException("SnappyActivation::getRowCountCheckVector: not implemented");
    }

    @Override
    protected int getStalePlanCheckInterval() {
        throw new UnsupportedOperationException("SnappyActivation::getStalePlanCheckInterval: not implemented");
    }

    @Override
    protected void setExecutionCount(int newValue) {
        throw new UnsupportedOperationException("SnappyActivation::setExecutionCount: not implemented");
    }

    @Override
    protected void setRowCountCheckVector(Vector newValue) {
        throw new UnsupportedOperationException("SnappyActivation::setRowCountCheckVector: not implemented");
    }

    @Override
    protected void setStalePlanCheckInterval(int newValue) {
        throw new UnsupportedOperationException("SnappyActivation::setStalePlanCheckInterval: not implemented");
    }

    @Override
    public void postConstructor() throws StandardException {
        throw new UnsupportedOperationException("SnappyActivation::postConstructor: not implemented");
    }

    public void setResultDescription(GenericResultDescription resultDescription) {
        this.resultDescription = resultDescription;
    }

    public static void executeOnLeadNode(SnappySelectResultSet rs, GfxdResultCollector<Object> rc, String sql, boolean enableStreaming, long connId, String schema) throws StandardException {
        LeadNodeExecutionContext ctx = new LeadNodeExecutionContext(connId);
        LeadNodeExecutorMsg msg = new LeadNodeExecutorMsg(sql, schema, ctx, rc);
        try {
            msg.executeFunction(enableStreaming, false, rs, true);
        }
        catch (SQLException se) {
            throw Misc.processFunctionException("SnappyActivation::execute", se, null, null);
        }
    }

    public static boolean isColumnTable(DMLQueryInfo dmlQueryInfo, boolean skipLocks) {
        List<TableQueryInfo> allTables;
        ExternalCatalog extCatalog;
        if (dmlQueryInfo != null && (extCatalog = Misc.getMemStore().getExternalCatalog()) != null && (allTables = dmlQueryInfo.getTableQueryInfoList()) != null) {
            for (TableQueryInfo t : allTables) {
                LocalRegion region;
                if (null == t || (region = t.getRegion()) != null && region.getScope().isLocal()) continue;
                String tabName = t.getFullTableName();
                boolean isColumnTable = extCatalog.isColumnTable(t.getSchemaName(), t.getTableName(), skipLocks);
                if (GemFireXDUtils.TraceQuery) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("SnappyActivation.isColumnTable: table-name=" + tabName + " ,isColumnTable=" + isColumnTable));
                }
                if (!isColumnTable) continue;
                return isColumnTable;
            }
        }
        if (GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"SnappyActivation.isColumnTable: return false");
        }
        return false;
    }
}

