/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DynamicKey;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.UpdateQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.reflect.GemFireActivationClass;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ActivationStatisticsVisitor;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireUpdateResultSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class GemFireUpdateActivation
extends AbstractGemFireActivation {
    private final GemFireContainer container;
    private MultipleKeyValueHolder mkvh;
    private long batchSize;

    public GemFireUpdateActivation(ExecPreparedStatement st, LanguageConnectionContext _lcc, DMLQueryInfo qi, GemFireActivationClass gc) throws StandardException {
        super(st, _lcc, qi);
        this.container = (GemFireContainer)this.qInfo.getRegion().getUserAttribute();
    }

    @Override
    protected void executeWithResultSet(AbstractGemFireResultSet rs) throws StandardException {
        int i;
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        GemFireTransaction tran = (GemFireTransaction)lcc.getTransactionExecute();
        TXStateInterface tx = this.container.getActiveTXState(tran);
        boolean isTransactional = tx != null;
        Object pk = this.qInfo.getPrimaryKey();
        Object[] gfKeys = null;
        if (pk instanceof Object[]) {
            if (this.qInfo.isWhereClauseDynamic()) {
                Object[] pks = (Object[])pk;
                int len = pks.length;
                gfKeys = new Object[len];
                for (i = 0; i < len; ++i) {
                    if (!(pks[i] instanceof DynamicKey)) continue;
                    DynamicKey dk = (DynamicKey)pks[i];
                    gfKeys[i] = dk.getEvaluatedPrimaryKey(this, this.container, isTransactional);
                }
            } else {
                gfKeys = (Object[])pk;
            }
        } else {
            gfKeys = new Object[1];
            if (this.qInfo.isWhereClauseDynamic()) {
                DynamicKey dk = (DynamicKey)pk;
                pk = dk.getEvaluatedPrimaryKey(this, this.container, isTransactional);
            }
            gfKeys[0] = pk;
        }
        if (this.observer != null) {
            this.observer.beforeGemFireResultSetExecuteOnActivation(this);
        }
        int numRowsModified = 0;
        Object[] tmpResult = new Object[2];
        for (i = 0; i < gfKeys.length; ++i) {
            ((UpdateQueryInfo)this.qInfo).getChangedRowAndFormatableBitSet(this, gfKeys[i], tmpResult);
            DataValueDescriptor[] dvds = (DataValueDescriptor[])tmpResult[0];
            if (isTransactional || this.isPreparedBatch) {
                for (int index = 0; index < dvds.length; ++index) {
                    if (dvds[index] == null) continue;
                    dvds[index] = dvds[index].getClone();
                }
            }
            try {
                LocalRegion rgn;
                boolean flush = false;
                if (this.isPreparedBatch) {
                    this.batchSize += ValueRow.estimateDVDArraySize(dvds);
                    if (this.mkvh == null) {
                        this.mkvh = new MultipleKeyValueHolder();
                    }
                    if (this.batchSize > GemFireXDUtils.DML_MAX_CHUNK_SIZE) {
                        flush = true;
                        this.batchSize = 0L;
                    }
                }
                this.container.replacePartialRow(gfKeys[i], (FormatableBitSet)tmpResult[1], dvds, null, tran, tx, lcc, this.mkvh, flush);
                if (flush) {
                    this.mkvh = null;
                }
                if (isTransactional && (rgn = this.container.getRegion()).isSerialWanEnabled()) {
                    this.distributeBulkOpToDBSynchronizer(rgn, this.qInfo.isDynamic(), tran, this.lcc.isSkipListeners());
                }
                ++numRowsModified;
                continue;
            }
            catch (EntryNotFoundException e) {
                GemFireXDUtils.checkForInsufficientDataStore(this.container.getRegion());
                continue;
            }
            catch (EntryDestroyedException e) {
                continue;
            }
            catch (GemFireException gfeex) {
                throw Misc.processGemFireException(gfeex, gfeex, "execution of " + this.preStmt.getSource(), true);
            }
        }
        if (this.observer != null) {
            this.observer.afterGemFireResultSetExecuteOnActivation(this);
        }
        rs.setNumRowsModified(numRowsModified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flushBatch() throws StandardException {
        int numRowsModified = 0;
        try {
            VersionedObjectList result;
            if (this.mkvh != null && this.mkvh.toBeInsertedDeltas != null && (result = this.container.doPutAllOfAllDeltas(this.mkvh, this.lcc)) != null) {
                numRowsModified = result.size();
            }
        }
        catch (EntryNotFoundException e) {
            GemFireXDUtils.checkForInsufficientDataStore(this.container.getRegion());
        }
        catch (EntryDestroyedException entryDestroyedException) {
        }
        finally {
            this.mkvh = null;
        }
        if (this.resultSet instanceof AbstractGemFireResultSet) {
            ((AbstractGemFireResultSet)this.resultSet).setNumRowsModified(numRowsModified);
        }
    }

    @Override
    protected AbstractGemFireResultSet createResultSet(int resultsetNum) throws StandardException {
        return new GemFireUpdateResultSet(this);
    }

    @Override
    public void accept(ActivationStatisticsVisitor visitor) {
        visitor.visit(this);
    }

    public static final class MultipleKeyValueHolder {
        private LinkedHashMap<Object, Object> toBeInsertedDeltas;
        private ArrayList<Object> callbackArgs;

        public void addKeyValueAndCallbackArg(Object key, GemFireContainer.SerializableDelta delta, Object sca) {
            if (this.toBeInsertedDeltas == null) {
                this.toBeInsertedDeltas = new LinkedHashMap();
                this.callbackArgs = new ArrayList();
            }
            this.toBeInsertedDeltas.put(key, delta);
            this.callbackArgs.add(sca);
        }

        public LinkedHashMap<Object, Object> getToBeInsertedDeltas() {
            return this.toBeInsertedDeltas;
        }

        public ArrayList<Object> getCallbackArgs() {
            return this.callbackArgs;
        }
    }
}

