/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.catalog.GfxdSystemProcedures;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TargetResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BasicNoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import com.pivotal.gemfirexd.tools.planexporter.AccessDistributedSystem;
import com.pivotal.gemfirexd.tools.planexporter.CreateXML;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public class ExplainResultSet
extends BasicNoPutResultSetImpl {
    private ExecRow explainRow = null;
    private List<char[]> queryPlanSet;
    private Iterator<char[]> queryPlansIterator;
    private final String userQueryStr;
    private final ArrayList<ArrayList<Object>> queryParameters;
    private final XPLAINUtil.XMLForms xmlForm;
    private final String embedXslFileName;
    private final GeneratedMethod explainRowAllocator;
    boolean isDerbyActivation;

    public ExplainResultSet(Activation act, GeneratedMethod explainRowAllocator, String userQuery, int queryParamIndex, int xmlForm, String embedXslFileName) {
        super(act, 0.0, 0.0);
        this.userQueryStr = userQuery;
        this.queryParameters = (ArrayList)act.getSavedObject(queryParamIndex);
        this.xmlForm = XPLAINUtil.XMLForms.values()[xmlForm];
        this.embedXslFileName = embedXslFileName;
        this.explainRowAllocator = explainRowAllocator;
        this.isTopResultSet = true;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.queryPlansIterator != null) {
            Element e = null;
            String planText = "Nothing";
            String member = "";
            while (this.queryPlansIterator.hasNext()) {
                ExecRow r = this.explainRow.getClone();
                char[] o = this.queryPlansIterator.next();
                if (o == null) continue;
                if (this.xmlForm == XPLAINUtil.XMLForms.none && (e = CreateXML.transformToXML(o)) != null) {
                    member = e.getAttribute("member_node");
                    planText = String.valueOf(this.getPlanAsText(e, null));
                } else {
                    planText = String.valueOf(o);
                }
                r.getColumn(1).setValue(planText);
                return r;
            }
        }
        if (this.queryPlansIterator == null && this.explainRow != null) {
            this.createNoPlanRow();
            ExecRow r = this.explainRow;
            this.explainRow = null;
            return r;
        }
        return null;
    }

    @Override
    public void openCore() throws StandardException {
        this.isOpen = true;
        this.explainRow = (ExecRow)this.explainRowAllocator.invoke(this.activation);
        this.extractPlan(this.activation);
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        this.isOpen = false;
        this.localTXState = null;
        this.localTXStateSet = false;
    }

    private void extractPlan(Activation activation) throws StandardException {
        if (this.userQueryStr == null) {
            return;
        }
        EmbedConnectionContext eCtx = (EmbedConnectionContext)activation.getContextManager().getContext("JDBC_ConnectionContext");
        EmbedConnection nestedConn = ExplainResultSet.createNestedConnection(eCtx.getEmbedConnection());
        LanguageConnectionContext nestedConnLcc = nestedConn.getLanguageConnection();
        boolean runtimeOnOff = nestedConnLcc != null ? nestedConnLcc.getRunTimeStatisticsMode() : false;
        Statement st = null;
        try {
            String queryID;
            if (nestedConnLcc != null) {
                nestedConnLcc.setRunTimeStatisticsMode(false, true);
            }
            String aQuery = this.userQueryStr;
            st = nestedConn.createStatement();
            if (aQuery.matches("PREVIOUS")) {
                ResultSet rs = st.executeQuery("SELECT STMT_ID FROM SYS.STATEMENTPLANS ORDER BY XPLAIN_TIME DESC");
                if (!rs.next()) {
                    throw GemFireXDRuntimeException.newRuntimeException("Previous statement to explain couldn't be determined ", null);
                }
                queryID = rs.getString(1);
                rs.close();
            } else {
                String type = XPLAINUtil.getStatementType(aQuery);
                if (type == null || type.length() <= 0) {
                    queryID = aQuery.trim();
                    assert (queryID.length() == 36 && queryID.split("-").length == 5) : "Wrong UUID=" + queryID;
                } else {
                    queryID = this.recordExecutionPlan(nestedConn, type, aQuery);
                }
            }
            this.queryPlanSet = new CreateXML(new AccessDistributedSystem(nestedConn, null, queryID, null), false, this.xmlForm, this.embedXslFileName).getPlan();
            this.queryPlansIterator = this.queryPlanSet.iterator();
        }
        catch (SQLException e) {
            throw StandardException.unexpectedUserException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (nestedConnLcc != null) {
                nestedConnLcc.setRunTimeStatisticsMode(runtimeOnOff, true);
            }
            try {
                nestedConn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public static EmbedConnection createNestedConnection(EmbedConnection conn) throws StandardException {
        Connection nestedconn;
        InternalDriver id = conn.getLocalDriver();
        if (id != null && (nestedconn = id.getNewNestedConnection(conn)) != null) {
            assert (nestedconn instanceof EmbedConnection);
            return (EmbedConnection)nestedconn;
        }
        throw StandardException.newException("08003");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String recordExecutionPlan(EmbedConnection nestedConn, String type, String aQuery) throws StandardException {
        if ("DDL".equals(type)) {
            throw GemFireXDRuntimeException.newRuntimeException("DDLs cannot be profiled", null);
        }
        EmbedStatement eps = null;
        try {
            GfxdSystemProcedures.SET_EXPLAIN_CONNECTION(1);
            ParameterValueSet pvs = null;
            if ("SA".equals(type) || "S".equals(type)) {
                ResultSet rs;
                if (this.queryParameters != null) {
                    if (this.queryParameters.size() > 1) {
                        throw StandardException.newException("42Z10", this.queryParameters);
                    }
                    PreparedStatement ps = nestedConn.prepareStatement(aQuery);
                    for (ArrayList<Object> v : this.queryParameters) {
                        int i = 1;
                        for (Object o : v) {
                            ps.setObject(i++, o);
                        }
                    }
                    rs = ps.executeQuery();
                } else {
                    pvs = this.getActivation().getParameterValueSet();
                    if (pvs != null) {
                        eps = (EmbedPreparedStatement)nestedConn.prepareStatement(aQuery);
                        ((EmbedPreparedStatement)eps).getActivation().setParameters(pvs, null);
                        rs = ((EmbedPreparedStatement)eps).executeQuery();
                    } else {
                        rs = nestedConn.createStatement().executeQuery(aQuery);
                    }
                }
                ResultSetMetaData rsMD = rs.getMetaData();
                int numCols22 = rsMD.getColumnCount();
                int rowCount = 0;
                while (rs.next()) {
                    StringBuilder row = new StringBuilder();
                    ++rowCount;
                    for (int index = 1; index <= numCols22; ++index) {
                        String colName = rsMD.getColumnName(index);
                        Object value = rs.getObject(index);
                        row.append(colName).append("=").append(value);
                    }
                    if (!GemFireXDUtils.TracePlanGeneration) continue;
                    SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("Retrieved row " + rowCount + " as " + row.toString()));
                }
                rs.close();
                assert (rs instanceof EmbedResultSet);
                com.pivotal.gemfirexd.internal.iapi.sql.ResultSet iapiResultSet = ((EmbedResultSet)rs).getSourceResultSet();
                this.isDerbyActivation = !(iapiResultSet instanceof AbstractGemFireResultSet);
                String numCols22 = iapiResultSet.getExecutionPlanID().toString();
                return numCols22;
            }
            if ("I".equals(type) || "U".equals(type) || "D".equals(type) || "C".equals(type)) {
                if (this.queryParameters != null) {
                    if (this.queryParameters.size() == 0) {
                        throw StandardException.newException("42Z11", (Object)type, this.queryParameters);
                    }
                    PreparedStatement ps = nestedConn.prepareStatement(aQuery);
                    boolean isBatchStatement = false;
                    for (ArrayList<Object> v : this.queryParameters) {
                        int i = 1;
                        for (Object o : v) {
                            ps.setObject(i++, o);
                        }
                        if (this.queryParameters.size() <= 1) continue;
                        ps.addBatch();
                        isBatchStatement = true;
                    }
                    if (!isBatchStatement) {
                        ps.executeUpdate();
                    } else {
                        ps.executeBatch();
                        ps.clearBatch();
                    }
                    String i$ = ((EmbedStatement)((Object)ps)).getResultsToWrap().getExecutionPlanID().toString();
                    return i$;
                }
                pvs = this.getActivation().getParameterValueSet();
                if (pvs != null) {
                    eps = (EmbedPreparedStatement)nestedConn.prepareStatement(aQuery);
                    ((EmbedPreparedStatement)eps).getActivation().setParameters(pvs, null);
                    ((EmbedPreparedStatement)eps).executeUpdate();
                    String ps = eps.getResultsToWrap().getExecutionPlanID().toString();
                    return ps;
                }
                try (EmbedStatement est = (EmbedStatement)nestedConn.createStatement();){
                    est.execute(aQuery);
                    String e = est.getResultsToWrap().getExecutionPlanID().toString();
                    return e;
                }
            }
            String string = null;
            return string;
        }
        catch (SQLException e) {
            throw StandardException.unexpectedUserException(e);
        }
        finally {
            block57: {
                try {
                    GfxdSystemProcedures.SET_EXPLAIN_CONNECTION(0);
                }
                catch (SQLException e) {
                    if ("08003".equals(e.getSQLState())) break block57;
                    throw StandardException.unexpectedUserException(e);
                }
            }
            if (eps != null) {
                try {
                    eps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private char[] getPlanAsText(Element e, String styleSheet) {
        if (styleSheet == null || styleSheet.length() <= 0) {
            styleSheet = "vanilla_text.xsl";
        }
        ArrayList<Element> l = new ArrayList<Element>();
        l.add(e);
        return Misc.serializeXMLAsCharArr(l, styleSheet);
    }

    private void createNoPlanRow() throws StandardException {
        this.explainRow.getColumn(1).setValue("No Query Plan available ");
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        throw new AssertionError((Object)(this.getClass().getName() + " #filteredRowLocationPostRead is not expected to be called."));
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
        throw new AssertionError((Object)(this.getClass().getName() + " #markRowAsDeleted is not expected to be called."));
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rLoc) throws StandardException {
    }

    @Override
    public void setCurrentRow(ExecRow row) {
        throw new AssertionError((Object)(this.getClass().getName() + " #setCurrentRow is not expected to be called."));
    }

    @Override
    public void setNeedsRowLocation(boolean needsRowLocation) {
        throw new AssertionError((Object)(this.getClass().getName() + " #setNeedsRowLocation is not expected to be called."));
    }

    @Override
    public void setTargetResultSet(TargetResultSet trs) {
        throw new AssertionError((Object)(this.getClass().getName() + " #setTargetResultSet is not expected to be called."));
    }

    @Override
    public void updateRow(ExecRow row) throws StandardException {
        throw new AssertionError((Object)(this.getClass().getName() + " #updateRow is not expected to be called."));
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        throw new AssertionError((Object)(this.getClass().getName() + " #updateRowLocationPostRead is not expected to be called."));
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        throw new AssertionError((Object)(this.getClass().getName() + " #accept is not expected to be called."));
    }

    @Override
    public void clearCurrentRow() {
        this.currentRow = null;
    }

    @Override
    public String getCursorName() {
        throw new AssertionError((Object)(this.getClass().getName() + " #getCursorName is not expected to be called."));
    }

    @Override
    public long getTimeSpent(int type, int timeType) {
        throw new AssertionError((Object)(this.getClass().getName() + " #getTimeSpent is not expected to be called."));
    }

    @Override
    public boolean needsRowLocation() {
        throw new AssertionError((Object)(this.getClass().getName() + " #needsRowLocation is not expected to be called."));
    }

    @Override
    public void rowLocation(RowLocation rl) throws StandardException {
        throw new AssertionError((Object)(this.getClass().getName() + " #rowLocation is not expected to be called."));
    }

    @Override
    public void closeRowSource() {
        throw new AssertionError((Object)(this.getClass().getName() + " #closeRowSource is not expected to be called."));
    }

    @Override
    public ExecRow getNextRowFromRowSource() throws StandardException {
        throw new AssertionError((Object)(this.getClass().getName() + " #getNextRowFromRowSource is not expected to be called."));
    }

    @Override
    public FormatableBitSet getValidColumns() {
        throw new AssertionError((Object)(this.getClass().getName() + " #getValidColumns is not expected to be called."));
    }

    @Override
    public boolean needsToClone() {
        throw new AssertionError((Object)(this.getClass().getName() + " #needsToClone is not expected to be called."));
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        return super.buildQueryPlan(builder, context);
    }
}

