/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TemporaryRowHolder;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ScrollInsensitiveResultSet;
import java.util.Vector;

public abstract class AbstractGemFireActivation
extends BaseActivation {
    final DMLQueryInfo qInfo;
    final GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
    volatile AbstractGemFireResultSet currentRS = null;
    protected boolean isPreparedBatch;
    protected Object[] observerStatistics;
    protected long constructorTime;

    public AbstractGemFireActivation(ExecPreparedStatement st, LanguageConnectionContext _lcc, DMLQueryInfo qi) throws StandardException {
        super(_lcc);
        if (this.observer != null) {
            this.observer.beforeGemFireActivationCreate(this);
        }
        this.preStmt = st;
        this.qInfo = qi;
        this.row = new ExecRow[1];
    }

    @Override
    public void setupActivation(ExecPreparedStatement ps, boolean scrollable, String stmt_text) throws StandardException {
        super.setupActivation(ps, scrollable, stmt_text);
        if (ps == null) {
            return;
        }
        if (scrollable) {
            this.row = new ExecRow[2];
        }
        this.lcc.getAuthorizer().authorize(this, ps, 7 + (this.qInfo.isSelect() ? 1 : 0));
        int paramCnt = this.qInfo.getParameterCount();
        if (this.preStmt != null && !this.preStmt.isSubqueryPrepStatement() && paramCnt > 0 && this.qInfo.isPreparedStatementQuery()) {
            this.pvs = this.lcc.getLanguageFactory().newParameterValueSet(this.lcc.getLanguageConnectionFactory().getClassFactory().getClassInspector(), paramCnt, false);
            this.pvs.initialize(this.preStmt.getParameterTypes());
        }
        this.invokeAfterSetupCallback();
    }

    void invokeAfterSetupCallback() {
        if (this.observer != null) {
            this.observer.afterGemFireActivationCreate(this);
        }
    }

    @Override
    public final void checkStatementValidity() throws StandardException {
        if (this.preStmt == null || this.preStmt.upToDate()) {
            this.isPreparedBatch = this.isPreparedBatch();
            return;
        }
        StandardException se = StandardException.newException("XCL32.S");
        se.setReport(1);
        throw se;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ResultSet execute() throws StandardException {
        this.currentRS = null;
        ScrollInsensitiveResultSet wrapperResultSetToAidScroll = null;
        AbstractGemFireResultSet rs = null;
        try {
            if (!this.lcc.isConnectionForRemote() && this.getScrollable() && this.qInfo.isSelect()) {
                rs = this.createResultSet(1);
                int sourceRowWidth = ((SelectQueryInfo)this.qInfo).getProjectionColumnQueryInfo().length;
                wrapperResultSetToAidScroll = new ScrollInsensitiveResultSet((NoPutResultSet)((Object)rs), this, 0, sourceRowWidth, 0.0, 0.0);
                wrapperResultSetToAidScroll.markAsTopResultSet();
                wrapperResultSetToAidScroll.open();
            } else {
                rs = this.createResultSet(0);
                rs.open();
            }
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("AbstractGemFireActivation::execute:post open of resultset =" + rs));
            }
            this.resultSet = rs;
            this.executeWithResultSet(rs);
            this.currentRS = rs;
        }
        finally {
            if (this.currentRS == null) {
                if (wrapperResultSetToAidScroll != null) {
                    wrapperResultSetToAidScroll.close(false);
                } else {
                    rs.close(false);
                }
            }
        }
        if (wrapperResultSetToAidScroll != null) {
            return wrapperResultSetToAidScroll;
        }
        return rs;
    }

    protected abstract AbstractGemFireResultSet createResultSet(int var1) throws StandardException;

    protected abstract void executeWithResultSet(AbstractGemFireResultSet var1) throws StandardException;

    @Override
    public boolean checkIfThisActivationHasHoldCursor(String tableName) {
        return false;
    }

    public ExecRow getProjectionExecRow() throws StandardException {
        throw new UnsupportedOperationException("AbstractGemFireActivation::getProjectionExecRow: needs implementation in child class");
    }

    public void resetProjectionExecRow() throws StandardException {
        throw new UnsupportedOperationException("AbstractGemFireActivation::getProjectionExecRow: needs implementation in child class");
    }

    @Override
    public Vector getParentResultSet(String resultSetId) {
        throw new UnsupportedOperationException("AbstractGemFireActivation::getParentResultSet: needs implementation");
    }

    @Override
    public ResultDescription getResultDescription() {
        return this.qInfo.getResultDescription();
    }

    @Override
    public final long estimateMemoryUsage() throws StandardException {
        AbstractGemFireResultSet rs = this.currentRS;
        if (this.observer != null) {
            this.observer.estimatingMemoryUsage(this.preStmt.getUserQueryString(this.getLanguageConnectionContext()), rs);
        }
        if (rs != null) {
            return rs.estimateMemoryUsage();
        }
        if (GemFireXDUtils.TraceHeapThresh) {
            SanityManager.DEBUG_PRINT((String)"TraceHeapThreshold", (String)"AbstractGemFireActivation: currentRS is null ");
        }
        return -1L;
    }

    @Override
    public void informOfRowCount(NoPutResultSet resultSet, long rowCount) throws StandardException {
        throw new UnsupportedOperationException("AbstractGemFireActivation::informOfRowCount: needs implementation");
    }

    @Override
    public void setParentResultSet(TemporaryRowHolder rs, String resultSetId) {
        throw new UnsupportedOperationException("AbstractGemFireActivation::setParentResultSet: needs implementation");
    }

    @Override
    protected int getExecutionCount() {
        throw new UnsupportedOperationException("AbstractGemFireActivation::getExecutionCount: needs implementation");
    }

    @Override
    protected Vector getRowCountCheckVector() {
        throw new UnsupportedOperationException("AbstractGemFireActivation::getRowCountCheckVector: needs implementation");
    }

    @Override
    protected int getStalePlanCheckInterval() {
        throw new UnsupportedOperationException("AbstractGemFireActivation::getStalePlanCheckInterval: needs implementation");
    }

    @Override
    protected void setExecutionCount(int newValue) {
        throw new UnsupportedOperationException("AbstractGemFireActivation::setExecutionCount: needs implementation");
    }

    @Override
    protected void setRowCountCheckVector(Vector newValue) {
        throw new UnsupportedOperationException("AbstractGemFireActivation::setRowCountCheckVector: needs implementation");
    }

    @Override
    protected void setStalePlanCheckInterval(int newValue) {
        throw new UnsupportedOperationException("AbstractGemFireActivation::setStalePlanCheckInterval: needs implementation");
    }

    @Override
    public void postConstructor() throws StandardException {
        throw new UnsupportedOperationException("AbstractGemFireActivation::postConstructor: needs implementation");
    }
}

