/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.compile;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.internal.cache.EvictionAttributesImpl;
import com.gemstone.gemfire.internal.cache.PartitionAttributesImpl;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnDefinitionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstraintDefinitionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FKConstraintDefinitionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableElementList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableElementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNodeList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;

public class DistributionDefinitionNode
extends TableElementNode {
    private int policy;
    private int redundancy;
    private ArrayList<ColumnReference> columns;
    private ArrayList<ValueNodeList> values;
    private int maxPartSize;
    private TableName colocateTable;
    private Properties tableProps = null;
    private TableDescriptor tableDesc = null;
    private boolean isPersistent;
    private boolean customHashing = false;
    SortedSet<String> serverGroups;
    private static final int SUCCESS = 0;
    private static final int ERR_GROUPS = 1;
    private static final int ERR_REDUNDANCY = 2;
    private static final int ERR_PARTITIONPOLICY = 3;
    private static final int ERR_BUCKETS = 4;
    private static final int ERR_OTHER = 5;

    public DistributionDefinitionNode() {
        this.policy = 0;
        this.redundancy = 0;
        this.columns = null;
        this.values = null;
        this.maxPartSize = 0;
        this.colocateTable = null;
        this.isPersistent = false;
        this.serverGroups = new TreeSet<String>();
    }

    public DistributionDefinitionNode(DistributionDescriptor desc) {
        this.policy = desc.getPolicy();
        this.redundancy = desc.getRedundancy();
        this.columns = null;
        this.values = null;
        this.maxPartSize = desc.getMaxPartSize();
        this.colocateTable = null;
        this.isPersistent = desc.getPersistence();
        this.serverGroups = desc.getServerGroups();
    }

    @Override
    public void init(Object policy) {
        assert (policy instanceof Integer);
        this.policy = (Integer)policy;
    }

    public void setRedundancy(int redundancy) {
        this.redundancy = redundancy;
    }

    public void setMaxPartSize(int maxPartSize) {
        this.maxPartSize = maxPartSize;
    }

    public void setPolicy(int policy) {
        this.policy = policy;
    }

    public void setServerGroups(SortedSet<String> groups) {
        this.serverGroups = groups;
    }

    public void setCustomHashing(boolean customHashing) {
        this.customHashing = customHashing;
    }

    public void addColumnReference(ColumnReference cr) {
        if (this.columns == null) {
            this.columns = new ArrayList();
        }
        this.columns.add(cr);
    }

    public void setColocatedTable(TableName tn) {
        this.colocateTable = tn;
    }

    public final void setPersistence(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    public final boolean getPersistence() {
        return this.isPersistent;
    }

    public final boolean getCustomHashing() {
        return this.customHashing;
    }

    public void setTableProperties(Properties props) {
        this.tableProps = props;
    }

    public Properties getTableProperties() {
        return this.tableProps;
    }

    public void setTableDescriptor(TableDescriptor td) {
        this.tableDesc = td;
    }

    public TableName getColocatedTable() {
        return this.colocateTable;
    }

    private boolean isEvictionOrExpirationSet(TableName refTable) {
        boolean isSet = false;
        Region refRegion = Misc.getRegionByPath(refTable.getFullTableNameAsRegionPath(), true);
        RegionAttributes rattrs = refRegion.getAttributes();
        EvictionAction ea = rattrs.getEvictionAttributes().getAction();
        if (ea != EvictionAction.NONE && ea != EvictionAction.OVERFLOW_TO_DISK || rattrs.getEntryIdleTimeout().getTimeout() > 0 || rattrs.getEntryTimeToLive().getTimeout() > 0 || rattrs.getRegionIdleTimeout().getTimeout() > 0 || rattrs.getRegionTimeToLive().getTimeout() > 0) {
            isSet = true;
        }
        return isSet;
    }

    private void checkReferencedTables(TableElementIterator elementList, DataDictionary dd, String fullTableName) throws StandardException {
        ArrayList<ConstraintElement> foreignkeyConstraintList = this.getAllConstraintsWithType(elementList, 6);
        for (ConstraintElement fkeyConstraint : foreignkeyConstraintList) {
            TableName refTable = fkeyConstraint.getReferencedTableName();
            if (fullTableName.equals(refTable.getFullTableName()) || !this.isEvictionOrExpirationSet(refTable)) continue;
            throw StandardException.newException("X0Y99.S", (Object)fullTableName, (Object)refTable.getFullTableName());
        }
    }

    public DistributionDescriptor bind(TableElementList elementList, DataDictionary dd) throws StandardException {
        return this.bind(this.newTableElementIterator(elementList), dd);
    }

    public DistributionDescriptor bind(TableDescriptor td, DataDictionary dd) throws StandardException {
        return this.bind(this.newTableDescriptorIterator(td, dd), dd);
    }

    private DistributionDescriptor bind(TableElementIterator elementList, DataDictionary dd) throws StandardException {
        String fullTableName;
        DistributionDescriptor distributionDesc = null;
        if (this.tableProps != null) {
            String schemaName = (String)this.tableProps.get(GfxdConstants.PROPERTY_SCHEMA_NAME);
            SchemaDescriptor sd = this.getSchemaDescriptor(schemaName, false);
            this.resetServerGroups(sd);
            String tableName = (String)this.tableProps.get(GfxdConstants.PROPERTY_TABLE_NAME);
            fullTableName = Misc.getFullTableName(schemaName, tableName, null);
        } else {
            fullTableName = Misc.getFullTableName(this.tableDesc, null);
        }
        if (!Misc.getMemStoreBooting().isHadoopGfxdLonerMode()) {
            this.checkReferencedTables(elementList, dd, fullTableName);
        }
        switch (this.policy) {
            case 0: {
                distributionDesc = this.resolveDefaultPartitionPolicy(elementList, dd, fullTableName);
                break;
            }
            case 5: {
                distributionDesc = dd.getDataDescriptorGenerator().newDistributionDescriptor(this.policy, null, this.redundancy, this.maxPartSize, null, this.isPersistent, this.serverGroups);
                break;
            }
            case 6: 
            case 7: {
                distributionDesc = this.validatePartitionByList(elementList, dd);
                break;
            }
            case 4: {
                distributionDesc = this.validatePartitionByPrimaryKey(elementList, dd, fullTableName);
                break;
            }
            case 1: 
            case 8: {
                distributionDesc = dd.getDataDescriptorGenerator().newDistributionDescriptor(this.policy, null, 0, 0, null, this.isPersistent, this.serverGroups);
                break;
            }
            default: {
                throw new GemFireXDRuntimeException("DistributionDefinitionNode#bind: Unknown partition policy!" + this.policy);
            }
        }
        if (this.colocateTable != null) {
            distributionDesc = this.validateColocatePolicy(elementList, dd, distributionDesc, fullTableName);
        }
        this.setServerGroupsPolicy(fullTableName);
        return distributionDesc;
    }

    private boolean refTablePartitionedByPrimaryAndFKOnPrimaryKey(TableName refTable, ConstraintElement fkeyConstraint) throws StandardException {
        GfxdPartitionResolver spr;
        PartitionAttributesImpl pattrs = this.getPartitionAttributes(refTable.getFullTableNameAsRegionPath());
        if (pattrs != null && (spr = (GfxdPartitionResolver)pattrs.getPartitionResolver()) != null && spr.isPartitioningKeyThePrimaryKey()) {
            Object[] partitionColNames = spr.getColumnNames();
            Object[] refColNames = fkeyConstraint.getReferencedColumnNames();
            if (refColNames == null || refColNames.length == 0) {
                refColNames = fkeyConstraint.getConstraintColumnNames();
            }
            partitionColNames = (String[])partitionColNames.clone();
            refColNames = (String[])refColNames.clone();
            Arrays.sort(partitionColNames);
            Arrays.sort(refColNames);
            if (Arrays.equals(partitionColNames, refColNames)) {
                return true;
            }
        }
        return false;
    }

    private void setAppropGfxdRslvrForDefltPartitioning(String[] colNames, String[] refColNames, PartitionAttributesImpl thisAttr, PartitionAttributesImpl refAttrs, TableDescriptor refTD) throws StandardException {
        GfxdPartitionResolver refRslvr = (GfxdPartitionResolver)refAttrs.getPartitionResolver();
        this.policy = refRslvr.getDistributionDescriptor().getPolicy();
        GfxdPartitionResolver rslvr = refRslvr.cloneForColocation(colNames, refColNames, refRslvr.getMasterTable(false));
        thisAttr.setPartitionResolver((PartitionResolver)rslvr);
        thisAttr.setTotalNumBuckets(refAttrs.getTotalNumBuckets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DistributionDescriptor resolveDefaultPartitionPolicy(TableElementIterator elementList, DataDictionary dd, String fullTableName) throws StandardException {
        if (!Misc.getMemStore().isTableDefaultPartitioned()) {
            return dd.getDataDescriptorGenerator().newDistributionDescriptor(1, null, this.redundancy, this.maxPartSize, null, this.isPersistent, this.serverGroups);
        }
        ArrayList<ConstraintElement> foreignkeyConstraintList = this.getAllConstraintsWithType(elementList, 6);
        for (ConstraintElement fkeyConstraint : foreignkeyConstraintList) {
            TableName refTable = fkeyConstraint.getReferencedTableName();
            if (fullTableName.equals(refTable.getFullTableName()) || !this.refTablePartitionedByPrimaryAndFKOnPrimaryKey(refTable, fkeyConstraint)) continue;
            TableDescriptor refTD = fkeyConstraint.getReferencedTableDescriptor();
            PartitionAttributesImpl pattrs = this.getPartitionAttributes();
            PartitionAttributesImpl refPAttrs = this.getPartitionAttributes(refTD);
            int totalNumBuckets = -1;
            if (pattrs.hasTotalNumBuckets()) {
                totalNumBuckets = pattrs.getTotalNumBuckets();
            }
            if (this.canColocate(pattrs, totalNumBuckets, refTD, refPAttrs, false) != 0) continue;
            this.colocateTable = refTable;
            String[] columnNames = fkeyConstraint.getConstraintColumnNames();
            String[] refColumnNames = fkeyConstraint.getReferencedColumnNames();
            if (refColumnNames == null || refColumnNames.length == 0) {
                refColumnNames = columnNames;
            }
            this.setAppropGfxdRslvrForDefltPartitioning(columnNames, refColumnNames, pattrs, refPAttrs, refTD);
            String refRegionPath = refTable.getFullTableNameAsRegionPath();
            pattrs.setColocatedWith(refRegionPath);
            return dd.getDataDescriptorGenerator().newDistributionDescriptor(this.policy, columnNames, this.redundancy, this.maxPartSize, refRegionPath, this.isPersistent, this.serverGroups);
        }
        try {
            DistributionDescriptor distributionDescriptor;
            String[] keyConstraintCols = this.getConstraintColumnNamesWithType(elementList, 2);
            if (keyConstraintCols != null) {
                this.policy = 4;
                distributionDescriptor = dd.getDataDescriptorGenerator().newDistributionDescriptor(this.policy, keyConstraintCols, this.redundancy, this.maxPartSize, null, this.isPersistent, this.serverGroups);
                return distributionDescriptor;
            }
            keyConstraintCols = this.getConstraintColumnNamesWithType(elementList, 3);
            if (keyConstraintCols != null) {
                this.policy = 5;
                distributionDescriptor = dd.getDataDescriptorGenerator().newDistributionDescriptor(this.policy, keyConstraintCols, this.redundancy, this.maxPartSize, null, this.isPersistent, this.serverGroups);
                return distributionDescriptor;
            }
            keyConstraintCols = this.getConstraintColumnNamesWithType(elementList, 6);
            if (keyConstraintCols != null) {
                this.policy = 5;
                distributionDescriptor = dd.getDataDescriptorGenerator().newDistributionDescriptor(this.policy, keyConstraintCols, this.redundancy, this.maxPartSize, null, this.isPersistent, this.serverGroups);
                return distributionDescriptor;
            }
            this.policy = 3;
            distributionDescriptor = dd.getDataDescriptorGenerator().newDistributionDescriptor(this.policy, null, this.redundancy, this.maxPartSize, null, this.isPersistent, this.serverGroups);
            return distributionDescriptor;
        }
        finally {
            PartitionAttributesImpl pattrs;
            GfxdPartitionResolver resolver;
            if (!(this.tableProps != null || (resolver = (GfxdPartitionResolver)(pattrs = this.getPartitionAttributes()).getPartitionResolver()) instanceof GfxdPartitionByExpressionResolver && ((GfxdPartitionByExpressionResolver)resolver).isDefaultPartitioning())) {
                resolver = new GfxdPartitionByExpressionResolver();
                pattrs.setPartitionResolver((PartitionResolver)resolver);
            }
        }
    }

    private TableDescriptor getTableDescriptor(TableName tName) throws StandardException {
        String schemaName = tName.getSchemaName();
        SchemaDescriptor sd = this.getSchemaDescriptor(schemaName);
        if (sd == null) {
            throw StandardException.newException("42Y07", schemaName);
        }
        String tableName = tName.getTableName();
        TableDescriptor td = this.getTableDescriptor(tableName, sd);
        if (td == null) {
            throw StandardException.newException("42X05", tName.getFullTableName());
        }
        return td;
    }

    private void resetServerGroups(SchemaDescriptor sd) throws StandardException {
        if (sd != null && (this.serverGroups == null || this.serverGroups.size() == 0)) {
            this.serverGroups = sd.getDefaultServerGroups();
        }
    }

    private PartitionAttributesImpl getPartitionAttributes() {
        return (PartitionAttributesImpl)this.getAttributes().getPartitionAttributes();
    }

    private PartitionAttributesImpl getPartitionAttributes(String regionPath) {
        return (PartitionAttributesImpl)this.getAttributes(regionPath).getPartitionAttributes();
    }

    private PartitionAttributesImpl getPartitionAttributes(TableDescriptor td) {
        return (PartitionAttributesImpl)this.getAttributes(td).getPartitionAttributes();
    }

    private RegionAttributes<?, ?> getAttributes() {
        if (this.tableProps != null) {
            return (RegionAttributes)this.tableProps.get("GEMFIRE_REGION_ATTRIBUTES");
        }
        return this.getAttributes(this.tableDesc);
    }

    private RegionAttributes<?, ?> getAttributes(TableDescriptor td) {
        return this.getAttributes(Misc.getRegionPath(td, null));
    }

    private RegionAttributes<?, ?> getAttributes(String regionPath) {
        Region region = Misc.getRegionByPath(regionPath, true);
        assert (region != null) : "expected region to exist";
        return region.getAttributes();
    }

    private int canColocate(PartitionAttributesImpl pattrs, int totalNumBuckets, TableDescriptor checkTD, PartitionAttributesImpl colocatePAttrs, boolean checkRslvrs) throws StandardException {
        if (pattrs != null && colocatePAttrs != null) {
            DistributionDescriptor checkDesc = checkTD.getDistributionDescriptor();
            if (this.isPersistent && !checkDesc.getPersistence()) {
                return 3;
            }
            if (totalNumBuckets >= 0 && colocatePAttrs.getTotalNumBuckets() != totalNumBuckets) {
                return 4;
            }
            if (pattrs.getRedundantCopies() == colocatePAttrs.getRedundantCopies()) {
                if (GemFireXDUtils.setEquals(this.serverGroups, checkDesc.getServerGroups())) {
                    if (checkRslvrs && pattrs.getPartitionResolver() != null && colocatePAttrs.getPartitionResolver() != null) {
                        GfxdPartitionResolver rslvr1 = (GfxdPartitionResolver)pattrs.getPartitionResolver();
                        GfxdPartitionResolver rslvr2 = (GfxdPartitionResolver)colocatePAttrs.getPartitionResolver();
                        if (!rslvr2.okForColocation(rslvr1)) {
                            return 3;
                        }
                    }
                    return 0;
                }
                return 1;
            }
            return 2;
        }
        return 5;
    }

    private void setServerGroupsPolicy(String tableName) throws StandardException {
        if (this.tableProps == null) {
            return;
        }
        DistributionDescriptor.checkAvailableDataStore(this.getLanguageConnectionContext(), this.serverGroups, "CREATE TABLE for " + tableName);
        RegionAttributes attrs = (RegionAttributes)this.tableProps.get("GEMFIRE_REGION_ATTRIBUTES");
        DataPolicy dp = attrs.getDataPolicy();
        if (!ServerGroupUtils.isDataStore(tableName, this.serverGroups)) {
            if (dp.withPartitioning()) {
                AttributesFactory afact = new AttributesFactory(attrs);
                afact.setEnableOffHeapMemory(false);
                if (dp.withPersistence()) {
                    afact.setDiskStoreName(null);
                    if (attrs.getHDFSStoreName() != null) {
                        afact.setDataPolicy(DataPolicy.HDFS_PARTITION);
                    } else {
                        afact.setHDFSStoreName(null);
                        afact.setDataPolicy(DataPolicy.PARTITION);
                    }
                }
                attrs = afact.create();
                this.tableProps.put("GEMFIRE_REGION_ATTRIBUTES", attrs);
                PartitionAttributesImpl pattrs = (PartitionAttributesImpl)attrs.getPartitionAttributes();
                pattrs.setLocalMaxMemory(0);
            } else {
                AttributesFactory afact = new AttributesFactory(attrs);
                if (this.policy != 8) {
                    afact.setDataPolicy(DataPolicy.EMPTY);
                }
                ExpirationAttributes disableExpAttrs = new ExpirationAttributes(0);
                if (attrs.getEntryIdleTimeout() != null) {
                    afact.setEntryIdleTimeout(disableExpAttrs);
                }
                if (attrs.getEntryTimeToLive() != null) {
                    afact.setEntryTimeToLive(disableExpAttrs);
                }
                if (attrs.getEvictionAttributes() != null) {
                    afact.setEvictionAttributes((EvictionAttributes)new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.NONE));
                }
                afact.setDiskStoreName(null);
                afact.setEnableOffHeapMemory(false);
                attrs = afact.create();
                this.tableProps.put("GEMFIRE_REGION_ATTRIBUTES", attrs);
            }
        } else if (!Misc.getMemStore().isHadoopGfxdLonerMode() && (this.getPersistence() || dp.withPersistence()) && !Misc.getMemStore().isDataDictionaryPersistent()) {
            throw StandardException.newException("X0Z14.D", tableName);
        }
    }

    private DistributionDescriptor validateColocatePolicy(TableElementIterator elementList, DataDictionary dd, DistributionDescriptor newDistributionDescp, String srcTableName) throws StandardException {
        int colocateRes;
        assert (this.colocateTable != null) : "validateColocatePolicy: No target table is specified for the colocate policy";
        if (this.tableProps != null) {
            this.colocateTable.bind(dd);
        }
        TableDescriptor td = this.getTableDescriptor(this.colocateTable);
        String tableName = Misc.getFullTableName(td, null);
        DistributionDescriptor targetDistributionDesc = td.getDistributionDescriptor();
        assert (targetDistributionDesc != null);
        RegionAttributes<?, ?> attrs = this.getAttributes();
        PartitionAttributesImpl pattrs = (PartitionAttributesImpl)attrs.getPartitionAttributes();
        RegionAttributes<?, ?> checkAttrs = this.getAttributes(td);
        PartitionAttributesImpl checkPAttrs = (PartitionAttributesImpl)checkAttrs.getPartitionAttributes();
        if (pattrs != null && !pattrs.hasTotalNumBuckets() && checkPAttrs != null && checkPAttrs.hasTotalNumBuckets()) {
            pattrs.setTotalNumBuckets(checkPAttrs.getTotalNumBuckets());
        }
        if ((colocateRes = this.canColocate(pattrs, pattrs != null ? pattrs.getTotalNumBuckets() : -1, td, checkPAttrs, true)) == 1) {
            throw StandardException.newException("X0Y93.S", srcTableName, (Object)tableName, (Object)String.valueOf(this.serverGroups), (Object)String.valueOf(targetDistributionDesc.getServerGroups()));
        }
        if (colocateRes == 2) {
            throw StandardException.newException("X0Y94.S", srcTableName, (Object)tableName, (Object)("redundancy: " + pattrs.getRedundantCopies()), (Object)("redundancy: " + checkPAttrs.getRedundantCopies()));
        }
        if (colocateRes == 4) {
            throw StandardException.newException("X0Y94.S", srcTableName, (Object)tableName, (Object)("buckets: " + pattrs.getTotalNumBuckets()), (Object)("buckets: " + checkPAttrs.getTotalNumBuckets()));
        }
        if (colocateRes == 3) {
            throw StandardException.newException("X0Y95.S", srcTableName, (Object)tableName, (Object)(attrs.getDataPolicy().toString() + ':' + pattrs.getPartitionResolver()), (Object)(checkAttrs.getDataPolicy().toString() + ':' + checkPAttrs.getPartitionResolver()));
        }
        if (colocateRes != 0) {
            throw StandardException.newException("X0Y96.S", (Object)srcTableName, (Object)tableName);
        }
        String[] columnNames = null;
        boolean newDDHasPartitionColumns = false;
        if (newDistributionDescp != null && newDistributionDescp.getPartitionColumnNames() != null) {
            newDDHasPartitionColumns = true;
        }
        if (this.columns != null || newDDHasPartitionColumns) {
            columnNames = !newDDHasPartitionColumns ? this.validatePartitionColumns(elementList) : this.validatePartitionColumns(elementList, newDistributionDescp.getPartitionColumnNames());
            if (!tableName.toUpperCase().endsWith("_COLUMN_STORE_") && !srcTableName.toUpperCase().endsWith("_COLUMN_STORE_")) {
                int size;
                int[] colpositions = targetDistributionDesc.getColumnPositionsSorted();
                if (colpositions.length != (size = columnNames.length)) {
                    throw StandardException.newException("X0Y91.S", srcTableName, (Object)tableName, (Object)size, (Object)colpositions.length);
                }
                for (int i = 0; i < size; ++i) {
                    TableColumn src = elementList.getColumn(columnNames[i]);
                    ColumnDescriptor tgt = td.getColumnDescriptor(colpositions[i]);
                    if (tgt.getType().getTypeName().equals(src.getType().getTypeName()) && tgt.getType().getPrecision() == src.getType().getPrecision() && tgt.getType().getScale() == src.getType().getScale() && tgt.getType().getMaximumWidth() == src.getType().getMaximumWidth()) continue;
                    throw StandardException.newException("X0Y92.S", srcTableName, (Object)tableName, (Object)src.getColumnName(), (Object)String.valueOf(src.getType()), (Object)tgt.getColumnName(), (Object)String.valueOf(tgt.getType()));
                }
            }
        }
        return dd.getDataDescriptorGenerator().newDistributionDescriptor(targetDistributionDesc.getPolicy(), columnNames, this.redundancy, this.maxPartSize, Misc.getRegionPath(td, null), this.isPersistent, this.serverGroups);
    }

    private String[] validatePartitionColumns(TableElementIterator elementList) throws StandardException {
        assert (this.columns.size() > 0);
        String[] columnNames = new String[this.columns.size()];
        for (int index = 0; index < this.columns.size(); ++index) {
            ColumnReference cf = this.columns.get(index);
            String colName = cf.getColumnName();
            if (!elementList.containsColumnName(colName)) {
                throw StandardException.newException("42X01", "The partition column (" + colName + ") does not exist in the table's column list");
            }
            columnNames[index] = colName;
        }
        return columnNames;
    }

    private String[] validatePartitionColumns(TableElementIterator elementList, String[] colNames) throws StandardException {
        assert (colNames.length > 0);
        String[] columnNames = colNames;
        for (int index = 0; index < columnNames.length; ++index) {
            String colName = columnNames[index];
            if (!elementList.containsColumnName(colName)) {
                throw StandardException.newException("42X01", "The partition column (" + colName + ") does not exist in the table's column list");
            }
            columnNames[index] = colName;
        }
        return columnNames;
    }

    private DistributionDescriptor validatePartitionByPrimaryKey(TableElementIterator elementList, DataDictionary dd, String tableName) throws StandardException {
        String[] pkCols = this.getConstraintColumnNamesWithType(elementList, 2);
        if (pkCols == null || pkCols.length == 0) {
            throw StandardException.newException("X0Y97.S", tableName);
        }
        return dd.getDataDescriptorGenerator().newDistributionDescriptor(this.policy, pkCols, this.redundancy, this.maxPartSize, null, this.isPersistent, this.serverGroups);
    }

    private DistributionDescriptor validatePartitionByList(TableElementIterator elementList, DataDictionary dd) throws StandardException {
        String[] columnNames = this.validatePartitionColumns(elementList);
        DistributionDescriptor distributionDesc = dd.getDataDescriptorGenerator().newDistributionDescriptor(this.policy, columnNames, this.redundancy, this.maxPartSize, null, this.isPersistent, this.serverGroups);
        for (int index = 0; index < this.values.size(); ++index) {
            ArrayList<DataValueDescriptor> valueSet = new ArrayList<DataValueDescriptor>();
            ValueNodeList valueNodeList = this.values.get(index);
            for (int j = 0; j < valueNodeList.size(); ++j) {
                ValueNode valueNode = (ValueNode)valueNodeList.elementAt(j);
                assert (valueNode instanceof ConstantNode) : valueNode.toString();
                valueSet.add(((ConstantNode)valueNode).getValue());
            }
            distributionDesc.addValueSet(valueSet);
        }
        return distributionDesc;
    }

    private String[] getConstraintColumnNamesWithType(TableElementIterator elementList, int constraintType) throws StandardException {
        for (ConstraintElement element : elementList) {
            if (element.getConstraintType() != constraintType) continue;
            return element.getConstraintColumnNames();
        }
        return null;
    }

    private ArrayList<ConstraintElement> getAllConstraintsWithType(TableElementIterator elementList, int constraintType) throws StandardException {
        ArrayList<ConstraintElement> list = new ArrayList<ConstraintElement>();
        for (ConstraintElement element : elementList) {
            if (element.getConstraintType() != constraintType) continue;
            list.add(element);
        }
        return list;
    }

    public void addValueNodeList(ValueNodeList values) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        this.values.add(values);
    }

    public TableElementIterator newTableElementIterator(TableElementList elementList) {
        return new TableElementListIterator(elementList);
    }

    public TableElementIterator newTableDescriptorIterator(TableDescriptor td, DataDictionary dd) {
        return new TableDescriptorIterator(td, dd);
    }

    private static class TableDescriptorIterator
    implements TableElementIterator,
    Iterator<ConstraintElement> {
        private final TableDescriptor td;
        private final ConstraintDescriptorList descList;
        private int currentIndex;

        private TableDescriptorIterator(TableDescriptor desc, DataDictionary dd) {
            this.td = desc;
            try {
                this.descList = dd.getConstraintDescriptors(desc);
            }
            catch (StandardException ex) {
                throw GemFireXDRuntimeException.newRuntimeException("Unexpected exception while getting constraint list for table: " + desc, ex);
            }
            this.currentIndex = -1;
        }

        private TableDescriptorIterator(TableDescriptor desc, ConstraintDescriptorList descList) {
            this.td = desc;
            this.descList = descList;
            this.currentIndex = -1;
        }

        @Override
        public boolean containsColumnName(String columnName) {
            return this.td.getColumnDescriptor(columnName) != null;
        }

        @Override
        public TableColumn getColumn(String columnName) {
            ColumnDescriptor col = this.td.getColumnDescriptor(columnName);
            if (col != null) {
                return new TableColumn(col.getType(), col.getColumnName());
            }
            return null;
        }

        @Override
        public Iterator<ConstraintElement> iterator() {
            return new TableDescriptorIterator(this.td, this.descList);
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex + 1 < this.descList.size();
        }

        @Override
        public ConstraintElement next() {
            ++this.currentIndex;
            return new ConstraintDescriptorElement(this.descList.elementAt(this.currentIndex));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }

        private class ConstraintDescriptorElement
        implements ConstraintElement {
            ConstraintDescriptor desc;

            private ConstraintDescriptorElement(ConstraintDescriptor desc) {
                this.desc = desc;
            }

            @Override
            public int getConstraintType() {
                return this.desc.getConstraintType();
            }

            @Override
            public TableName getReferencedTableName() throws StandardException {
                TableDescriptor refTD = this.getReferencedTableDescriptor();
                if (refTD != null) {
                    TableName refTable = new TableName();
                    refTable.init(refTD.getSchemaName(), refTD.getName());
                    return refTable;
                }
                return null;
            }

            @Override
            public TableDescriptor getReferencedTableDescriptor() throws StandardException {
                if (this.desc instanceof ForeignKeyConstraintDescriptor) {
                    return ((ForeignKeyConstraintDescriptor)this.desc).getReferencedConstraint().getTableDescriptor();
                }
                return null;
            }

            @Override
            public String[] getConstraintColumnNames() throws StandardException {
                return this.desc.getColumnDescriptors().getColumnNames();
            }

            @Override
            public String[] getReferencedColumnNames() throws StandardException {
                if (this.desc instanceof ForeignKeyConstraintDescriptor) {
                    return ((ForeignKeyConstraintDescriptor)this.desc).getReferencedConstraint().getColumnDescriptors().getColumnNames();
                }
                return null;
            }
        }
    }

    private class TableElementListIterator
    implements TableElementIterator,
    Iterator<ConstraintElement> {
        private final TableElementList elementList;
        private int currentIndex;

        private TableElementListIterator(TableElementList tableElementList) {
            this.elementList = tableElementList;
            this.currentIndex = -1;
        }

        @Override
        public boolean containsColumnName(String columnName) {
            return this.elementList.containsColumnName(columnName);
        }

        @Override
        public TableColumn getColumn(String columnName) {
            ColumnDefinitionNode col = this.elementList.findColumnDefinition(columnName);
            if (col != null) {
                return new TableColumn(col.getType(), col.getColumnName());
            }
            return null;
        }

        @Override
        public Iterator<ConstraintElement> iterator() {
            return new TableElementListIterator(this.elementList);
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex + 1 < this.elementList.size();
        }

        @Override
        public ConstraintElement next() {
            ++this.currentIndex;
            return new ConstraintNodeElement(this.elementList.elementAt(this.currentIndex));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }

        private class ConstraintNodeElement
        implements ConstraintElement {
            ConstraintDefinitionNode consNode;

            private ConstraintNodeElement(QueryTreeNode node) {
                this.consNode = node instanceof ConstraintDefinitionNode ? (ConstraintDefinitionNode)node : null;
            }

            @Override
            public int getConstraintType() {
                if (this.consNode != null) {
                    return this.consNode.getConstraintType();
                }
                return -1;
            }

            @Override
            public TableName getReferencedTableName() {
                if (this.consNode instanceof FKConstraintDefinitionNode) {
                    return ((FKConstraintDefinitionNode)this.consNode).getRefTableName();
                }
                return null;
            }

            @Override
            public TableDescriptor getReferencedTableDescriptor() throws StandardException {
                TableName refTableName = this.getReferencedTableName();
                if (refTableName != null) {
                    return DistributionDefinitionNode.this.getTableDescriptor(refTableName);
                }
                return null;
            }

            @Override
            public String[] getConstraintColumnNames() {
                if (this.consNode != null) {
                    return this.consNode.getColumnList().getColumnNames();
                }
                return null;
            }

            @Override
            public String[] getReferencedColumnNames() throws StandardException {
                if (this.consNode instanceof FKConstraintDefinitionNode) {
                    return ((FKConstraintDefinitionNode)this.consNode).getReferencedConstraintInfo().getReferencedColumnNames();
                }
                return null;
            }
        }
    }

    private static class TableColumn {
        DataTypeDescriptor dtd;
        String name;

        private TableColumn(DataTypeDescriptor dtd, String name) {
            this.dtd = dtd;
            this.name = name;
        }

        public DataTypeDescriptor getType() {
            return this.dtd;
        }

        public String getColumnName() {
            return this.name;
        }
    }

    static interface TableElementIterator
    extends Iterable<ConstraintElement> {
        public boolean containsColumnName(String var1) throws StandardException;

        public TableColumn getColumn(String var1);
    }

    static interface ConstraintElement {
        public int getConstraintType() throws StandardException;

        public TableName getReferencedTableName() throws StandardException;

        public TableDescriptor getReferencedTableDescriptor() throws StandardException;

        public String[] getConstraintColumnNames() throws StandardException;

        public String[] getReferencedColumnNames() throws StandardException;
    }
}

