/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management.impl;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.deadlock.DeadlockDetector;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.execute.FunctionStats;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.catalog.GfxdSystemProcedures;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.management.GfxdMemberMXBean;
import com.pivotal.gemfirexd.internal.engine.management.NetworkServerConnectionStats;
import com.pivotal.gemfirexd.internal.engine.management.NetworkServerNestedConnectionStats;
import com.pivotal.gemfirexd.internal.engine.management.impl.Cleanable;
import com.pivotal.gemfirexd.internal.engine.management.impl.InternalManagementService;
import com.pivotal.gemfirexd.internal.engine.management.impl.ManagementUtils;
import com.pivotal.gemfirexd.internal.engine.management.impl.Updatable;
import com.pivotal.gemfirexd.internal.engine.stats.ConnectionStats;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class GfxdMemberMBeanBridge
implements Cleanable,
Updatable<GfxdMemberMBeanBridge> {
    private final String[] EMPTY_STRING_ARRAY = new String[0];
    private InternalDistributedMember member;
    private Set<String> serverGroups;
    private InternalManagementService.ConnectionWrapperHolder connectionWrapperHolder;
    private GfxdMemberMXBean.GfxdMemberMetaData gfxdMemberMetaData;
    private NetworkServerConnectionStats clientConnectionStats;
    private NetworkServerConnectionStats peerConnectionStats;
    private NetworkServerNestedConnectionStats nestedConnectionStats;
    private NetworkServerNestedConnectionStats internalConnectionStats;
    private LogWriter logWriter;
    private PreparedStatement metadataStatement;
    private FunctionStats distributedProcedureCallFunctionStats;

    public GfxdMemberMBeanBridge(InternalDistributedMember member, Set<String> serverGroups, InternalManagementService.ConnectionWrapperHolder connectionHolder) {
        this.member = member;
        this.serverGroups = serverGroups;
        this.connectionWrapperHolder = connectionHolder;
        this.logWriter = Misc.getCacheLogWriter();
        this.clientConnectionStats = GfxdMemberMBeanBridge.newNetworkServerConnectionStats("Client");
        this.peerConnectionStats = GfxdMemberMBeanBridge.newNetworkServerConnectionStats("Peer");
        this.nestedConnectionStats = GfxdMemberMBeanBridge.newNetworkServerNestedConnectionStats("Nested");
        this.internalConnectionStats = GfxdMemberMBeanBridge.newNetworkServerNestedConnectionStats("Internal");
    }

    private static NetworkServerConnectionStats newNetworkServerConnectionStats(String type) {
        return new NetworkServerConnectionStats(type, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    private static NetworkServerNestedConnectionStats newNetworkServerNestedConnectionStats(String type) {
        return new NetworkServerNestedConnectionStats(type, 0L, 0L, 0L);
    }

    public String getName() {
        return this.member.getName();
    }

    public String getId() {
        return this.member.getId();
    }

    public String[] getGroups() {
        return this.serverGroups.toArray(this.EMPTY_STRING_ARRAY);
    }

    private GemFireStore.VMKind getVmKind() {
        return GemFireXDUtils.getMyVMKind();
    }

    public boolean isDataStore() {
        GemFireStore.VMKind vmKind = this.getVmKind();
        return vmKind != null && vmKind.isStore();
    }

    public boolean isLocator() {
        GemFireStore.VMKind vmKind = this.getVmKind();
        return vmKind != null && vmKind.isLocator();
    }

    public NetworkServerConnectionStats listNetworkServerClientConnectionStats() {
        return this.clientConnectionStats;
    }

    public NetworkServerConnectionStats listNetworkServerPeerConnectionStats() {
        return this.peerConnectionStats;
    }

    public NetworkServerNestedConnectionStats listNetworkServerNestedConnectionStats() {
        return this.nestedConnectionStats;
    }

    public NetworkServerNestedConnectionStats listNetworkServerInternalConnectionStats() {
        return this.internalConnectionStats;
    }

    public int getProcedureCallsCompleted() {
        GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
        if (cache != null) {
            if (this.distributedProcedureCallFunctionStats == null) {
                InternalDistributedSystem ds = cache.getDistributedSystem();
                this.distributedProcedureCallFunctionStats = FunctionStats.getFunctionStats((String)"gfxd-DistributedProcedureCallFunction", (InternalDistributedSystem)ds);
            }
            return this.distributedProcedureCallFunctionStats.getFunctionExecutionsCompleted();
        }
        return 0;
    }

    public int getProcedureCallsInProgress() {
        GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
        if (cache != null) {
            if (this.distributedProcedureCallFunctionStats == null) {
                InternalDistributedSystem ds = cache.getDistributedSystem();
                this.distributedProcedureCallFunctionStats = FunctionStats.getFunctionStats((String)"gfxd-DistributedProcedureCallFunction", (InternalDistributedSystem)ds);
            }
            return this.distributedProcedureCallFunctionStats.getFunctionExecutionsRunning();
        }
        return 0;
    }

    public GfxdMemberMXBean.GfxdMemberMetaData fetchMetadata() {
        try {
            return this.retrieveMetadata();
        }
        catch (SQLException e) {
            this.logWriter.info("Error occurred while fetching MetaData for " + this.getId() + ". Reason: " + e.getMessage());
            if (this.logWriter.fineEnabled()) {
                this.logWriter.fine((Throwable)e);
            }
            return ManagementUtils.MEMBER_METADATA_NA;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GfxdMemberMXBean.GfxdMemberMetaData retrieveMetadata() throws SQLException {
        if (this.connectionWrapperHolder.hasConnection()) {
            if (this.metadataStatement == null) {
                this.metadataStatement = this.connectionWrapperHolder.getConnection().prepareStatement("<local>SELECT * FROM SYS.MEMBERS WHERE ID=?");
                this.metadataStatement.setString(1, this.getId());
            }
            try (ResultSet resultSet = this.metadataStatement.executeQuery();){
                if (!resultSet.next()) return this.gfxdMemberMetaData;
                if (this.gfxdMemberMetaData == null || this.gfxdMemberMetaData == ManagementUtils.MEMBER_METADATA_NA) {
                    this.gfxdMemberMetaData = new GfxdMemberMXBean.GfxdMemberMetaData(resultSet.getString("ID"), resultSet.getString("KIND"), resultSet.getString("STATUS"), resultSet.getString("HOSTDATA"), resultSet.getString("ISELDER"), resultSet.getString("IPADDRESS"), resultSet.getString("HOST"), resultSet.getString("PID"), resultSet.getString("PORT"), resultSet.getString("ROLES"), resultSet.getString("NETSERVERS"), resultSet.getString("THRIFTSERVERS"), resultSet.getString("LOCATOR"), resultSet.getString("SERVERGROUPS"), resultSet.getString("MANAGERINFO"), resultSet.getString("SYSTEMPROPS"), resultSet.getString("GEMFIREPROPS"), resultSet.getString("BOOTPROPS"));
                    return this.gfxdMemberMetaData;
                }
                this.gfxdMemberMetaData.updateMetadata(resultSet.getString("KIND"), resultSet.getString("STATUS"), resultSet.getString("HOSTDATA"), resultSet.getString("ISELDER"), resultSet.getString("IPADDRESS"), resultSet.getString("HOST"), resultSet.getString("PID"), resultSet.getString("PORT"), resultSet.getString("ROLES"), resultSet.getString("NETSERVERS"), resultSet.getString("THRIFTSERVERS"), resultSet.getString("LOCATOR"), resultSet.getString("SERVERGROUPS"), resultSet.getString("MANAGERINFO"), resultSet.getString("SYSTEMPROPS"), resultSet.getString("GEMFIREPROPS"), resultSet.getString("BOOTPROPS"));
                return this.gfxdMemberMetaData;
            }
        } else {
            this.gfxdMemberMetaData = ManagementUtils.MEMBER_METADATA_NA;
        }
        return this.gfxdMemberMetaData;
    }

    public float fetchEvictionPercent() {
        return GfxdSystemProcedures.GET_EVICTION_HEAP_PERCENTAGE();
    }

    public void updateEvictionPercent(float newValue) throws StandardException {
        GfxdSystemProcedures.SET_EVICTION_HEAP_PERCENTAGE(newValue);
    }

    public float fetchCriticalPercent() {
        return GfxdSystemProcedures.GET_CRITICAL_HEAP_PERCENTAGE();
    }

    public void updateCriticalPercent(float newValue) throws StandardException {
        GfxdSystemProcedures.SET_CRITICAL_HEAP_PERCENTAGE(newValue);
    }

    public String detectDeadlocks() {
        Set dependencies = DeadlockDetector.collectAllDependencies((Serializable)this.member);
        return DeadlockDetector.prettyFormat((Collection)dependencies);
    }

    public String detectDeadlocksAlt() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] findDeadlockedThreads = threadMXBean.findDeadlockedThreads();
        StringBuilder builder = new StringBuilder();
        if (findDeadlockedThreads == null || findDeadlockedThreads.length == 0) {
            builder.append("No deadlocks detected.");
        } else {
            ThreadInfo[] threadsInfo;
            for (ThreadInfo threadInfo : threadsInfo = threadMXBean.getThreadInfo(findDeadlockedThreads)) {
                builder.append(threadInfo.toString()).append(ManagementUtils.LINE_SEPARATOR);
            }
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.member == null ? 0 : this.member.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GfxdMemberMBeanBridge other = (GfxdMemberMBeanBridge)obj;
        return !(this.member == null ? other.member != null : !this.member.equals(other.member));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(GfxdMemberMBeanBridge.class.getSimpleName()).append(" [member=").append(this.member).append("]");
        return builder.toString();
    }

    @Override
    public void cleanUp() {
        block3: {
            try {
                if (this.metadataStatement != null && !this.metadataStatement.isClosed()) {
                    this.metadataStatement.cancel();
                    this.metadataStatement.close();
                }
            }
            catch (SQLException e) {
                if (!this.logWriter.fineEnabled()) break block3;
                this.logWriter.fine((Throwable)e);
            }
        }
        this.member = null;
    }

    @Override
    public void update() {
        InternalDistributedSystem system;
        StatisticsType connectionStatsType;
        GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
        if (cache != null && (connectionStatsType = (system = cache.getDistributedSystem()).findType(ConnectionStats.name)) != null) {
            Statistics[] foundStatistics;
            for (Statistics statistics : foundStatistics = system.findStatisticsByType(connectionStatsType)) {
                this.peerConnectionStats.updateNetworkServerConnectionStats(statistics.getLong("peerConnectionsOpened"), statistics.getLong("peerConnectionsClosed"), statistics.getLong("peerConnectionsAttempted"), statistics.getLong("peerConnectionsFailed"), statistics.getLong("peerConnectionsLifeTime"), statistics.getLong("peerConnectionsOpen"), 0L);
                this.nestedConnectionStats.updateNetworkServerConnectionStats(statistics.getLong("nestedConnectionsOpened"), statistics.getLong("nestedConnectionsClosed"), statistics.getLong("nestedConnectionsOpen"));
                this.internalConnectionStats.updateNetworkServerConnectionStats(statistics.getLong("internalConnectionsOpened"), statistics.getLong("internalConnectionsClosed"), statistics.getLong("internalConnectionsOpen"));
                this.clientConnectionStats.updateNetworkServerConnectionStats(statistics.getLong("clientConnectionsOpened"), statistics.getLong("clientConnectionsClosed"), statistics.getLong("clientConnectionsAttempted"), statistics.getLong("clientConnectionsFailed"), statistics.getLong("clientConnectionsLifeTime"), statistics.getLong("clientConnectionsOpen"), statistics.getLong("clientConnectionsIdle"));
            }
        }
    }

    @Override
    public GfxdMemberMBeanBridge getSelf() {
        return this;
    }

    @Override
    public void setUpdateToken(int updateToken) {
    }

    public String[] activeThreads() {
        if (Thread.getAllStackTraces().keySet().size() > 0) {
            String[] strArr = new String[Thread.getAllStackTraces().keySet().size()];
            int i = 0;
            for (Thread threadObj : Thread.getAllStackTraces().keySet()) {
                strArr[i] = "THREAD-NAME =" + threadObj.getName() + " THREAD-ID=" + threadObj.getId();
                ++i;
            }
            return strArr;
        }
        return null;
    }

    public String[] getStack(String id) {
        if (id != null && id.length() > 0) {
            Set<Map.Entry<Thread, StackTraceElement[]>> threadEntrySet = Thread.getAllStackTraces().entrySet();
            for (Map.Entry<Thread, StackTraceElement[]> threadStack : threadEntrySet) {
                Thread thread = threadStack.getKey();
                try {
                    Long.parseLong(id);
                }
                catch (Exception ex) {
                    return new String[]{"id =" + id + " is not a valid Thread ID."};
                }
                if (thread.getId() != Long.parseLong(id)) continue;
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement element : thread.getStackTrace()) {
                    sb.append(element.toString());
                    sb.append("\n");
                }
                return new String[]{sb.toString()};
            }
            return new String[]{"No matching thread id found."};
        }
        if (Thread.getAllStackTraces().keySet().size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
                StackTraceElement[] stackTraceElement;
                sb.append("THREAD_ID=" + entry.getKey().getId());
                sb.append(System.getProperty("line.separator"));
                for (StackTraceElement threadStack : stackTraceElement = entry.getValue()) {
                    sb.append(threadStack.toString());
                    sb.append(System.getProperty("line.separator"));
                }
                sb.append(System.getProperty("line.separator"));
                sb.append(System.getProperty("line.separator"));
            }
            return new String[]{sb.toString()};
        }
        String[] str = new String[]{"There are no stack traces for any live threads"};
        return str;
    }
}

