/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.locks;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.LockNotHeldException;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.db.FabricDatabase;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockService;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockable;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.locks.CompatibilitySpace;
import com.pivotal.gemfirexd.internal.iapi.services.locks.LockOwner;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.LockSupport;

public final class GfxdLockSet
implements CompatibilitySpace {
    public static int MAX_LOCKWAIT_VAL = 300000;
    static final int MAX_VM_LOCKWAIT_RETRIES = 30;
    public static int MAX_VM_LOCKWAIT_VAL = MAX_LOCKWAIT_VAL / 30;
    static final int MAX_WRITE_WAIT_RETRIES = 10;
    public static int MAX_WRITE_WAIT_RETRY = MAX_LOCKWAIT_VAL / 10;
    public static final int LOCK_FAIL = 0;
    public static final int LOCK_SUCCESS = 1;
    public static final int LOCK_REENTER = 2;
    private static final ThreadLocal<Map<Object, Integer>> numWriteRetries = new ThreadLocal<Map<Object, Integer>>(){

        @Override
        protected Map<Object, Integer> initialValue() {
            return new HashMap<Object, Integer>(5);
        }
    };
    public static final int READ_LOCKWAIT_FOR_REACQUIRE = 1000;
    private LockOwner owner;
    private final LockList acquiredLocks;
    private final GfxdLockService rwLockService;
    private ArrayList<Object> freeResourceList;
    private int numRefs;
    private volatile GfxdResultCollector<?> pendingRC;
    private volatile Thread rcWaiter;
    private static final int RC_WAIT_NANOS = 100000000;

    private static int getInteger(GemFireStore store, String propName, int defaultValue) {
        String val = null;
        if (store != null) {
            val = store.getBootProperty(propName);
        }
        if (val == null) {
            val = System.getProperty(propName);
        }
        if (val != null) {
            try {
                return Integer.decode(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int initConstants(GemFireStore store) {
        MAX_LOCKWAIT_VAL = GfxdLockSet.getInteger(store, GfxdConstants.MAX_LOCKWAIT, 300000);
        MAX_VM_LOCKWAIT_VAL = MAX_LOCKWAIT_VAL / 30;
        MAX_WRITE_WAIT_RETRY = MAX_LOCKWAIT_VAL / 10;
        return MAX_VM_LOCKWAIT_VAL;
    }

    public GfxdLockSet(LockOwner owner, GfxdLockService lockService) {
        assert (owner != null) : "unexpected null LockOwner for GfxdLockSet";
        this.owner = owner;
        this.acquiredLocks = new LockList();
        this.rwLockService = lockService;
    }

    @Override
    public final LockOwner getOwner() {
        return this.owner;
    }

    public final void setOwner(LockOwner newOwner) {
        this.owner = newOwner;
    }

    public final GfxdLockService getLockService() {
        return this.rwLockService;
    }

    public void waitForPendingRC() {
        GfxdResultCollector<?> pendingRC = this.pendingRC;
        if (pendingRC != null && pendingRC.getProcessor() != null) {
            Thread waiter = this.rcWaiter;
            Thread thisThread = Thread.currentThread();
            if (waiter != thisThread) {
                if (waiter != null) {
                    SanityManager.THROWASSERT((String)("Unexpected thread already waiting [" + waiter + "], current thread: " + thisThread));
                }
                this.rcWaiter = thisThread;
            }
            while ((pendingRC = this.pendingRC) != null) {
                if (GemFireXDUtils.TraceLock) {
                    SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)(this.toString() + "#waitForPendingRC: waiting for ResultCollector: " + pendingRC));
                }
                LockSupport.parkNanos(pendingRC, 100000000L);
                Misc.checkIfCacheClosing(new InterruptedException());
            }
            this.rcWaiter = null;
        }
    }

    public void rcSet(GfxdResultCollector<?> rc) {
        this.waitForPendingRC();
        if (GemFireXDUtils.TraceLock) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)(this.toString() + "#rcSet: setting new ResultCollector: " + rc));
        }
        this.pendingRC = rc;
    }

    public void rcEnd(GfxdResultCollector<?> rc) {
        GfxdResultCollector<?> pendingRC = this.pendingRC;
        if (pendingRC != null) {
            if (rc == null || rc == pendingRC) {
                Thread waiter = this.rcWaiter;
                this.pendingRC = null;
                if (waiter != null) {
                    LockSupport.unpark(waiter);
                }
                if (GemFireXDUtils.TraceLock) {
                    SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)(this.toString() + "#rcEnd: cleared ResultCollector: " + rc + ", pending thread: " + waiter));
                }
            } else if (GemFireXDUtils.TraceLock) {
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)(this.toString() + "#rcEnd: ignored ResultCollector: " + rc + ", for pendingRC: " + pendingRC));
            }
        }
    }

    public int acquireLock(GfxdLockable lockObject, long waitMillis, boolean forUpdate, boolean local, boolean reacquireReadLocks) throws StandardException {
        boolean success;
        this.waitForPendingRC();
        LockType lockType = GfxdLockSet.getLockType(forUpdate, local);
        LockEntry entry = this.acquiredLocks.getHead();
        Object lockName = lockObject.getName();
        while ((entry = this.acquiredLocks.nextEntry(entry)) != null) {
            GfxdLockable lockable = entry.getLockObject();
            if (!lockable.getName().equals(lockName)) continue;
            LockType currType = entry.getLockType();
            if (currType.isWrite()) {
                return 2;
            }
            if (currType == lockType) {
                if (currType.isRead()) {
                    if (lockObject.traceLock()) {
                        SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("GfxdLockSet: re-entering for " + (Object)((Object)currType) + " lock on " + lockObject));
                    }
                    entry.doReenter();
                }
                return 2;
            }
            if (currType.isLocalWrite() && !forUpdate) {
                return 2;
            }
            GfxdLockSet.unlock(this.rwLockService, lockObject, this.owner, currType);
            this.acquiredLocks.removeEntry(entry);
            break;
        }
        ArrayList<GfxdLockable> readLocks = null;
        long readWaitMillis = -1L;
        if (reacquireReadLocks) {
            readWaitMillis = waitMillis != 0L ? 1000 : 0;
            if (!forUpdate && this.addLock(lockObject, readWaitMillis, false, local, lockType)) {
                return 1;
            }
            readLocks = new ArrayList<GfxdLockable>();
            entry = this.acquiredLocks.getHead();
            while ((entry = this.acquiredLocks.nextEntry(entry)) != null) {
                LockType currLockType = entry.lockType;
                if (!currLockType.isRead()) continue;
                GfxdLockable lock = entry.lockObject;
                GfxdLockSet.unlock(this.rwLockService, lock, this.owner, LockType.READ);
                readLocks.add(lock);
                this.acquiredLocks.removeEntry(entry);
            }
        }
        if ((success = this.addLock(lockObject, waitMillis, forUpdate, local, lockType)) && readLocks != null && readLocks.size() > 0) {
            long startTime;
            long currentTime = startTime = System.currentTimeMillis();
            success = false;
            while (currentTime - startTime < waitMillis) {
                success = true;
                for (int index = 0; index < readLocks.size(); ++index) {
                    GfxdLockable lock = (GfxdLockable)readLocks.get(index);
                    if (GfxdLockSet.lock(this.rwLockService, lock, this.owner, readWaitMillis, false, false)) continue;
                    for (int rIndex = 0; rIndex < index; ++rIndex) {
                        GfxdLockSet.unlock(this.rwLockService, (GfxdLockable)readLocks.get(rIndex), this.owner, LockType.READ);
                    }
                    success = false;
                    break;
                }
                if (success) break;
                currentTime = System.currentTimeMillis();
            }
            if (success) {
                for (GfxdLockable lock : readLocks) {
                    this.acquiredLocks.addLast(new LockEntry(lock, LockType.READ));
                }
            }
        }
        return success ? 1 : 0;
    }

    public final LockType getLockType(GfxdLockable lockObject) {
        LockEntry entry = this.acquiredLocks.getHead();
        Object lockName = lockObject.getName();
        while ((entry = this.acquiredLocks.nextEntry(entry)) != null) {
            GfxdLockable lockable = entry.getLockObject();
            if (!lockable.getName().equals(lockName)) continue;
            return entry.getLockType();
        }
        return null;
    }

    public synchronized boolean releaseLock(GfxdLockable lockObject, boolean forUpdate, boolean local) {
        LockEntry entry = this.acquiredLocks.getTail();
        Object lockName = lockObject.getName();
        while ((entry = this.acquiredLocks.previousEntry(entry)) != null) {
            LockType expectedLockType;
            GfxdLockable lock = entry.getLockObject();
            if (!lock.getName().equals(lockName)) continue;
            LockType lockType = entry.getLockType();
            if (lockType == (expectedLockType = GfxdLockSet.getLockType(forUpdate, local))) {
                if (!lockType.isRead() || entry.doRelease()) {
                    GfxdLockSet.unlock(this.rwLockService, lockObject, this.owner, lockType);
                    this.acquiredLocks.removeEntry(entry);
                    return true;
                }
                return false;
            }
            if (!expectedLockType.isRead() && (!expectedLockType.isLocalWrite() || !lockType.isWrite())) continue;
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean unlockAll(boolean force, boolean removeRef) {
        if (SanityManager.isFineEnabled | GemFireXDUtils.TraceLock) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("GfxdLockSet.unlockAll: force=" + force + " removeRef=" + removeRef + " numRefs=" + this.numRefs + " for " + this.owner));
        }
        boolean doUnlock = false;
        if (force) {
            this.numRefs = 0;
            doUnlock = true;
        } else if (removeRef) {
            doUnlock = this.removeRef();
        } else {
            boolean bl = doUnlock = this.numRefs <= 0;
        }
        if (doUnlock) {
            LockEntry entry = this.acquiredLocks.getHead();
            while ((entry = this.acquiredLocks.nextEntry(entry)) != null) {
                boolean success = false;
                try {
                    GfxdLockSet.unlock(this.rwLockService, entry.getLockObject(), this.owner, entry.getLockType());
                    success = true;
                }
                finally {
                    if (success) continue;
                    this.acquiredLocks.removeEntry(entry);
                }
            }
            this.acquiredLocks.clear();
            return true;
        }
        return false;
    }

    public void addResultSetRef() {
        ++this.numRefs;
        if (SanityManager.isFineEnabled | GemFireXDUtils.TraceLock) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("GfxdLockSet.addResultSetRef: numRefs=" + this.numRefs + " for " + this.owner));
        }
    }

    private boolean removeRef() {
        switch (this.numRefs) {
            case 0: {
                return true;
            }
            case 1: {
                this.numRefs = 0;
                return true;
            }
        }
        assert (this.numRefs > 0) : "unexpected numRefs=" + this.numRefs;
        --this.numRefs;
        return false;
    }

    public int getNumRefs() {
        return this.numRefs;
    }

    public void addToFreeResources(GfxdLockable lockable) {
        if (this.freeResourceList == null) {
            this.freeResourceList = new ArrayList();
        }
        this.freeResourceList.add(lockable.getName());
    }

    public void freeLockResources() {
        if (this.freeResourceList != null) {
            for (Object lockObject : this.freeResourceList) {
                this.rwLockService.freeResources(lockObject);
            }
            this.freeResourceList = null;
        }
    }

    public synchronized void dumpReadLocks(StringBuilder msg, String logPrefix, Thread t) {
        boolean firstReadLock = true;
        LockEntry entry = this.acquiredLocks.getHead();
        while ((entry = this.acquiredLocks.nextEntry(entry)) != null) {
            if (!entry.lockType.isRead()) continue;
            if (firstReadLock) {
                msg.append(logPrefix).append(": ").append(t);
                if (this.owner != null) {
                    msg.append('[').append(this.owner).append(']');
                }
                msg.append(" has READ locks: ");
                entry.appendString(msg);
                firstReadLock = false;
                continue;
            }
            msg.append(',');
            entry.appendString(msg);
        }
        if (!firstReadLock) {
            msg.append(SanityManager.lineSeparator);
        }
    }

    public synchronized Collection<GfxdLockable> getReadLocksForDebugging() {
        ArrayList<GfxdLockable> results = new ArrayList<GfxdLockable>();
        LockEntry entry = this.acquiredLocks.getHead();
        while ((entry = this.acquiredLocks.nextEntry(entry)) != null) {
            if (!entry.lockType.isRead()) continue;
            results.add(entry.lockObject);
        }
        return results;
    }

    private static LockType getLockType(boolean forUpdate, boolean local) {
        return !forUpdate ? LockType.READ : (!local ? LockType.WRITE : LockType.LOCAL_WRITE);
    }

    public static boolean lock(GfxdLockService lockService, GfxdLockable lockObject, Object owner, long waitMillis, boolean forUpdate, boolean local) throws StandardException {
        boolean success;
        if (forUpdate) {
            if (local) {
                success = lockService.getLocalLockService().writeLock(lockObject.getName(), owner, waitMillis, -1L);
            } else {
                Integer retries;
                GfxdDataDictionary dd;
                FabricDatabase db;
                boolean hasDDLock = false;
                if (waitMillis > 0L && (db = Misc.getMemStore().getDatabase()) != null && (dd = db.getDataDictionary()) != null) {
                    boolean traceLock = lockObject.traceLock();
                    GfxdLockable ddLockObject = dd.getLockObject();
                    if (traceLock) {
                        SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("GfxdLockSet: checking if " + owner + " already holds an " + "exclusive lock on " + ddLockObject + " for lock of " + lockObject));
                    }
                    if (lockObject != ddLockObject && lockService.hasWriteLock(ddLockObject.getName(), owner)) {
                        waitMillis /= 10L;
                        hasDDLock = true;
                    }
                    if (traceLock) {
                        SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("GfxdLockSet: hasDDLock=" + hasDDLock + " for " + owner + " for lock of " + lockObject));
                    }
                }
                Object lock = lockObject.getName();
                success = lockService.writeLock(lock, owner, waitMillis, -1L);
                Map<Object, Integer> retryMap = numWriteRetries.get();
                if (!success && hasDDLock && ((retries = retryMap.get(lock)) == null || retries <= 10)) {
                    retryMap.put(lock, retries == null ? Integer.valueOf(1) : Integer.valueOf(retries + 1));
                    throw StandardException.newException("XCL32.S");
                }
                retryMap.remove(lock);
            }
        } else {
            success = lockService.readLock(lockObject, owner, waitMillis);
        }
        return success;
    }

    public static void unlock(GfxdLockService lockService, GfxdLockable lockObject, Object owner, boolean forUpdate, boolean local) {
        GfxdLockSet.unlock(lockService, lockObject, owner, GfxdLockSet.getLockType(forUpdate, local));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unlock(GfxdLockService lockService, GfxdLockable lockObject, Object owner, LockType type) throws LockNotHeldException {
        block13: {
            if (type.isRead()) {
                lockService.readUnlock(lockObject);
            } else if (type.isLocalWrite()) {
                lockService.getLocalLockService().writeUnlock(lockObject, owner);
            } else {
                Throwable t = null;
                try {
                    lockService.writeUnlock(lockObject.getName(), owner);
                }
                catch (RuntimeException ex) {
                    t = ex;
                }
                catch (Error err) {
                    if (SystemFailure.isJVMFailureError((Error)err)) {
                        SystemFailure.initiateFailure((Error)err);
                        throw err;
                    }
                    SystemFailure.checkFailure();
                    t = err;
                }
                finally {
                    if (t == null) break block13;
                    Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(t);
                    if (t instanceof RuntimeException) {
                        throw t;
                    }
                    throw (Error)t;
                }
            }
        }
    }

    private boolean addLock(GfxdLockable lockObject, long waitMillis, boolean forUpdate, boolean local, LockType lockType) throws StandardException {
        if (GfxdLockSet.lock(this.rwLockService, lockObject, this.owner, waitMillis, forUpdate, local)) {
            this.acquiredLocks.addLast(new LockEntry(lockObject, lockType));
            return true;
        }
        return false;
    }

    static final class LockEntry {
        private final GfxdLockable lockObject;
        private final LockType lockType;
        private int numReentry;
        private LockEntry next;
        private LockEntry previous;

        LockEntry(GfxdLockable lockObject, LockType lockType) {
            this.lockObject = lockObject;
            this.lockType = lockType;
        }

        public final GfxdLockable getLockObject() {
            return this.lockObject;
        }

        public final LockType getLockType() {
            return this.lockType;
        }

        public final void doReenter() {
            ++this.numReentry;
        }

        public final boolean doRelease() {
            switch (this.numReentry) {
                case 0: {
                    return true;
                }
                case 1: {
                    this.numReentry = 0;
                    return false;
                }
            }
            assert (this.numReentry > 0) : "unexpected reentries=" + this.numReentry;
            --this.numReentry;
            return false;
        }

        public final boolean equals(Object other) {
            if (other instanceof LockEntry) {
                LockEntry otherEntry = (LockEntry)other;
                return this.lockType == otherEntry.lockType && this.lockObject.getName().equals(otherEntry.lockObject.getName());
            }
            return false;
        }

        void appendString(StringBuilder sb) {
            sb.append(this.lockObject.getName());
            if (this.numReentry > 0) {
                sb.append("[reentries=").append(this.numReentry).append(']');
            }
        }
    }

    static final class LockList {
        private final LockEntry header = new LockEntry(null, null);

        public LockList() {
            this.header.next = (this.header.previous = this.header);
        }

        public LockEntry getHead() {
            return this.header;
        }

        public LockEntry nextEntry(LockEntry entry) {
            LockEntry nextEntry = entry.next;
            if (nextEntry != this.header) {
                return nextEntry;
            }
            return null;
        }

        public LockEntry getTail() {
            return this.header;
        }

        public LockEntry previousEntry(LockEntry entry) {
            LockEntry prevEntry = entry.previous;
            if (prevEntry != this.header) {
                return prevEntry;
            }
            return null;
        }

        public boolean addFirst(LockEntry entry) {
            assert (entry != null);
            this.addBefore(entry, this.header.next);
            return true;
        }

        public boolean addLast(LockEntry entry) {
            assert (entry != null);
            this.addBefore(entry, this.header);
            return true;
        }

        public void removeEntry(LockEntry entry) {
            if (entry == this.header) {
                throw new NoSuchElementException();
            }
            entry.previous.next = entry.next;
            entry.next.previous = entry.previous;
        }

        public void clear() {
            this.header.next = (this.header.previous = this.header);
        }

        private void addBefore(LockEntry newEntry, LockEntry entry) {
            newEntry.next = entry;
            newEntry.previous = entry.previous;
            newEntry.previous.next = newEntry;
            entry.previous = newEntry;
        }
    }

    public static enum LockType {
        READ,
        WRITE,
        LOCAL_WRITE;


        public final boolean isRead() {
            return this == READ;
        }

        public final boolean isWrite() {
            return this == WRITE;
        }

        public final boolean isLocalWrite() {
            return this == LOCAL_WRITE;
        }
    }
}

