/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.expression;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.expression.AlignToResultSetVisitor;
import com.pivotal.gemfirexd.internal.engine.sql.compile.GemFireExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedClass;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNodeVector;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.ArrayList;

public class ExpressionBuilderVisitor
extends VisitorAdaptor {
    private final CompilerContext cc;
    private GemFireExpressionClassBuilder generatingClass;
    private MethodBuilder resultExprFun;
    private final ArrayList<String> expressionMethodList;
    private GeneratedClass ac;
    private boolean skipChildren;

    public ExpressionBuilderVisitor(LanguageConnectionContext lcc) throws StandardException {
        this.cc = (CompilerContext)lcc.getContextManager().getContext("CompilerContext");
        this.expressionMethodList = new ArrayList();
    }

    private void createClass() throws StandardException {
        this.generatingClass = new GemFireExpressionClassBuilder("com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", null, this.cc);
    }

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        if (QueryTreeNodeVector.class.isInstance(node)) {
            this.skipChildren();
            return false;
        }
        return this.skipChildren;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    public void dontSkipChildren() {
        this.skipChildren = false;
    }

    public void skipChildren() {
        this.skipChildren = true;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (!(node instanceof ValueNode)) {
            return node;
        }
        ValueNode vn = null;
        ResultColumn rc = null;
        if (node instanceof ResultColumn) {
            rc = (ResultColumn)node;
            if (!rc.isExpanded()) {
                this.expressionMethodList.add(null);
                return node;
            }
            vn = rc.getExpression();
        } else {
            vn = (ValueNode)node;
        }
        if (this.generatingClass == null) {
            this.createClass();
        }
        vn.accept(new AlignToResultSetVisitor(0));
        this.generateExpression(vn);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateExpression(ValueNode source) throws StandardException {
        try {
            this.resultExprFun = this.generatingClass.getNewExpressionMethodBuilder();
            source.generateExpression(this.generatingClass, this.resultExprFun);
            this.resultExprFun.cast("com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor");
            this.resultExprFun.methodReturn();
            this.resultExprFun.complete();
            this.expressionMethodList.add(this.resultExprFun.getName());
        }
        finally {
            if (SanityManager.DEBUG_ON((String)"DumpClassFile")) {
                SanityManager.DEBUG_PRINT((String)"DumpClassFile", (String)(" Expression Class [" + this.generatingClass.getClass().getName() + "] generated method " + this.resultExprFun.getName() + " for " + source));
            }
        }
    }

    public ArrayList<String> getMethodsGenerated() {
        return this.expressionMethodList;
    }

    public GeneratedClass getExpressionClass() throws StandardException {
        if (this.generatingClass == null) {
            return null;
        }
        if (GemFireXDUtils.TraceGroupByIter) {
            SanityManager.DEBUG_SET((String)"DumpClassFile");
            SanityManager.DEBUG_SET((String)"ClassLineNumbers");
        }
        this.generatingClass.finishConstruct();
        this.ac = this.generatingClass.getGeneratedClass();
        if (GemFireXDUtils.TraceGroupByIter) {
            SanityManager.DEBUG_PRINT((String)"DumpClassFile", (String)(" Expression Class [" + this.generatingClass.getClass().getName() + "] "));
            this.generatingClass.getClassBytecode();
            SanityManager.DEBUG_CLEAR((String)"DumpClassFile");
            SanityManager.DEBUG_CLEAR((String)"ClassLineNumbers");
        }
        return this.ac;
    }
}

