/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.cache.NoDataStoreAvailableException;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdDistributionAdvisor;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.SnappyResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.message.MemberExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.snappy.CallbackFactoryProvider;
import com.pivotal.gemfirexd.internal.snappy.LeadNodeExecutionContext;
import com.pivotal.gemfirexd.internal.snappy.SparkSQLExecute;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class LeadNodeExecutorMsg
extends MemberExecutorMessage<Object> {
    private String sql;
    private LeadNodeExecutionContext ctx;
    private transient SparkSQLExecute exec;
    private String schema;

    public LeadNodeExecutorMsg(String sql, String schema, LeadNodeExecutionContext ctx, GfxdResultCollector<Object> rc) {
        super(rc, (TXStateInterface)null, false, true);
        this.schema = schema;
        this.sql = sql;
        this.ctx = ctx;
    }

    public LeadNodeExecutorMsg() {
        super(true);
    }

    @Override
    public Set<DistributedMember> getMembers() {
        GfxdDistributionAdvisor advisor = GemFireXDUtils.getGfxdAdvisor();
        InternalDistributedSystem ids = Misc.getDistributedSystem();
        if (ids.isLoner()) {
            return Collections.singleton(ids.getDistributedMember());
        }
        Set allMembers = ids.getAllOtherMembers();
        for (DistributedMember m : allMembers) {
            GfxdDistributionAdvisor.GfxdProfile profile = advisor.getProfile((InternalDistributedMember)m);
            if (profile == null || !profile.hasSparkURL()) continue;
            HashSet<DistributedMember> s = new HashSet<DistributedMember>();
            s.add(m);
            return Collections.unmodifiableSet(s);
        }
        throw new NoDataStoreAvailableException(LocalizedStrings.DistributedRegion_NO_DATA_STORE_FOUND_FOR_DISTRIBUTION.toLocalizedString(new Object[]{"SnappyData Lead Node"}));
    }

    @Override
    public void postExecutionCallback() {
    }

    @Override
    public boolean isHA() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    protected void execute() throws Exception {
        if (GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("LeadNodeExecutorMsg.execute: Got sql = " + this.sql));
        }
        try {
            InternalDistributedMember m = this.getSenderForReply();
            Version v = m.getVersionObject();
            this.exec = CallbackFactoryProvider.getClusterCallbacks().getSQLExecute(this.sql, this.schema, this.ctx, v);
            SnappyResultHolder srh = new SnappyResultHolder(this.exec);
            srh.prepareSend(this);
            this.lastResultSent = true;
            this.endMessage();
            if (GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"LeadNodeExecutorMsg.execute: Sent Last result ");
            }
        }
        catch (Exception ex) {
            throw this.getExceptionToSendToServer(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception getExceptionToSendToServer(Exception ex) {
        boolean wrapExcepton = false;
        try (HeapDataOutputStream hdos = null;){
            hdos = new HeapDataOutputStream();
            DataSerializer.writeObject((Object)ex, (DataOutput)hdos);
        }
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            if (cause.getClass().getName().contains("AnalysisException")) {
                return StandardException.newException("38000", !wrapExcepton ? cause : new SparkExceptionWrapper(cause), (Object)cause.getMessage());
            }
            if (cause.getClass().getName().contains("apache.spark.storage")) {
                return StandardException.newException("XSDA4.S", !wrapExcepton ? cause : new SparkExceptionWrapper(cause), (Object)cause.getMessage());
            }
            if (!cause.getClass().getName().contains("apache.spark.sql")) continue;
            for (Throwable nestedCause = cause.getCause(); nestedCause != null; nestedCause = nestedCause.getCause()) {
                if (!nestedCause.getClass().getName().contains("ErrorLimitExceededException")) continue;
                return StandardException.newException("38000", !wrapExcepton ? nestedCause : new SparkExceptionWrapper(nestedCause), (Object)nestedCause.getMessage());
            }
            return StandardException.newException("38000", !wrapExcepton ? cause : new SparkExceptionWrapper(cause), (Object)cause.getMessage());
        }
        return ex;
    }

    @Override
    protected void executeFunction(boolean enableStreaming) throws StandardException, SQLException {
        try {
            super.executeFunction(enableStreaming);
        }
        catch (RuntimeException re) {
            throw LeadNodeExecutorMsg.handleLeadNodeException(re);
        }
    }

    public static RuntimeException handleLeadNodeException(RuntimeException re) {
        DiskAccessException dae;
        RegionDestroyedException rde;
        Throwable cause = re;
        if (re instanceof GemFireXDRuntimeException || re instanceof FunctionException || re instanceof FunctionExecutionException || re instanceof ReplyException) {
            cause = re.getCause();
        }
        if (cause instanceof RegionDestroyedException && (rde = (RegionDestroyedException)cause).isRemote()) {
            rde.setNotRemote();
        }
        if (cause instanceof DiskAccessException && (dae = (DiskAccessException)cause).isRemote()) {
            dae.setNotRemote();
        }
        return re;
    }

    @Override
    protected LeadNodeExecutorMsg clone() {
        LeadNodeExecutorMsg msg = new LeadNodeExecutorMsg(this.sql, this.schema, this.ctx, (GfxdResultCollector)this.userCollector);
        msg.exec = this.exec;
        return msg;
    }

    @Override
    public byte getGfxdID() {
        return 119;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.sql = DataSerializer.readString((DataInput)in);
        this.schema = DataSerializer.readString((DataInput)in);
        this.ctx = (LeadNodeExecutionContext)DataSerializer.readObject((DataInput)in);
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString((String)this.sql, (DataOutput)out);
        DataSerializer.writeString((String)this.schema, (DataOutput)out);
        DataSerializer.writeObject((Object)this.ctx, (DataOutput)out);
    }

    private static class SparkExceptionWrapper
    extends Exception {
        public SparkExceptionWrapper(Throwable ex) {
            super(ex.getClass().getName() + ": " + ex.getMessage(), ex.getCause());
            this.setStackTrace(ex.getStackTrace());
        }
    }
}

