/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryTimeStatistics;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GfxdFunctionMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.MemberExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.RegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.tools.sizer.ObjectSizer;
import io.snappydata.thrift.ServerType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotSerializableException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;

public final class GfxdConfigMessage<T>
extends MemberExecutorMessage<T> {
    private Set<DistributedMember> members;
    private final AllMembers useAllMembers;
    private Operation configOp;
    private Object opArg;
    private boolean haEnabled;
    private transient boolean serializeMembers;
    public static final int SYSPROPS_INDEX = 0;
    public static final int GFEPROPS_INDEX = 1;
    public static final int GFXDPROPS_INDEX = 2;
    public static final int ALLPROPS_MAXINDEX = 2;

    public GfxdConfigMessage() {
        super(true);
        this.useAllMembers = AllMembers.GIVEN_MEMBERS;
        this.haEnabled = false;
    }

    public GfxdConfigMessage(ResultCollector<Object, T> collector, Set<DistributedMember> members, Operation op, Object arg, boolean allMembersIncludingAdmin) throws StandardException {
        super(collector, null, DistributionStats.enableClockStats, true);
        if (members != null) {
            this.members = new HashSet<DistributedMember>();
            Set<DistributedMember> allMembers = GfxdConfigMessage.getAllDSMembers();
            for (DistributedMember member : members) {
                if (allMembers.contains(member)) {
                    this.members.add(member);
                    continue;
                }
                throw StandardException.newException("0A000.S.15", member);
            }
            this.useAllMembers = AllMembers.GIVEN_MEMBERS;
            this.haEnabled = false;
        } else {
            this.members = null;
            this.haEnabled = true;
            this.useAllMembers = allMembersIncludingAdmin ? AllMembers.ALL_MEMBERS_INCLUDING_ADMIN : AllMembers.ALL_MEMBERS;
        }
        this.configOp = op;
        this.opArg = arg;
    }

    private GfxdConfigMessage(GfxdConfigMessage<T> other) throws StandardException {
        super(other);
        if (other.members != null) {
            this.members = new HashSet<DistributedMember>();
            Set<DistributedMember> allMembers = GfxdConfigMessage.getAllDSMembers();
            for (DistributedMember member : other.members) {
                if (allMembers.contains(member)) {
                    this.members.add(member);
                    continue;
                }
                throw StandardException.newException("0A000.S.15", member);
            }
            this.useAllMembers = AllMembers.GIVEN_MEMBERS;
            this.haEnabled = false;
        } else {
            this.members = null;
            this.haEnabled = true;
            this.useAllMembers = other.useAllMembers;
        }
        this.configOp = other.configOp;
        this.opArg = other.opArg;
    }

    @Override
    protected void execute() {
        Object result = this.configOp.process(this.opArg, this.members, this);
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GfxdConfigMessage#execute: done processing for operation=" + (Object)((Object)this.configOp) + " args=" + this.opArg + " with result=" + result));
        }
        this.lastResult(result);
    }

    @Override
    public Set<DistributedMember> getMembers() {
        switch (this.useAllMembers) {
            case ALL_MEMBERS: {
                this.members = GfxdConfigMessage.getAllGfxdServers();
                break;
            }
            case ALL_MEMBERS_INCLUDING_ADMIN: {
                this.members = GfxdConfigMessage.getAllDSMembers();
                break;
            }
        }
        Set<DistributedMember> sendMembers = this.configOp.getTargetMembers(this.members);
        if (sendMembers != null) {
            this.serializeMembers = true;
        } else {
            this.serializeMembers = false;
            sendMembers = this.members;
        }
        return sendMembers;
    }

    @Override
    public boolean isHA() {
        return this.haEnabled;
    }

    public void setHA(boolean enable) {
        this.haEnabled = enable;
    }

    @Override
    public boolean optimizeForWrite() {
        return true;
    }

    @Override
    public void postExecutionCallback() {
    }

    @Override
    protected boolean allowExecutionOnAdminMembers() {
        return true;
    }

    @Override
    protected GfxdFunctionMessage.GfxdFunctionReplyMessageProcessor<T> createReplyProcessor(DM dm, Set<DistributedMember> members) {
        return new GfxdConfigReplyProcessor(dm, members, this);
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writePrimitiveByte((byte)((byte)this.configOp.ordinal()), (DataOutput)out);
        DataSerializer.writeObject((Object)this.opArg, (DataOutput)out);
        if (this.serializeMembers) {
            InternalDataSerializer.writeArrayLength((int)this.members.size(), (DataOutput)out);
            for (DistributedMember member : this.members) {
                ((InternalDistributedMember)member).toData(out);
            }
        } else {
            InternalDataSerializer.writeArrayLength((int)0, (DataOutput)out);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        byte opOrdinal = DataSerializer.readPrimitiveByte((DataInput)in);
        this.configOp = Operation.values[opOrdinal];
        this.opArg = DataSerializer.readObject((DataInput)in);
        int numMembers = InternalDataSerializer.readArrayLength((DataInput)in);
        if (numMembers > 0) {
            this.members = new HashSet<DistributedMember>(numMembers);
            for (int count = 1; count <= numMembers; ++count) {
                InternalDistributedMember member = new InternalDistributedMember();
                member.fromData(in);
                this.members.add((DistributedMember)member);
            }
            this.serializeMembers = true;
        } else {
            this.members = null;
            this.serializeMembers = false;
        }
    }

    @Override
    public byte getGfxdID() {
        return 30;
    }

    @Override
    protected void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append(";op=").append((Object)this.configOp).append(";arg=").append(this.opArg).append(";useAllMembers=").append((Object)this.useAllMembers).append(";members=").append(this.members);
    }

    @Override
    protected GfxdConfigMessage<T> clone() {
        try {
            return new GfxdConfigMessage<T>(this);
        }
        catch (StandardException se) {
            throw GemFireXDRuntimeException.newRuntimeException(null, se);
        }
    }

    protected static final class GfxdConfigReplyProcessor<T>
    extends GfxdFunctionMessage.GfxdFunctionReplyMessageProcessor<T> {
        public GfxdConfigReplyProcessor(DM dm, Set<DistributedMember> members, GfxdFunctionMessage<T> msg) {
            super(dm, members, msg);
        }

        @Override
        protected final void handleReplyException(String exPrefix, ReplyException ex, GfxdFunctionMessage<?> fnMsg) throws SQLException, StandardException {
            Map<DistributedMember, ReplyException> exceptions = this.getReplyExceptions();
            if (exceptions != null) {
                for (Map.Entry<DistributedMember, ReplyException> entry : exceptions.entrySet()) {
                    ReplyException replyEx = entry.getValue();
                    if (replyEx.getCause() instanceof NotSerializableException) {
                        this.addResult(entry.getKey(), null);
                        continue;
                    }
                    GfxdFunctionMessage.handleProcessorReplyException(exPrefix, replyEx.getCause());
                }
            }
            GfxdFunctionMessage.handleProcessorReplyException(exPrefix, ex.getCause());
        }
    }

    public static enum Operation {
        GET_SYSPROPS{

            @Override
            public Set<DistributedMember> getTargetMembers(Set<DistributedMember> members) {
                return null;
            }

            @Override
            public Object process(Object arg, Set<DistributedMember> members, GfxdConfigMessage<?> msg) {
                TreeMap props = new TreeMap();
                Operation.addSYSProps(props);
                return props;
            }
        }
        ,
        GET_GFEPROPS{

            @Override
            public Set<DistributedMember> getTargetMembers(Set<DistributedMember> members) {
                return null;
            }

            @Override
            public Object process(Object arg, Set<DistributedMember> members, GfxdConfigMessage<?> msg) {
                TreeMap props = new TreeMap();
                Operation.addGFEProps(props);
                return props;
            }
        }
        ,
        GET_GFXDPROPS{

            @Override
            public Set<DistributedMember> getTargetMembers(Set<DistributedMember> members) {
                return null;
            }

            @Override
            public Object process(Object arg, Set<DistributedMember> members, GfxdConfigMessage<?> msg) {
                TreeMap props = new TreeMap();
                Operation.addGFXDProps(props);
                return props;
            }
        }
        ,
        GET_ALLPROPS{

            @Override
            public Set<DistributedMember> getTargetMembers(Set<DistributedMember> members) {
                return null;
            }

            @Override
            public Object process(Object arg, Set<DistributedMember> members, GfxdConfigMessage<?> msg) {
                Properties[] allProps = new Properties[3];
                Properties props = new Properties();
                Operation.addSYSProps(props);
                allProps[0] = props;
                props = new Properties();
                Operation.addGFEProps(props);
                allProps[1] = props;
                props = new Properties();
                Operation.addGFXDProps(props);
                allProps[2] = props;
                return allProps;
            }
        }
        ,
        GET_JVMSTATS{

            @Override
            public Set<DistributedMember> getTargetMembers(Set<DistributedMember> members) {
                return null;
            }

            @Override
            public Object process(Object arg, Set<DistributedMember> members, GfxdConfigMessage<?> msg) {
                TreeMap<String, Object> map = new TreeMap<String, Object>();
                for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
                    String gcPrefix = "gc-" + gcBean.getName();
                    map.put(gcPrefix + "-collection-count", gcBean.getCollectionCount());
                    map.put(gcPrefix + "-collection-time", gcBean.getCollectionTime());
                    map.put(gcPrefix + "-memory-pools", GemFireXDUtils.toCSV(gcBean.getMemoryPoolNames()));
                }
                ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
                map.put("thread-count", threadBean.getThreadCount());
                map.put("thread-total-count", threadBean.getTotalStartedThreadCount());
                map.put("thread-peak-count", threadBean.getPeakThreadCount());
                MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
                MemoryUsage heapUsage = memBean.getHeapMemoryUsage();
                MemoryUsage nonHeapUsage = memBean.getNonHeapMemoryUsage();
                map.put("memory-heap-max", heapUsage.getMax());
                map.put("memory-heap-committed", heapUsage.getCommitted());
                map.put("memory-heap-used", heapUsage.getUsed());
                map.put("memory-nonheap-max", nonHeapUsage.getMax());
                map.put("memory-nonheap-committed", nonHeapUsage.getCommitted());
                map.put("memory-nonheap-used", nonHeapUsage.getUsed());
                Runtime rt = Runtime.getRuntime();
                map.put("memory-free", rt.freeMemory());
                map.put("memory-max", rt.maxMemory());
                map.put("memory-total", rt.totalMemory());
                map.put("available-processors", rt.availableProcessors());
                return map;
            }
        }
        ,
        ENABLE_QUERYSTATS{

            @Override
            public Set<DistributedMember> getTargetMembers(Set<DistributedMember> members) {
                return null;
            }

            @Override
            public Object process(Object arg, Set<DistributedMember> members, GfxdConfigMessage<?> msg) {
                boolean enableOrDisable = (Boolean)arg;
                GemFireXDUtils.setOptimizerTrace(enableOrDisable);
                if (enableOrDisable) {
                    GemFireXDQueryObserverHolder.putInstanceIfAbsent(new GemFireXDQueryTimeStatistics(0));
                } else {
                    GemFireXDQueryObserverHolder.removeObserver(GemFireXDQueryTimeStatistics.class);
                }
                return null;
            }
        }
        ,
        GET_QUERYSTATS{

            @Override
            public Set<DistributedMember> getTargetMembers(Set<DistributedMember> members) {
                return null;
            }

            @Override
            public Object process(Object arg, Set<DistributedMember> members, GfxdConfigMessage<?> msg) {
                GemFireXDQueryTimeStatistics stats = GemFireXDQueryObserverHolder.getObserver(GemFireXDQueryTimeStatistics.class);
                if (stats != null) {
                    ArrayList statsMapList = new ArrayList();
                    Iterator<Map.Entry<String, GemFireXDQueryTimeStatistics.QueryStatistics[]>> mapIter = stats.getIterator();
                    while (mapIter.hasNext()) {
                        Map.Entry<String, GemFireXDQueryTimeStatistics.QueryStatistics[]> entry = mapIter.next();
                        HashMap<String, Object> statsMap = new HashMap<String, Object>();
                        GemFireXDQueryTimeStatistics.QueryStatistics[] queryStats = entry.getValue();
                        statsMap.put("QUERY", entry.getKey());
                        statsMap.put("PARAMSSIZE", 0);
                        GemFireXDQueryTimeStatistics.QueryStatistics optimStats = queryStats[GemFireXDQueryTimeStatistics.StatType.QUERY_OPTIMIZATION.ordinal()];
                        String plan = (String)optimStats.getCustomObject();
                        if (plan == null) {
                            plan = "";
                        }
                        statsMap.put("PLAN", plan);
                        GemFireXDQueryTimeStatistics.QueryStatistics totalStats = queryStats[GemFireXDQueryTimeStatistics.StatType.TOTAL_EXECUTION.ordinal()];
                        statsMap.put("NUMINVOCATIONS", totalStats.getNumInvocations());
                        statsMap.put("TOTALTIME", totalStats.getTotalTimeInNanos());
                        GemFireXDQueryTimeStatistics.QueryStatistics distribStats = queryStats[GemFireXDQueryTimeStatistics.StatType.TOTAL_DISTRIBUTION.ordinal()];
                        statsMap.put("DISTRIBUTIONTIME", distribStats.getTotalTimeInNanos());
                        long serNanos = queryStats[GemFireXDQueryTimeStatistics.StatType.RESULT_HOLDER_SERIALIZATION.ordinal()].getTotalTimeInNanos();
                        if (serNanos <= 0L) {
                            serNanos = queryStats[GemFireXDQueryTimeStatistics.StatType.RESULT_HOLDER_READ.ordinal()].getTotalTimeInNanos();
                        }
                        statsMap.put("SERIALIZATIONTIME", serNanos);
                        GemFireXDQueryTimeStatistics.QueryStatistics stmtStats = queryStats[GemFireXDQueryTimeStatistics.StatType.RESULT_HOLDER_EXECUTE.ordinal()];
                        long execNanos = stmtStats.getTotalTimeInNanos();
                        if (execNanos <= 0L && (execNanos = (stmtStats = queryStats[GemFireXDQueryTimeStatistics.StatType.PREPSTATEMENT_QUERY_EXECUTION.ordinal()]).getTotalTimeInNanos()) <= 0L) {
                            stmtStats = queryStats[GemFireXDQueryTimeStatistics.StatType.STATEMENT_QUERY_EXECUTION.ordinal()];
                            execNanos = stmtStats.getTotalTimeInNanos();
                        }
                        statsMap.put("EXECUTIONTIME", execNanos);
                        GemFireXDQueryTimeStatistics.QueryStatistics ormStats = queryStats[GemFireXDQueryTimeStatistics.StatType.ORM_TIME.ordinal()];
                        statsMap.put("ORMTIME", ormStats.getTotalTimeInNanos());
                        statsMapList.add(statsMap);
                    }
                    return statsMapList;
                }
                return null;
            }
        }
        ,
        GET_PREFERREDSERVER{

            @Override
            public Set<DistributedMember> getTargetMembers(Set<DistributedMember> members) {
                return null;
            }

            @Override
            public Object process(Object arg, Set<DistributedMember> members, GfxdConfigMessage<?> msg) {
                try {
                    String excludedServers;
                    Collection intersectGroups;
                    Collection<String> serverGroups;
                    if (arg instanceof Object[]) {
                        Object[] args = (Object[])arg;
                        serverGroups = (Collection)args[0];
                        intersectGroups = (Collection)args[1];
                        excludedServers = (String)args[2];
                    } else {
                        serverGroups = Collections.singletonList(ServerType.DRDA.getServerGroupName());
                        intersectGroups = null;
                        excludedServers = arg != null ? arg.toString() : null;
                    }
                    return GemFireXDUtils.getPreferredServer(serverGroups, intersectGroups, excludedServers, false);
                }
                catch (SQLException ex) {
                    throw GemFireXDRuntimeException.newRuntimeException("failed in GET_PREFERREDSERVER", ex);
                }
            }
        }
        ,
        GET_PER_REGION_MEMORY_FOOTPRINT{
            private static final String logPrefix = "objectsizer: ";

            @Override
            public Set<DistributedMember> getTargetMembers(Set<DistributedMember> members) {
                return null;
            }

            @Override
            public Object process(Object arg, Set<DistributedMember> members, GfxdConfigMessage<?> msg) {
                ObjectSizer sizer = ObjectSizer.getInstance(false);
                try {
                    sizer.initialize(false, "!");
                    sizer.setQueryHints(null);
                    LinkedHashMap<String, Object[]> result = new LinkedHashMap<String, Object[]>();
                    ArrayList<GemFireContainer> targetContainers = new ArrayList<GemFireContainer>();
                    ObjectSizer.getTargetContainers(targetContainers);
                    int size = targetContainers.size();
                    for (int idx = 0; idx < size; ++idx) {
                        GemFireContainer c = targetContainers.get(idx);
                        SanityManager.DEBUG_PRINT((String)"TRACE", (String)("objectsizer: Estimating for container " + c));
                        LinkedHashMap<String, Object[]> retVal = sizer.size(c, null);
                        sizer.logSizes(retVal);
                        result.putAll(retVal);
                    }
                    sizer.setQueryHints(null);
                    LinkedHashMap<String, Object[]> linkedHashMap = result;
                    return linkedHashMap;
                }
                catch (Exception e) {
                    throw GemFireXDRuntimeException.newRuntimeException("Exception in GfxdCongiMessage#" + this.name(), e);
                }
                finally {
                    sizer.done();
                }
            }
        }
        ,
        DUMP_BUCKETS{

            @Override
            public Set<DistributedMember> getTargetMembers(Set<DistributedMember> members) {
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object process(Object arg, Set<DistributedMember> members, GfxdConfigMessage<?> msg) {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                if (cache == null) {
                    return null;
                }
                boolean dumpBackingMap = arg != null && arg instanceof Boolean ? (Boolean)arg : false;
                String dumpBackingMapFlag = "DumpBackingMap";
                String dumpFlag = "DumpBuckets";
                String lineSep = SanityManager.lineSeparator;
                String tabMarker = lineSep + "*******************************************";
                Set prset = cache.getPartitionedRegions();
                for (PartitionedRegion preg : prset) {
                    GemFireContainer gfc;
                    if (preg == null || preg.isDestroyed() || (gfc = (GemFireContainer)preg.getUserAttribute()) == null) {
                        SanityManager.DEBUG_PRINT((String)"warning:DumpBuckets", (String)("GemFire Region/Container is null or destroyed for " + preg.getFullPath()));
                        continue;
                    }
                    if (gfc.isGlobalIndex()) continue;
                    SanityManager.DEBUG_PRINT((String)"DumpBuckets", (String)(tabMarker + lineSep + "Dumping bucket info for table: " + gfc.getTableName() + " region=" + preg + tabMarker));
                    try {
                        GfxdIndexManager idxman;
                        PartitionedRegionDataStore store = preg.getDataStore();
                        RowFormatter rf = gfc.getCurrentRowFormatter();
                        String[] columnNames = null;
                        if (rf == null) {
                            SanityManager.DEBUG_PRINT((String)"DumpBuckets", (String)(gfc.getTableName() + " RowFormatter is found NULL for table " + gfc.getTableName() + " here " + cache.getMyId()));
                        } else {
                            columnNames = new String[rf.getNumColumns()];
                            for (int index = 0; index < rf.getNumColumns(); ++index) {
                                columnNames[index] = rf.getColumnDescriptor(index).getColumnName();
                            }
                        }
                        if (store != null) {
                            for (BucketRegion breg : store.getAllLocalBucketRegions()) {
                                if (breg.isDestroyed()) {
                                    SanityManager.DEBUG_PRINT((String)"DumpBuckets", (String)(gfc.getTableName() + " bucket " + preg.bucketStringForLogs(breg.getId()) + " is destroyed. skipping here " + cache.getMyId()));
                                    continue;
                                }
                                StringBuilder sb = new StringBuilder(lineSep);
                                boolean isPrimary = breg.getBucketAdvisor().isPrimary();
                                sb.append("======== Bucket ID=").append(preg.bucketStringForLogs(breg.getId())).append(" region=").append(breg.getName()).append(" primary=").append(isPrimary).append(" contents: ========");
                                Iterator iter = breg.getBestLocalIterator(true);
                                while (iter.hasNext()) {
                                    RegionEntry entry = (RegionEntry)iter.next();
                                    ExecRow row = RegionEntryUtils.getRowWithoutFaultIn(gfc, (LocalRegion)breg, entry, (ExtraTableInfo)entry.getContainerInfo());
                                    try {
                                        sb.append(lineSep).append('\t');
                                        if (row != null) {
                                            DataValueDescriptor[] dvds = row.getRowArray();
                                            for (int index = 0; index < dvds.length; ++index) {
                                                if (index > 0) {
                                                    sb.append(',');
                                                }
                                                sb.append(columnNames != null ? columnNames[index] : "col" + index).append(':').append(dvds[index]);
                                            }
                                        } else {
                                            sb.append("NULL").append(" for RE ").append(entry);
                                        }
                                    }
                                    finally {
                                        if (row != null) {
                                            row.releaseByteSource();
                                        }
                                    }
                                    if (sb.length() <= 0x400000) continue;
                                    SanityManager.DEBUG_PRINT((String)"DumpBuckets", (String)sb.toString());
                                    sb.setLength(0);
                                }
                                SanityManager.DEBUG_PRINT((String)"DumpBuckets", (String)sb.toString());
                                if (!dumpBackingMap) continue;
                                SanityManager.DEBUG_PRINT((String)"DumpBackingMap", (String)("Dumping backing map of " + breg));
                                breg.dumpBackingMap();
                            }
                        } else {
                            SanityManager.DEBUG_PRINT((String)"DumpBuckets", (String)(gfc.getTableName() + " prId=" + preg.getPRId() + " table is not a DataStore here " + cache.getMyId()));
                        }
                        if ((idxman = (GfxdIndexManager)preg.getIndexUpdater()) == null) continue;
                        idxman.dumpAllIndexes();
                    }
                    catch (Exception ex) {
                        SanityManager.DEBUG_PRINT((String)"DumpBuckets", (String)("exception while dumping contents of region: " + preg), (Throwable)ex);
                    }
                }
                return null;
            }
        }
        ,
        SET_CLIENT_OR_SERVER{

            @Override
            public Set<DistributedMember> getTargetMembers(Set<DistributedMember> members) {
                return null;
            }

            @Override
            public Object process(Object arg, Set<DistributedMember> members, GfxdConfigMessage<?> msg) {
                Boolean isServer = (Boolean)arg;
                ServerGroupUtils.setIsServer(isServer);
                return null;
            }
        }
        ,
        SET_SERVERGROUPS{

            @Override
            public Set<DistributedMember> getTargetMembers(Set<DistributedMember> members) {
                return null;
            }

            @Override
            public Object process(Object arg, Set<DistributedMember> members, GfxdConfigMessage<?> msg) {
                SortedSet newServerGroups = SharedUtils.toSortedSet((String)((String)arg), (boolean)false);
                ServerGroupUtils.setServerGroups(newServerGroups);
                return null;
            }
        };

        static Operation[] values;

        abstract Set<DistributedMember> getTargetMembers(Set<DistributedMember> var1);

        abstract Object process(Object var1, Set<DistributedMember> var2, GfxdConfigMessage<?> var3);

        private static void addSYSProps(Map<Object, Object> props) {
            props.putAll(System.getProperties());
        }

        private static void addGFEProps(Map<Object, Object> props) {
            InternalDistributedSystem sys = Misc.getDistributedSystem();
            for (Map.Entry<Object, Object> entry : sys.getProperties().entrySet()) {
                String key = entry.getKey().toString();
                if (key.startsWith("gemfire.security-") || key.startsWith("gemfire.sys.security-")) continue;
                props.put(key, entry.getValue());
            }
        }

        private static void addGFXDProps(Map<Object, Object> props) {
            GemFireStore memStore = GemFireStore.getBootedInstance();
            if (memStore == null) {
                return;
            }
            Map<Object, Object> bootProps = memStore.getBootProperties();
            if (bootProps.size() > 0) {
                props.putAll(bootProps);
            }
        }

        static {
            values = Operation.values();
        }
    }

    private static enum AllMembers {
        GIVEN_MEMBERS,
        ALL_MEMBERS,
        ALL_MEMBERS_INCLUDING_ADMIN;

    }
}

