/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.pivotal.gemfirexd.internal.engine.Misc;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;

public class RegionSizeCalculatorFunction
implements Function,
Declarable {
    public static String ID = "RegionSizeCalculatorFunction";

    public void init(Properties props) {
    }

    public boolean hasResult() {
        return true;
    }

    public void execute(FunctionContext context) {
        HashMap<String, Long> regionSizeInfo = new HashMap<String, Long>();
        try {
            Set partitionedRegions = Misc.getGemFireCache().getPartitionedRegions();
            for (PartitionedRegion pr : partitionedRegions) {
                long valueSizeOfRegion = this.getSizeForAllPrimaryBucketsOfRegion(pr);
                String qualifiedTableName = Misc.getFullTableNameFromRegionPath(pr.getFullPath());
                regionSizeInfo.put(qualifiedTableName, valueSizeOfRegion);
            }
            context.getResultSender().lastResult(regionSizeInfo);
        }
        catch (CacheClosedException e) {
            context.getResultSender().lastResult(regionSizeInfo);
        }
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return true;
    }

    private long getSizeForAllPrimaryBucketsOfRegion(PartitionedRegion region) {
        long sizeOfRegion = 0L;
        PartitionedRegionDataStore datastore = region.getDataStore();
        if (datastore != null) {
            Set bucketRegions = datastore.getAllLocalBucketRegions();
            for (BucketRegion br : bucketRegions) {
                sizeOfRegion += br.getTotalBytes();
            }
        }
        return sizeOfRegion;
    }
}

