/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisee;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.ServerLocator;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.BridgeServerAdvisor;
import com.gemstone.gemfire.internal.cache.ControllerAdvisor;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.GridAdvisor;
import com.gemstone.gemfire.internal.cache.UpdateAttributesProcessor;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gemfire.internal.util.concurrent.StoppableReentrantReadWriteLock;
import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.THashSet;
import com.gemstone.gnu.trove.TObjectProcedure;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.NetworkInterface;
import com.pivotal.gemfirexd.internal.engine.GfxdSerializable;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.snappy.CallbackFactoryProvider;
import io.snappydata.thrift.HostAddress;
import io.snappydata.thrift.ServerType;
import io.snappydata.thrift.common.ThriftUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class GfxdDistributionAdvisor
extends DistributionAdvisor {
    private final StoppableReentrantReadWriteLock mapLock;
    private final StoppableReentrantReadWriteLock newMemberLock;
    private final Map<String, Map<InternalDistributedMember, GemFireStore.VMKind>> serverGroupMap;
    private final Map<InternalDistributedMember, String> locatorMap;
    private final Map<InternalDistributedMember, Set<HostAddress>> thriftServers;
    private final Map<InternalDistributedMember, Set<String>> drdaServerMap;
    private volatile GfxdProfile myProfile;
    private static final String DEFAULT_GROUP = "";
    public static final char MEMBER_KIND_BEGIN = '{';
    public static final char MEMBER_KIND_END = '}';

    private GfxdDistributionAdvisor(DistributionAdvisee advisee, GemFireCacheImpl cache) {
        super(advisee);
        this.mapLock = new StoppableReentrantReadWriteLock(false, true, cache.getCancelCriterion());
        this.newMemberLock = cache.getSystem().getVMIdAdvisor().getNewMemberLock();
        this.serverGroupMap = new HashMap<String, Map<InternalDistributedMember, GemFireStore.VMKind>>();
        this.locatorMap = new HashMap<InternalDistributedMember, String>();
        this.thriftServers = new HashMap<InternalDistributedMember, Set<HostAddress>>();
        this.drdaServerMap = new HashMap<InternalDistributedMember, Set<String>>();
    }

    public static GfxdDistributionAdvisor createGfxdDistributionAdvisor(DistributionAdvisee advisee, GemFireCacheImpl cache) {
        GfxdDistributionAdvisor advisor = new GfxdDistributionAdvisor(advisee, cache);
        advisor.initialize();
        return advisor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handshake(LogWriter logger) {
        GfxdDistributionAdvisor gfxdDistributionAdvisor = this;
        synchronized (gfxdDistributionAdvisor) {
            this.myProfile = (GfxdProfile)this.createProfile();
            SortedSet<String> groups = this.myProfile.getServerGroups();
            GemFireStore.VMKind kind = this.myProfile.getVMKind();
            InternalDistributedMember member = this.myProfile.getDistributedMember();
            boolean mapLockAcquired = false;
            this.newMemberLock.writeLock().lock();
            try {
                ServerLocator serverLoc;
                this.mapLock.writeLock().lock();
                mapLockAcquired = true;
                this.addMemberGroups(member, groups, kind);
                Locator locator = Locator.getLocator();
                if (locator != null && (serverLoc = ((InternalLocator)locator).getServerLocatorAdvisee()) != null) {
                    this.addMemberServer(member, serverLoc.getHostName() + '[' + serverLoc.getPort() + ']', this.locatorMap, false);
                }
            }
            finally {
                try {
                    if (mapLockAcquired) {
                        this.mapLock.writeLock().unlock();
                    }
                }
                finally {
                    this.newMemberLock.writeLock().unlock();
                }
            }
            if (logger.configEnabled()) {
                logger.config("This JVM is setup with SnappyData " + kind.toString() + " role.");
                if (!groups.isEmpty()) {
                    logger.config("Server groups this JVM is member of: " + SharedUtils.toCSV(groups));
                }
            }
        }
        new UpdateAttributesProcessor((DistributionAdvisee)new DummyControllerAdvisee()).distribute(true);
        this.initializationGate();
        Set<DistributedMember> servers = this.adviseAllNodes(null);
        for (DistributedMember server : servers) {
            GfxdProfile other = GemFireXDUtils.getGfxdProfile(server);
            if (!GemFireXDUtils.getMyVMKind().isAdmin() && other.getLocale() != null && !this.myProfile.getLocale().equals(other.getLocale())) {
                throw new GemFireXDRuntimeException("Locale should be same on all nodes in the cluster. Locale of the current node is " + this.myProfile.getLocale() + ", locale of the other node in the cluster is " + other.getLocale() + ". Other node's id: " + other.peerMemberId.getId());
            }
            if (!GemFireXDUtils.getMyVMKind().isStore() || !other.vmKind.isStore() || other.isPersistDD() == this.myProfile.isPersistDD()) continue;
            throw new GemFireXDRuntimeException("persist-dd should be same on all the servers");
        }
    }

    protected final GfxdProfile instantiateProfile(InternalDistributedMember memberId, int version) {
        return new GfxdProfile(memberId, version, CallbackFactoryProvider.getClusterCallbacks().getDriverURL());
    }

    public boolean useAdminMembersForDefault() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized boolean basicAddProfile(DistributionAdvisor.Profile p) {
        boolean isAdded = false;
        boolean mapLockAcquired = false;
        InternalDistributedMember m = p.getDistributedMember();
        this.newMemberLock.writeLock().lock();
        try {
            this.mapLock.writeLock().lock();
            mapLockAcquired = true;
            if (p instanceof GfxdProfile) {
                isAdded = super.basicAddProfile(p);
                GfxdProfile profile = (GfxdProfile)p;
                GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
                if (cache != null) {
                    cache.updateNodeStatus(m, profile.getInitialized());
                }
                if (isAdded) {
                    this.addMemberGroups(m, profile.getServerGroups(), profile.getVMKind());
                } else {
                    this.removeMemberGroups(m);
                    this.addMemberGroups(m, profile.getServerGroups(), profile.getVMKind());
                }
            } else if (p instanceof BridgeServerAdvisor.BridgeServerProfile) {
                BridgeServerAdvisor.BridgeServerProfile bp = (BridgeServerAdvisor.BridgeServerProfile)p;
                if (bp.getPort() > 0) {
                    String[] groups = bp.getGroups();
                    ServerType serverType = groups == null || groups.length == 0 ? ServerType.DRDA : ServerType.findByGroupName((String)groups[0]);
                    isAdded = ServerType.DRDA.equals((Object)serverType) ? this.addMemberServer(m, bp.getHost() + '[' + bp.getPort() + ']', this.drdaServerMap, true) : this.addMemberServer(m, ThriftUtils.getHostAddress((String)bp.getHost(), (int)bp.getPort()).setServerType(serverType), this.thriftServers, true);
                }
            } else if (p instanceof ControllerAdvisor.ControllerProfile) {
                ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)p;
                if (cp.getPort() > 0) {
                    isAdded = this.addMemberServer(m, cp.getHost() + '[' + cp.getPort() + ']', this.locatorMap, false);
                }
            } else {
                Assert.fail((Object)("GfxdDistributionAdvisor: unexpected profile added: (" + p.getClass().getName() + ')' + p));
            }
        }
        finally {
            try {
                if (mapLockAcquired) {
                    this.mapLock.writeLock().unlock();
                }
            }
            finally {
                this.newMemberLock.writeLock().unlock();
            }
        }
        return isAdded;
    }

    protected final boolean evaluateProfiles(DistributionAdvisor.Profile newProfile, DistributionAdvisor.Profile oldProfile) {
        if (oldProfile != null && oldProfile instanceof GfxdProfile && newProfile instanceof GfxdProfile) {
            return ((GfxdProfile)oldProfile).getInitialized() == ((GfxdProfile)newProfile).getInitialized();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean removeId(DistributionAdvisor.ProfileId memberId, boolean crashed, boolean destroyed, boolean fromMembershipListener) {
        boolean removed = false;
        this.mapLock.writeLock().lock();
        try {
            if (memberId instanceof InternalDistributedMember) {
                InternalDistributedMember m = (InternalDistributedMember)memberId;
                removed = super.removeId(memberId, crashed, destroyed, fromMembershipListener);
                if (removed) {
                    this.removeMemberGroups(m);
                }
                this.thriftServers.remove(m);
                this.drdaServerMap.remove(m);
                this.locatorMap.remove(m);
            } else if (memberId instanceof GridAdvisor.GridProfileId) {
                GridAdvisor.GridProfileId id = (GridAdvisor.GridProfileId)memberId;
                InternalDistributedMember m = id.getMemberId();
                Set<HostAddress> thriftServers = this.thriftServers.get(m);
                if (thriftServers != null && thriftServers.remove(ThriftUtils.getHostAddress((String)id.getHost(), (int)id.getPort()))) {
                    if (thriftServers.isEmpty()) {
                        this.thriftServers.remove(m);
                    }
                    boolean bl = true;
                    return bl;
                }
                String idStr = id.getHost() + '[' + id.getPort() + ']';
                Set<String> netServers = this.drdaServerMap.get(m);
                if (netServers != null && netServers.remove(idStr)) {
                    if (netServers.isEmpty()) {
                        this.drdaServerMap.remove(m);
                    }
                    boolean bl = true;
                    return bl;
                }
                if (this.locatorMap.remove(m) != null) {
                    boolean bl = true;
                    return bl;
                }
            } else {
                Assert.fail((Object)("GfxdDistributionAdvisor: unexpected profile ID to remove: (" + memberId.getClass().getName() + ')' + memberId));
            }
        }
        finally {
            this.mapLock.writeLock().unlock();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void distributeProfileUpdate() {
        GfxdDistributionAdvisor gfxdDistributionAdvisor = this;
        synchronized (gfxdDistributionAdvisor) {
            this.myProfile = (GfxdProfile)this.createProfile();
            InternalDistributedMember m = this.myProfile.getDistributedMember();
            boolean mapLockAcquired = false;
            this.newMemberLock.writeLock().lock();
            try {
                this.mapLock.writeLock().lock();
                mapLockAcquired = true;
                this.removeMemberGroups(m);
                this.addMemberGroups(m, this.myProfile.getServerGroups(), this.myProfile.getVMKind());
            }
            finally {
                try {
                    if (mapLockAcquired) {
                        this.mapLock.writeLock().unlock();
                    }
                }
                finally {
                    this.newMemberLock.writeLock().unlock();
                }
            }
        }
        new UpdateAttributesProcessor(this.getAdvisee()).distribute(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void distributeNodeStatus(boolean initialized) {
        InternalDistributedMember myId;
        GfxdDistributionAdvisor gfxdDistributionAdvisor = this;
        synchronized (gfxdDistributionAdvisor) {
            this.myProfile = (GfxdProfile)this.createProfile();
            myId = this.myProfile.getDistributedMember();
            this.myProfile.setInitialized(initialized);
        }
        GemFireCacheImpl cache = Misc.getGemFireCache();
        if (DistributionManager.VERBOSE || GemFireXDUtils.TraceQuery || SanityManager.isFineEnabled || GemFireXDUtils.TraceNCJ) {
            cache.getLoggerI18n().fine("GfxdProfile: set this node " + myId + " as initialized");
        }
        cache.updateNodeStatus(myId, initialized);
        new UpdateAttributesProcessor(this.getAdvisee()).distribute(false);
    }

    public void close() {
        try {
            new UpdateAttributesProcessor(this.getAdvisee(), true).distribute(false);
            super.close();
        }
        catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
            // empty catch block
        }
    }

    public GfxdProfile getMyProfile() {
        return this.myProfile;
    }

    public final Set<DistributedMember> adviseDataStores(Set<String> groups) {
        return this.adviseVMsOfKind(groups, GemFireStore.VMKind.DATASTORE);
    }

    public final Set<DistributedMember> adviseAccessors(Set<String> groups) {
        return this.adviseVMsOfKind(groups, GemFireStore.VMKind.ACCESSOR);
    }

    public final Set<DistributedMember> adviseLocators(Set<String> groups) {
        return this.adviseVMsOfKind(groups, GemFireStore.VMKind.LOCATOR);
    }

    public final Set<DistributedMember> adviseOperationNodes(Set<String> groups) {
        return this.adviseVMsOfKind(groups, VMKindToken.SERVER);
    }

    public final Set<DistributedMember> adviseAllNodes(Set<String> groups) {
        return this.adviseVMsOfKind(groups, VMKindToken.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<DistributedMember> adviseServerLocators(boolean skipNonGfxd) {
        THashSet locators = new THashSet();
        this.mapLock.readLock().lock();
        try {
            Map<InternalDistributedMember, GemFireStore.VMKind> gfxdMembers = null;
            if (skipNonGfxd) {
                gfxdMembers = this.serverGroupMap.get(DEFAULT_GROUP);
            }
            for (Map.Entry<InternalDistributedMember, String> entry : this.locatorMap.entrySet()) {
                if (entry.getValue() == null) continue;
                InternalDistributedMember member = entry.getKey();
                if (gfxdMembers != null && !gfxdMembers.containsKey(member)) continue;
                locators.add((Object)member);
            }
        }
        finally {
            this.mapLock.readLock().unlock();
        }
        return locators;
    }

    public final DistributedMember adviseDataStore(Set<String> groups, boolean preferSelf) {
        return this.adviseSingleVMOfKind(groups, GemFireStore.VMKind.DATASTORE, preferSelf);
    }

    public final DistributedMember adviseAccessor(Set<String> groups, boolean preferSelf) {
        return this.adviseSingleVMOfKind(groups, GemFireStore.VMKind.ACCESSOR, preferSelf);
    }

    public final DistributedMember adviseOperationNode(Set<String> groups, boolean preferSelf) {
        return this.adviseSingleVMOfKind(groups, VMKindToken.SERVER, preferSelf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DistributedMember adviseServerLocator(boolean preferSelf, boolean skipNonGfxd) {
        this.mapLock.readLock().lock();
        try {
            InternalDistributedMember member;
            if (preferSelf && this.locatorMap.get(member = this.myProfile.getDistributedMember()) != null) {
                InternalDistributedMember internalDistributedMember = member;
                return internalDistributedMember;
            }
            Map<InternalDistributedMember, GemFireStore.VMKind> gfxdMembers = null;
            if (skipNonGfxd) {
                gfxdMembers = this.serverGroupMap.get(DEFAULT_GROUP);
            }
            for (Map.Entry<InternalDistributedMember, String> entry : this.locatorMap.entrySet()) {
                if (entry.getValue() == null) continue;
                member = entry.getKey();
                if (gfxdMembers != null && !gfxdMembers.containsKey(member)) continue;
                InternalDistributedMember internalDistributedMember = member;
                return internalDistributedMember;
            }
        }
        finally {
            this.mapLock.readLock().unlock();
        }
        return null;
    }

    public GfxdProfile getProfile(InternalDistributedMember member) {
        DistributionAdvisor.Profile profile = super.getProfile((DistributionAdvisor.ProfileId)member);
        if (profile != null || (profile = this.getMyProfile()).getDistributedMember().equals(member)) {
            return (GfxdProfile)profile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isGroupMember(DistributedMember member, Set<String> groups, boolean isDataStore) {
        block8: {
            this.mapLock.readLock().lock();
            try {
                if (groups == null || groups.size() == 0) {
                    GemFireStore.VMKind kind;
                    Map<InternalDistributedMember, GemFireStore.VMKind> groupMembers = this.serverGroupMap.get(DEFAULT_GROUP);
                    if (groupMembers != null && (kind = groupMembers.get(member)) != null) {
                        boolean bl = isDataStore ? kind == GemFireStore.VMKind.DATASTORE : kind != GemFireStore.VMKind.LOCATOR;
                        return bl;
                    }
                    break block8;
                }
                for (String group : groups) {
                    GemFireStore.VMKind kind;
                    Map<InternalDistributedMember, GemFireStore.VMKind> groupMembers = this.serverGroupMap.get(group);
                    if (groupMembers == null || (kind = groupMembers.get(member)) == null) continue;
                    boolean bl = isDataStore ? kind == GemFireStore.VMKind.DATASTORE : kind != GemFireStore.VMKind.LOCATOR;
                    return bl;
                }
            }
            finally {
                this.mapLock.readLock().unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getDRDAServers(DistributedMember member) {
        this.mapLock.readLock().lock();
        try {
            Set<Object> networkServers;
            InternalDistributedMember myId = this.getDistributionManager().getDistributionManagerId();
            if (myId.equals((Object)member)) {
                networkServers = new TreeSet();
                FabricService service = FabricServiceManager.currentFabricServiceInstance();
                if (service != null) {
                    for (NetworkInterface ni : service.getAllNetworkServers()) {
                        if (!ni.getServerType().isDRDA()) continue;
                        networkServers.add(ni.asString());
                    }
                }
            } else {
                networkServers = this.drdaServerMap.get(member);
            }
            String string = SharedUtils.toCSV(networkServers);
            return string;
        }
        finally {
            this.mapLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getServerLocator(DistributedMember member) {
        this.mapLock.readLock().lock();
        try {
            String string = this.locatorMap.get(member);
            return string;
        }
        finally {
            this.mapLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getAllThriftServers(Set<ServerType> serverTypes, Collection<HostAddress> outHosts) {
        THashSet thriftHosts = new THashSet();
        this.mapLock.readLock().lock();
        try {
            FabricService service = FabricServiceManager.currentFabricServiceInstance();
            if (service != null) {
                List<NetworkInterface> ifaces = service.getAllNetworkServers();
                for (NetworkInterface networkInterface : ifaces) {
                    ServerType serverType = networkInterface.getServerType();
                    if (serverTypes == null ? !serverType.isThrift() : !serverTypes.contains(serverType)) continue;
                    thriftHosts.add((Object)ThriftUtils.getHostAddress((String)networkInterface.getHostName(), (int)networkInterface.getPort()).setServerType(serverType));
                }
            }
            for (Set<HostAddress> hostAddrs : this.thriftServers.values()) {
                if (serverTypes == null) {
                    thriftHosts.addAll(hostAddrs);
                    continue;
                }
                for (HostAddress hostAddress : hostAddrs) {
                    if (!serverTypes.contains(hostAddress.getServerType())) continue;
                    thriftHosts.add((Object)hostAddress);
                }
            }
            FilterThriftHosts filter = new FilterThriftHosts(outHosts);
            filter.setKeepLocators(true);
            filter.setKeepServers(false);
            thriftHosts.forEach((TObjectProcedure)filter);
            filter.setKeepLocators(false);
            filter.setKeepServers(true);
            thriftHosts.forEach((TObjectProcedure)filter);
            if (SanityManager.TraceClientHA) {
                THashSet allHosts = new THashSet(thriftHosts.size());
                for (Set set : this.thriftServers.values()) {
                    allHosts.addAll((Collection)set);
                }
                SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("getAllThriftServers(): with types=" + serverTypes + ": returning hosts: " + thriftHosts + " from all hosts: " + allHosts));
            }
        }
        finally {
            this.mapLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<InternalDistributedMember, Set<HostAddress>> getAllThriftServers() {
        THashMap servers = new THashMap();
        this.mapLock.readLock().lock();
        try {
            FabricService service = FabricServiceManager.currentFabricServiceInstance();
            if (service != null) {
                List<NetworkInterface> ifaces = service.getAllNetworkServers();
                THashSet thriftServers = new THashSet(ifaces.size());
                for (NetworkInterface ni : ifaces) {
                    ServerType serverType = ni.getServerType();
                    if (!serverType.isThrift()) continue;
                    thriftServers.add(ThriftUtils.getHostAddress((String)ni.getHostName(), (int)ni.getPort()).setServerType(serverType));
                }
                servers.put(this.myProfile.getDistributedMember(), thriftServers);
            }
            servers.putAll(this.thriftServers);
        }
        finally {
            this.mapLock.readLock().unlock();
        }
        return servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getThriftServers(DistributedMember member) {
        this.mapLock.readLock().lock();
        try {
            InternalDistributedMember myId = this.getDistributionManager().getDistributionManagerId();
            TreeSet<String> thriftServers = new TreeSet<String>();
            if (myId.equals((Object)member)) {
                FabricService service = FabricServiceManager.currentFabricServiceInstance();
                if (service != null) {
                    for (NetworkInterface ni : service.getAllNetworkServers()) {
                        if (!ni.getServerType().isThrift()) continue;
                        thriftServers.add(ni.asString());
                    }
                }
            } else {
                Set<HostAddress> hostAddrs = this.thriftServers.get(member);
                if (hostAddrs != null) {
                    for (HostAddress hostAddr : hostAddrs) {
                        thriftServers.add(hostAddr.toString());
                    }
                }
            }
            String string = SharedUtils.toCSV(thriftServers);
            return string;
        }
        finally {
            this.mapLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getAllDRDAServers() {
        StringBuilder allServers = new StringBuilder();
        this.mapLock.readLock().lock();
        try {
            GemFireStore.VMKind kind = this.myProfile.getVMKind();
            FabricService service = FabricServiceManager.currentFabricServiceInstance();
            if (service != null) {
                for (NetworkInterface ni : service.getAllNetworkServers()) {
                    if (!ni.getServerType().isDRDA()) continue;
                    if (allServers.length() > 0) {
                        allServers.append(',');
                    }
                    allServers.append(ni.asString()).append('{').append(kind.toString()).append('}');
                }
            }
            Map<InternalDistributedMember, GemFireStore.VMKind> gfxdMembers = this.serverGroupMap.get(DEFAULT_GROUP);
            for (Map.Entry<InternalDistributedMember, Set<String>> entry : this.drdaServerMap.entrySet()) {
                Set<String> servers = entry.getValue();
                if (servers == null || servers.size() <= 0 || (kind = gfxdMembers.get(entry.getKey())) == null) continue;
                StringBuilder serverSB = kind != GemFireStore.VMKind.LOCATOR ? allServers : new StringBuilder();
                for (String s : servers) {
                    if (serverSB.length() > 0) {
                        serverSB.append(',');
                    }
                    serverSB.append(s).append('{').append(kind.toString()).append('}');
                }
                if (kind != GemFireStore.VMKind.LOCATOR) continue;
                if (allServers.length() > 0) {
                    allServers = serverSB.append(',').append((CharSequence)allServers);
                    continue;
                }
                allServers = serverSB;
            }
        }
        finally {
            this.mapLock.readLock().unlock();
        }
        return allServers.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<InternalDistributedMember, String> getAllDRDAServersAndCorrespondingMemberMapping() {
        HashMap<InternalDistributedMember, String> mbrToNetworkServerMap = new HashMap<InternalDistributedMember, String>();
        StringBuilder serverSB = new StringBuilder();
        this.mapLock.readLock().lock();
        try {
            GemFireStore.VMKind kind = this.myProfile.getVMKind();
            FabricService service = FabricServiceManager.currentFabricServiceInstance();
            if (service != null) {
                for (NetworkInterface ni : service.getAllNetworkServers()) {
                    if (!ni.getServerType().isDRDA()) continue;
                    if (serverSB.length() > 0) {
                        serverSB.append(',');
                    }
                    serverSB.append(ni.asString()).append('{').append(kind.toString()).append('}');
                }
                mbrToNetworkServerMap.put(this.myProfile.getDistributedMember(), serverSB.toString());
            }
            Map<InternalDistributedMember, GemFireStore.VMKind> gfxdMembers = this.serverGroupMap.get(DEFAULT_GROUP);
            for (Map.Entry<InternalDistributedMember, Set<String>> entry : this.drdaServerMap.entrySet()) {
                Set<String> servers = entry.getValue();
                if (servers != null && servers.size() > 0 && (kind = gfxdMembers.get(entry.getKey())) != null && kind != GemFireStore.VMKind.LOCATOR) {
                    serverSB = new StringBuilder();
                    for (String s : servers) {
                        if (serverSB.length() > 0) {
                            serverSB.append(',');
                        }
                        serverSB.append(s).append('{').append(kind.toString()).append('}');
                    }
                }
                mbrToNetworkServerMap.put(entry.getKey(), serverSB.toString());
            }
        }
        finally {
            this.mapLock.readLock().unlock();
        }
        return mbrToNetworkServerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<String> getAllServerLocators(boolean skipNonGfxd) {
        THashSet allLocators = new THashSet();
        this.mapLock.readLock().lock();
        try {
            Map<InternalDistributedMember, GemFireStore.VMKind> gfxdMembers = null;
            if (skipNonGfxd) {
                gfxdMembers = this.serverGroupMap.get(DEFAULT_GROUP);
            }
            for (Map.Entry<InternalDistributedMember, String> entry : this.locatorMap.entrySet()) {
                String locator = entry.getValue();
                if (locator == null || locator.length() <= 0) continue;
                InternalDistributedMember member = entry.getKey();
                if (gfxdMembers != null && !gfxdMembers.containsKey(member)) continue;
                allLocators.add((Object)locator);
            }
        }
        finally {
            this.mapLock.readLock().unlock();
        }
        return allLocators;
    }

    private void addMemberGroups(InternalDistributedMember member, SortedSet<String> groups, GemFireStore.VMKind vmKind) {
        Map<InternalDistributedMember, GemFireStore.VMKind> members;
        if (groups != null && groups.size() > 0) {
            for (String group : groups) {
                members = this.serverGroupMap.get(group);
                if (members == null) {
                    members = new HashMap<InternalDistributedMember, GemFireStore.VMKind>();
                    this.serverGroupMap.put(group, members);
                }
                members.put(member, vmKind);
            }
        }
        if ((members = this.serverGroupMap.get(DEFAULT_GROUP)) == null) {
            members = new HashMap<InternalDistributedMember, GemFireStore.VMKind>();
            this.serverGroupMap.put(DEFAULT_GROUP, members);
        }
        members.put(member, vmKind);
    }

    private boolean addMemberServer(InternalDistributedMember member, Object server, Map<InternalDistributedMember, ?> map, boolean allowMultiple) {
        boolean isAdded = false;
        Map<InternalDistributedMember, ?> serverMap = map;
        if (allowMultiple) {
            Set servers = (Set)serverMap.get(member);
            if (servers == null) {
                servers = new THashSet();
                serverMap.put(member, servers);
                isAdded = true;
            }
            servers.add(server);
        } else {
            serverMap.put(member, server);
        }
        return isAdded;
    }

    private void removeMemberGroups(InternalDistributedMember member) {
        for (Map<InternalDistributedMember, GemFireStore.VMKind> groupMap : this.serverGroupMap.values()) {
            groupMap.remove(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<DistributedMember> adviseVMsOfKind(Set<String> groups, GemFireStore.VMKind kind) {
        THashSet members = new THashSet();
        this.mapLock.readLock().lock();
        try {
            if (groups == null || groups.size() == 0) {
                this.addGroupMembers(DEFAULT_GROUP, kind, members);
            } else {
                for (String group : groups) {
                    this.addGroupMembers(group, kind, members);
                }
            }
        }
        finally {
            this.mapLock.readLock().unlock();
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DistributedMember adviseSingleVMOfKind(Set<String> groups, GemFireStore.VMKind kind, boolean preferSelf) {
        GfxdProfile profile = null;
        if (preferSelf) {
            profile = this.myProfile;
        }
        this.mapLock.readLock().lock();
        try {
            if (groups == null || groups.size() == 0) {
                if (preferSelf && this.checkVMKind(profile.getVMKind(), kind)) {
                    InternalDistributedMember internalDistributedMember = profile.getDistributedMember();
                    return internalDistributedMember;
                }
                InternalDistributedMember internalDistributedMember = this.getSingleGroupMember(DEFAULT_GROUP, kind);
                return internalDistributedMember;
            }
            if (preferSelf && this.checkVMKind(profile.getVMKind(), kind) && ServerGroupUtils.isGroupMember(profile.getServerGroups(), groups)) {
                InternalDistributedMember internalDistributedMember = profile.getDistributedMember();
                return internalDistributedMember;
            }
            for (String group : groups) {
                InternalDistributedMember member = this.getSingleGroupMember(group, kind);
                if (member == null) continue;
                InternalDistributedMember internalDistributedMember = member;
                return internalDistributedMember;
            }
        }
        finally {
            this.mapLock.readLock().unlock();
        }
        return null;
    }

    private void addGroupMembers(String group, GemFireStore.VMKind kind, THashSet members) {
        Map<InternalDistributedMember, GemFireStore.VMKind> groupMembers = this.serverGroupMap.get(group);
        if (groupMembers != null) {
            for (Map.Entry<InternalDistributedMember, GemFireStore.VMKind> entry : groupMembers.entrySet()) {
                GemFireStore.VMKind vmKind = entry.getValue();
                if (!this.checkVMKind(vmKind, kind)) continue;
                members.add((Object)entry.getKey());
            }
        }
    }

    private InternalDistributedMember getSingleGroupMember(String group, GemFireStore.VMKind kind) {
        Map<InternalDistributedMember, GemFireStore.VMKind> groupMembers = this.serverGroupMap.get(group);
        if (groupMembers != null) {
            for (Map.Entry<InternalDistributedMember, GemFireStore.VMKind> entry : groupMembers.entrySet()) {
                GemFireStore.VMKind vmKind = entry.getValue();
                if (!this.checkVMKind(vmKind, kind)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private boolean checkVMKind(GemFireStore.VMKind vmKind, GemFireStore.VMKind expectedKind) {
        if (expectedKind == VMKindToken.SERVER) {
            return vmKind == GemFireStore.VMKind.ACCESSOR || vmKind == GemFireStore.VMKind.DATASTORE;
        }
        if (expectedKind == VMKindToken.ALL) {
            return true;
        }
        return vmKind == expectedKind;
    }

    static final class VMKindToken
    extends GemFireStore.VMKind {
        static final GemFireStore.VMKind SERVER = new VMKindToken("server", 4);
        static final GemFireStore.VMKind ALL = new VMKindToken("all", 5);

        private VMKindToken(String name, int ordinal) {
            super(name, ordinal);
        }
    }

    private final class DummyControllerAdvisee
    implements DistributionAdvisee {
        private final int serialNumber = DistributionAdvisor.createSerialNumber();

        private DummyControllerAdvisee() {
        }

        public DistributionAdvisor.Profile getProfile() {
            ControllerAdvisor.ControllerProfile cp = new ControllerAdvisor.ControllerProfile(GfxdDistributionAdvisor.this.myProfile.getDistributedMember(), GfxdDistributionAdvisor.this.incrementAndGetVersion());
            cp.setHost(GfxdDistributionAdvisor.DEFAULT_GROUP);
            cp.setPort(-1);
            cp.serialNumber = this.serialNumber;
            cp.finishInit();
            return cp;
        }

        public void fillInProfile(DistributionAdvisor.Profile profile) {
        }

        public DistributionAdvisor getDistributionAdvisor() {
            return GfxdDistributionAdvisor.this;
        }

        public String getFullPath() {
            return "SnappyData.DummyCacheDistributionAdvisee";
        }

        public String getName() {
            return this.getFullPath();
        }

        public DistributionAdvisee getParentAdvisee() {
            return null;
        }

        public int getSerialNumber() {
            return this.serialNumber;
        }

        public InternalDistributedSystem getSystem() {
            return GfxdDistributionAdvisor.this.getAdvisee().getSystem();
        }

        public DM getDistributionManager() {
            return this.getSystem().getDistributionManager();
        }

        public CancelCriterion getCancelCriterion() {
            return this.getSystem().getCancelCriterion();
        }
    }

    public static final class GfxdProfile
    extends DistributionAdvisor.Profile
    implements GfxdSerializable {
        private GemFireStore.VMKind vmKind;
        private SortedSet<String> serverGroups;
        private static final byte F_PERSISTDD = 1;
        private static final byte F_HASLOCALE = 2;
        private static final byte F_HAS_SPARK_DRIVERURL = 4;
        private byte flags;
        private boolean initialized = true;
        private String dbLocaleStr;
        private String sparkDriverUrl;

        public GfxdProfile() {
        }

        public GfxdProfile(InternalDistributedMember memberId, int version, String sparkUrl) {
            super(memberId, version);
            this.sparkDriverUrl = sparkUrl;
            boolean hasURL = this.sparkDriverUrl != null && !this.sparkDriverUrl.equals(GfxdDistributionAdvisor.DEFAULT_GROUP);
            this.setHasSparkURL(hasURL);
            this.initFlags();
        }

        private void initFlags() {
            this.flags = (byte)(this.flags | 2);
        }

        public final GemFireStore.VMKind getVMKind() {
            return this.vmKind;
        }

        public final void setVMKind(GemFireStore.VMKind kind) {
            this.vmKind = kind;
        }

        public final SortedSet<String> getServerGroups() {
            return this.serverGroups;
        }

        public final void setServerGroups(SortedSet<String> groups) {
            this.serverGroups = groups;
        }

        public final void setLocale(String l) {
            this.dbLocaleStr = l;
        }

        public final void setPersistentDD(boolean isPersistDD) {
            if (isPersistDD) {
                this.flags = (byte)(this.flags | 1);
            } else if (this.isPersistDD()) {
                this.flags = (byte)(this.flags & 0xFFFFFFFE);
            }
        }

        public final boolean isPersistDD() {
            return (this.flags & 1) != 0;
        }

        public final void setHasSparkURL(boolean hasSparkURL) {
            if (hasSparkURL) {
                this.flags = (byte)(this.flags | 4);
            } else if (this.hasSparkURL()) {
                this.flags = (byte)(this.flags & 0xFFFFFFFB);
            }
        }

        public final boolean hasSparkURL() {
            return (this.flags & 4) != 0;
        }

        public final void setInitialized(boolean initialized) {
            this.initialized = initialized;
        }

        public final boolean getInitialized() {
            return this.initialized;
        }

        public final String getLocale() {
            return this.dbLocaleStr;
        }

        public void processIncoming(DistributionManager dm, String adviseePath, boolean removeProfile, boolean exchangeProfiles, List<DistributionAdvisor.Profile> replyProfiles, LogWriterI18n logger) {
            GemFireStore memStore = GemFireStore.getBootedInstance();
            if (memStore != null) {
                FabricService service;
                GemFireCacheImpl cache;
                if (this.hasSparkURL() && memStore.getMyVMKind() != GemFireStore.VMKind.LOCATOR) {
                    CallbackFactoryProvider.getClusterCallbacks().launchExecutor(this.sparkDriverUrl, this.peerMemberId);
                }
                if ((cache = memStore.getGemFireCache()) != null && cache.updateNodeStatus(this.getDistributedMember(), this.initialized) && logger.fineEnabled()) {
                    logger.fine("GfxdProfile: set the node " + this.getDistributedMember() + " as " + (this.initialized ? GfxdDistributionAdvisor.DEFAULT_GROUP : "un") + "initialized");
                }
                this.handleDistributionAdvisee(memStore.getAdvisee(), removeProfile, exchangeProfiles, replyProfiles);
                if (exchangeProfiles && (service = FabricServiceManager.currentFabricServiceInstance()) != null) {
                    for (NetworkInterface ni : service.getAllNetworkServers()) {
                        replyProfiles.add(((DistributionAdvisee)ni).getProfile());
                    }
                }
            }
        }

        public String getSparkDriverURL() {
            return this.sparkDriverUrl;
        }

        public byte getGfxdID() {
            return 97;
        }

        public int getDSFID() {
            return -20;
        }

        public final void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeByte(this.vmKind.ordinal());
            if (this.serverGroups == null) {
                InternalDataSerializer.writeArrayLength((int)-1, (DataOutput)out);
            } else {
                InternalDataSerializer.writeArrayLength((int)this.serverGroups.size(), (DataOutput)out);
                for (String group : this.serverGroups) {
                    DataSerializer.writeString((String)group, (DataOutput)out);
                }
            }
            Version version = InternalDataSerializer.getVersionForDataStream((DataOutput)out);
            boolean isPre12Version = Version.SQLF_11.compareTo(version) >= 0;
            byte flgs = this.flags;
            if (isPre12Version) {
                flgs = (byte)(flgs & 0xFFFFFFFD);
            }
            out.writeByte(flgs);
            out.writeBoolean(this.initialized);
            if (!isPre12Version) {
                DataSerializer.writeString((String)this.dbLocaleStr, (DataOutput)out);
            }
            if (this.hasSparkURL()) {
                DataSerializer.writeString((String)this.sparkDriverUrl, (DataOutput)out);
            }
        }

        public final void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.vmKind = GemFireStore.VMKind.fromOrdinal(in.readByte());
            int numGroups = InternalDataSerializer.readArrayLength((DataInput)in);
            if (numGroups == -1) {
                this.serverGroups = null;
            } else {
                this.serverGroups = new TreeSet<String>();
                while (numGroups-- > 0) {
                    this.serverGroups.add(DataSerializer.readString((DataInput)in));
                }
            }
            this.flags = in.readByte();
            this.initialized = in.readBoolean();
            if ((this.flags & 2) != 0) {
                this.dbLocaleStr = DataSerializer.readString((DataInput)in);
            }
            this.initFlags();
            if (this.hasSparkURL()) {
                this.sparkDriverUrl = DataSerializer.readString((DataInput)in);
            }
        }

        public final StringBuilder getToStringHeader() {
            return new StringBuilder("GfxdProfile");
        }

        public final void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
            sb.append("; vmKind=").append(this.vmKind);
            sb.append("; serverGroups=").append(this.serverGroups);
            sb.append("; sparkDriverUrl=").append(this.sparkDriverUrl);
            sb.append("; flags=0x").append(Integer.toHexString(this.flags));
            sb.append("; initialized=").append(this.initialized);
            sb.append("; dbLocaleStr=").append(this.dbLocaleStr);
        }
    }

    static final class FilterThriftHosts
    implements TObjectProcedure {
        final Collection<HostAddress> outServers;
        private boolean keepLocators;
        private boolean keepServers;

        FilterThriftHosts(Collection<HostAddress> outServers) {
            this.outServers = outServers;
        }

        public void setKeepLocators(boolean v) {
            this.keepLocators = v;
        }

        public void setKeepServers(boolean v) {
            this.keepServers = v;
        }

        public boolean execute(Object o) {
            HostAddress hostAddr = (HostAddress)o;
            if (this.keepLocators && hostAddr.getServerType().isThriftLocator()) {
                this.outServers.add(hostAddr);
            }
            if (this.keepServers && hostAddr.getServerType().isThriftSnappy()) {
                this.outServers.add(hostAddr);
            }
            return true;
        }
    }
}

