/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.snappy.CallbackFactoryProvider;
import java.util.Properties;

public final class DistributedConnectionCloseExecutorFunction
implements Function,
Declarable {
    public static final String ID = "gfxd-DistributedConnectionCloseExecutorFunction";

    public void init(Properties props) {
    }

    public void execute(FunctionContext fc) {
        long[] connIds = (long[])fc.getArguments();
        GfxdConnectionHolder connHolder = GfxdConnectionHolder.getHolder();
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.beforeConnectionCloseByExecutorFunction(connIds);
        }
        for (long id : connIds) {
            DistributedConnectionCloseExecutorFunction.closeConnection(id, connHolder);
        }
        if (observer != null) {
            observer.afterConnectionCloseByExecutorFunction(connIds);
        }
    }

    public static void closeConnection(long id, GfxdConnectionHolder connHolder) {
        Long connId = id;
        GfxdConnectionWrapper wrapper = connHolder.removeWrapper(connId);
        if (wrapper != null) {
            wrapper.close(true, true);
        }
        if (Misc.getMemStore().isSnappyStore()) {
            CallbackFactoryProvider.getClusterCallbacks().clearSnappyContextForConnection(connId);
        }
    }

    public String getId() {
        return ID;
    }

    public boolean hasResult() {
        return false;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return false;
    }
}

