/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.callbacks.messages;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.CallbackProcedures;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.AbstractGfxdReplayableMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

public class GfxdSetGatewayConflictResolverMessage
extends AbstractGfxdReplayableMessage {
    private static final long serialVersionUID = 2629952440312871140L;
    private String implementation;
    private String initInfoStr;
    static final String CONFLATION_KEY_PREFIX = "__GFXD_INTERNAL_GFXDGATEWAYCONFLICTRESOLVER.";

    public GfxdSetGatewayConflictResolverMessage() {
    }

    public GfxdSetGatewayConflictResolverMessage(String implementation, String initInfo) {
        this.implementation = implementation;
        this.initInfoStr = initInfo;
    }

    @Override
    public void execute() throws StandardException {
        LogWriter logger = Misc.getGemFireCache().getLoggerI18n().convertToLogWriter();
        EmbedConnection conn = null;
        boolean contextSet = false;
        try {
            conn = GemFireXDUtils.getTSSConnection(true, true, false);
            conn.getTR().setupContextStack();
            contextSet = true;
            if (logger.infoEnabled()) {
                logger.info("GfxdSetGatewayConflictResolverMessage: Executing with fields as: " + this.toString());
            }
            CallbackProcedures.addGfxdGatewayConflictResolverLocally(this.implementation, this.initInfoStr);
        }
        catch (Exception ex) {
            if (logger.fineEnabled()) {
                logger.fine("GfxdSetGatewayConflictResolverMessage#execute: exception encountered", (Throwable)ex);
            }
            if (GemFireXDUtils.retryToBeDone(ex)) {
                throw new InternalFunctionInvocationTargetException((Throwable)ex);
            }
            throw new FunctionExecutionException(ex);
        }
        finally {
            if (contextSet) {
                block14: {
                    try {
                        conn.internalCommit();
                    }
                    catch (SQLException ex) {
                        if (!logger.fineEnabled()) break block14;
                        logger.fine("GfxdSetGatewayConflictResolverMessage#execute: exception encountered", (Throwable)ex);
                    }
                }
                conn.getTR().restoreContextStack();
            }
        }
    }

    @Override
    public byte getGfxdID() {
        return 49;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString((String)this.implementation, (DataOutput)out);
        DataSerializer.writeString((String)this.initInfoStr, (DataOutput)out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.implementation = DataSerializer.readString((DataInput)in);
        this.initInfoStr = DataSerializer.readString((DataInput)in);
    }

    @Override
    public void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append("; implementation = ");
        sb.append(this.implementation);
        sb.append("; initInfoStr = ");
        sb.append(this.initInfoStr);
    }

    public boolean shouldBeConflated() {
        return false;
    }

    public String getRegionToConflate() {
        return null;
    }

    public Object getKeyToConflate() {
        return CONFLATION_KEY_PREFIX;
    }

    public Object getValueToConflate() {
        return null;
    }

    @Override
    public String getSQLStatement() {
        StringBuilder sb = new StringBuilder();
        return sb.append("CALL SYS.ATTACH_GATEWAY_CONFLICT_RESOLVER('").append(this.implementation).append("','").append(this.initInfoStr).append("')").toString();
    }
}

