/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.index;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.AbstractRegionEntry;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.cache.locks.ExclusiveSharedLockObject;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexScanController;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdListResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.message.BitSetSet;
import com.pivotal.gemfirexd.internal.engine.distributed.message.ContainsKeyBulkExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Hash1IndexScanController
extends MemIndexScanController {
    protected LocalRegion baseRegion;
    protected transient DataValueDescriptor[] currentKey;
    protected transient RegionKey currentRegionKey;
    protected Iterator<?> gfKeysIterator;
    private Set<Integer> localBucketSet;
    protected Set<RegionKey> regionKeysSet;
    protected DataValueDescriptor[] failedKey = null;
    protected static final int NUM_KEYS_FOR_BULK_CHECKS = 10000;

    @Override
    public int getType() {
        return 1;
    }

    @Override
    protected void initEnumerator() throws StandardException {
        this.baseRegion = this.baseContainer.getRegion();
        this.localBucketSet = null;
        if (GemFireXDUtils.TraceIndex | GemFireXDUtils.TraceQuery) {
            GfxdIndexManager.traceIndex("Hash1IndexScanController: startKey=%s stopKey=%s qualifier=%s for index container %s", new Object[]{this.init_startKeyValue, this.init_stopKeyValue, this.init_qualifier, this.openConglom.getGemFireContainer()});
        }
        if (GemFireXDUtils.TraceIndex && this.init_startKeyValue != null) {
            SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)("Boolean1=" + (this.init_startKeyValue.length == this.openConglom.getConglomerate().keyColumns) + " startKeylength=" + this.init_startKeyValue.length + " indexCols-1=" + this.openConglom.getConglomerate().keyColumns));
            if (this.init_qualifier != null) {
                SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)("Boolean2=" + RowUtil.qualifyRow(this.init_startKeyValue, null, this.init_qualifier, false)));
            }
        }
        if ((this.openMode & 0x400000) != 0) {
            this.hasNext = true;
            if (this.init_startKeyValue == null && this.init_stopKeyValue == null) {
                this.init_scanColumnList = null;
            } else {
                if (this.init_startKeyValue != this.init_stopKeyValue && RowUtil.compare(this.init_startKeyValue, this.init_stopKeyValue) != 0) {
                    this.failScan();
                }
                if (this.baseRegion.getDataPolicy().withPartitioning()) {
                    if (this.regionKeysSet == null) {
                        this.regionKeysSet = new HashSet<RegionKey>();
                    }
                    DataValueDescriptor[] startKeyValueCopy = new DataValueDescriptor[this.init_startKeyValue.length];
                    for (int i = 0; i < this.init_startKeyValue.length; ++i) {
                        startKeyValueCopy[i] = this.init_startKeyValue[i].getClone();
                    }
                    this.regionKeysSet.add(this.getRegionKey(startKeyValueCopy));
                }
            }
        } else if (this.init_startKeyValue != null && this.init_stopKeyValue != null) {
            assert (this.init_startKeyValue.length == this.openConglom.getConglomerate().keyColumns);
            assert (this.baseRegion != null) : "The region should not be null";
            if (this.init_startKeyValue != this.init_stopKeyValue && RowUtil.compare(this.init_startKeyValue, this.init_stopKeyValue) != 0) {
                this.failScan();
            }
            if (this.init_qualifier != null && !RowUtil.qualifyRow(this.init_startKeyValue, null, this.init_qualifier, false)) {
                this.hasNext = false;
                return;
            }
            RegionKey key = this.init_startKeyValue.length == 1 ? GemFireXDUtils.convertIntoGemfireRegionKey(this.init_startKeyValue[0], this.baseContainer, false) : GemFireXDUtils.convertIntoGemfireRegionKey(this.init_startKeyValue, this.baseContainer, false);
            this.currentKey = this.init_startKeyValue;
            if (this.baseRegion.getDataPolicy().withPartitioning()) {
                Set<Integer> bset = this.lcc == null ? null : this.lcc.getBucketIdsForLocalExecution();
                this.localBucketSet = bset != null ? bset : Hash1IndexScanController.getLocalBucketSet(this.baseContainer, this.baseRegion, this.activation, "Hash1IndexScanController");
                if (this.activation != null && this.localBucketSet == null && this.activation.getUseOnlyPrimaryBuckets() && this.baseContainer.isPartitioned()) {
                    this.localBucketSet = ((PartitionedRegion)this.baseRegion).getDataStore().getAllLocalPrimaryBucketIds();
                }
            }
            this.getRowLocation(key);
        } else if (this.init_startKeyValue == null && this.init_stopKeyValue == null) {
            this.gfKeysIterator = this.baseRegion.keySet().iterator();
            this.init_scanColumnList = null;
            this.hasNext = true;
        } else {
            this.failScan();
        }
    }

    @Override
    public boolean delete() throws StandardException {
        return false;
    }

    @Override
    public void fetch(DataValueDescriptor[] destRow) throws StandardException {
        if (this.currentKey == null) {
            this.setCurrentKey();
        }
        if (this.init_scanColumnList == null) {
            int i;
            int len = this.currentKey.length;
            if (len > destRow.length) {
                len = destRow.length;
            }
            for (i = 0; i < len; ++i) {
                if (destRow[i] == null) {
                    destRow[i] = this.currentKey[i].getClone();
                    continue;
                }
                destRow[i].setValue(this.currentKey[i]);
            }
            if (i < destRow.length) {
                destRow[i] = this.currentRowLocation;
            }
        } else {
            int len = destRow.length;
            int i = this.init_scanColumnList.anySetBit();
            while (i > -1 && i < len) {
                if (i == this.currentKey.length) {
                    destRow[i] = this.currentRowLocation;
                } else if (destRow[i] == null) {
                    destRow[i] = this.currentKey[i].getClone();
                } else {
                    destRow[i].setValue(this.currentKey[i]);
                }
                i = this.init_scanColumnList.anySetBit(i);
            }
        }
        this.hasNext = false;
    }

    @Override
    public boolean fetchNext(DataValueDescriptor[] destRow) throws StandardException {
        if (this.gfKeysIterator != null) {
            while (this.gfKeysIterator.hasNext()) {
                this.currentRegionKey = (RegionKey)this.gfKeysIterator.next();
                this.setCurrentKey();
                if (!this.getRowLocation(this.currentRegionKey)) continue;
                this.fetch(destRow);
                if (this.init_qualifier != null) {
                    if (!RowUtil.qualifyRow(destRow, null, this.init_qualifier, true)) continue;
                    return true;
                }
                return true;
            }
        } else {
            if (this.hasNext) {
                this.fetch(destRow);
                this.hasNext = false;
                return true;
            }
            if (this.currentDataRegion != null) {
                this.currentDataRegion = null;
            }
        }
        this.checkCancelInProgress();
        return false;
    }

    @Override
    public boolean next() throws StandardException {
        if (this.currentDataRegion != null) {
            this.currentDataRegion = null;
        }
        if (this.gfKeysIterator != null) {
            while (this.gfKeysIterator.hasNext()) {
                RegionKey key;
                this.currentRegionKey = key = (RegionKey)this.gfKeysIterator.next();
                this.currentKey = null;
                if (!this.getRowLocation(key)) continue;
                return true;
            }
            this.checkCancelInProgress();
            return false;
        }
        if ((this.openMode & 0x400000) != 0) {
            if (this.baseRegion.isEmpty()) {
                this.failedKey = this.init_startKeyValue;
                return false;
            }
            if (!this.baseRegion.getDataPolicy().withPartitioning()) {
                return this.containsKeyForReplicateTable();
            }
            if (this.regionKeysSet.size() < 10000) {
                return true;
            }
            return this.containsKeyForPartitionedTable();
        }
        return this.hasNext;
    }

    public Object[] getRoutingObjectsForKeys(Object[] regionKeysArray) {
        Object[] routingObjects = new Object[regionKeysArray.length];
        GfxdPartitionResolver refResolver = (GfxdPartitionResolver)this.baseRegion.getPartitionAttributes().getPartitionResolver();
        for (int i = 0; i < regionKeysArray.length; ++i) {
            routingObjects[i] = refResolver.getRoutingObject(regionKeysArray[i], null, (Region<?, ?>)this.baseRegion);
        }
        return routingObjects;
    }

    private boolean containsKeyForPartitionedTable() throws StandardException {
        if (this.regionKeysSet == null || this.regionKeysSet.size() == 0) {
            return true;
        }
        try {
            Object[] regionKeysArray = this.regionKeysSet.toArray();
            Object[] routingObjects = this.getRoutingObjectsForKeys(regionKeysArray);
            ContainsKeyBulkExecutorMessage msg = new ContainsKeyBulkExecutorMessage(this.baseRegion, regionKeysArray, routingObjects, this.txState, this.lcc);
            Object result = msg.executeFunction();
            assert (result instanceof GfxdListResultCollector);
            Object resultList = ((GfxdListResultCollector)result).getResult();
            Iterator i$ = ((ArrayList)resultList).iterator();
            while (i$.hasNext()) {
                Object oneResult = i$.next();
                GfxdListResultCollector.ListResultCollectorValue l = (GfxdListResultCollector.ListResultCollectorValue)oneResult;
                GemFireContainer.BulkKeyLookupResult brs = (GemFireContainer.BulkKeyLookupResult)l.resultOfSingleExecution;
                if (brs.exists) continue;
                if (brs.gfKey instanceof DataValueDescriptor[]) {
                    this.failedKey = (DataValueDescriptor[])brs.gfKey;
                } else {
                    if (brs.gfKey instanceof CompactCompositeRegionKey) {
                        ((CompactCompositeRegionKey)brs.gfKey).setRegionContext(this.baseRegion);
                    }
                    this.failedKey = new DataValueDescriptor[((RegionKey)brs.gfKey).nCols()];
                    ((RegionKey)brs.gfKey).getKeyColumns(this.failedKey);
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException sqle) {
            throw Misc.wrapSQLException(sqle, sqle);
        }
        finally {
            this.regionKeysSet.clear();
        }
        return true;
    }

    private boolean containsKeyForReplicateTable() throws StandardException {
        boolean ret = this.txState != null ? this.baseRegion.txContainsKey((Object)this.getRegionKey(this.init_startKeyValue), null, this.txState, true) : this.baseRegion.containsKey((Object)this.getRegionKey(this.init_startKeyValue));
        if (!ret) {
            this.failedKey = this.init_startKeyValue;
        }
        return ret;
    }

    public boolean checkAnyAccumulatedKeys() throws StandardException {
        if (this.baseRegion.getDataPolicy().withPartitioning()) {
            return this.containsKeyForPartitionedTable();
        }
        return true;
    }

    public DataValueDescriptor[] getFailedKey() {
        return this.failedKey;
    }

    @Override
    public long getEstimatedRowCount() throws StandardException {
        return 1L;
    }

    protected final void setCurrentKey() {
        if (this.currentKey == null) {
            this.currentKey = new DataValueDescriptor[this.currentRegionKey.nCols()];
        }
        this.currentRegionKey.getKeyColumns(this.currentKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean getRowLocation(Object key) throws StandardException {
        this.currentRowLocation = null;
        this.currentDataRegion = null;
        this.hasNext = false;
        int bucketId = -1;
        try {
            LocalRegion dataRegion;
            DataPolicy policy = this.baseRegion.getDataPolicy();
            if (policy.withPartitioning()) {
                PartitionedRegion pr = (PartitionedRegion)this.baseRegion;
                assert (pr.getLocalMaxMemory() > 0) : "Executing a query in non data store node.";
                if (this.localBucketSet != null && this.localBucketSet.size() == 1) {
                    bucketId = this.localBucketSet instanceof BitSetSet ? ((BitSetSet)this.localBucketSet).nextSetBit(0, 0) : this.localBucketSet.iterator().next().intValue();
                } else {
                    bucketId = PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, (Operation)Operation.GET_ENTRY, (Object)key, null, null);
                    if (this.localBucketSet != null && !this.localBucketSet.contains(bucketId)) {
                        if (GemFireXDUtils.TraceIndex) {
                            GfxdIndexManager.traceIndex("Hash1IndexScanController#getRowLocation: Returning without any row as local bucket set %s does not contain bucketId %s", this.localBucketSet, bucketId);
                        }
                        this.hasNext = false;
                        return this.hasNext;
                    }
                }
                dataRegion = pr.getDataStore().getInitializedBucketForId(key, Integer.valueOf(bucketId));
            } else {
                assert (policy.withStorage()) : "Executing a query on non data store node with policy: " + policy;
                dataRegion = this.baseRegion;
            }
            RegionEntry entry = this.queryHDFS ? dataRegion.entries.getEntry(key) : dataRegion.entries.getOperationalEntryInVM(key);
            if (entry == null) {
                return this.entryNotFound(key);
            }
            if (this.statNumRowsVisited != null) {
                this.statNumRowsVisited[0] = this.statNumRowsVisited[0] + 1;
            }
            RowLocation rl = (RowLocation)entry;
            TXState localTXState = this.localTXState;
            if (this.txState != null) {
                if (localTXState != null && !localTXState.isEmpty()) {
                    rl = (RowLocation)localTXState.getLocalEntry(this.baseRegion, dataRegion, -1, (AbstractRegionEntry)entry);
                    if (rl == null) {
                        ++this.statNumDeletedRowsVisited;
                        return this.entryNotFound(key);
                    }
                    entry = (RegionEntry)rl;
                }
                if (this.readLockMode != null && rl.getTXId() == null) {
                    if (!GemFireXDUtils.lockForRead(localTXState, this.lockPolicy, this.readLockMode, this.forUpdate, entry, this.baseContainer, dataRegion, this.observer)) {
                        ++this.statNumDeletedRowsVisited;
                        return this.entryNotFound(key);
                    }
                    this.localTXState.addReadLockForScan((ExclusiveSharedLockObject)entry, this.readLockMode, dataRegion, this.lockContext);
                    this.currentDataRegion = dataRegion;
                } else if (entry.isDestroyedOrRemoved()) {
                    ++this.statNumDeletedRowsVisited;
                    return this.entryNotFound(key);
                }
            } else if (entry.isDestroyedOrRemoved()) {
                ++this.statNumDeletedRowsVisited;
                return this.entryNotFound(key);
            }
            GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
            if (observer != null) {
                observer.beforeInvokingContainerGetTxRowLocation(rl);
            }
            this.currentRowLocation = rl;
            this.hasNext = true;
            ++this.statNumRowsQualified;
        }
        catch (EntryNotFoundException e) {
            if (GemFireXDUtils.TraceIndex) {
                GfxdIndexManager.traceIndex("Hash1IndexScanController#getRowLocation: entry not found for key=%s in region=%s", this.init_startKeyValue, this.baseRegion.getFullPath());
            }
            this.hasNext = false;
        }
        catch (ForceReattemptException e) {
            this.hasNext = false;
        }
        if (this.hasNext) {
            return true;
        }
        this.checkCancelInProgress();
        return false;
    }

    public static RowLocation fetchRowLocation(Object key, LocalRegion baseRegion) {
        RegionEntry entry;
        LocalRegion regionToWorkOn;
        int bucketId = -1;
        DataPolicy policy = baseRegion.getDataPolicy();
        if (policy.withPartitioning()) {
            PartitionedRegion pr = (PartitionedRegion)baseRegion;
            assert (pr.getLocalMaxMemory() > 0) : "Executing a query in non data store node.";
            bucketId = PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, (Operation)Operation.GET_ENTRY, (Object)key, null, null);
            try {
                regionToWorkOn = pr.getDataStore().getInitializedBucketForId(key, Integer.valueOf(bucketId));
            }
            catch (ForceReattemptException fre) {
                return null;
            }
        } else {
            assert (policy.withStorage()) : "Executing a query on empty data store node with policy: " + policy;
            regionToWorkOn = baseRegion;
        }
        if ((entry = regionToWorkOn.entries.getEntry(key)) != null && !entry.isDestroyedOrRemoved()) {
            return (RowLocation)entry;
        }
        return null;
    }

    protected RegionKey getRegionKey(DataValueDescriptor[] keyArray) throws StandardException {
        int size_1 = keyArray.length - 1;
        if (size_1 == 0) {
            return GemFireXDUtils.convertIntoGemfireRegionKey(keyArray[0], this.baseContainer, false);
        }
        if (keyArray[size_1] instanceof RowLocation) {
            if (size_1 == 1) {
                return GemFireXDUtils.convertIntoGemfireRegionKey(keyArray[0], this.baseContainer, false);
            }
            DataValueDescriptor[] newKeyValue = new DataValueDescriptor[size_1];
            for (int index = 0; index < size_1; ++index) {
                newKeyValue[index] = keyArray[index];
            }
            return GemFireXDUtils.convertIntoGemfireRegionKey(newKeyValue, this.baseContainer, false);
        }
        return GemFireXDUtils.convertIntoGemfireRegionKey(keyArray, this.baseContainer, false);
    }

    private void failScan() {
        GemFireXDUtils.throwAssert("The local hash index does not support this search operation with startKey {" + RowUtil.toString(this.init_startKeyValue) + "} stopKey {" + RowUtil.toString(this.init_stopKeyValue) + '}');
    }

    private boolean entryNotFound(Object key) throws EntryNotFoundException {
        this.currentRowLocation = null;
        this.currentDataRegion = null;
        this.hasNext = false;
        this.checkCancelInProgress();
        return false;
    }

    @Override
    protected void closeScan() {
        this.baseRegion = null;
        this.currentKey = null;
        this.currentRegionKey = null;
        this.currentDataRegion = null;
        this.regionKeysSet = null;
        this.gfKeysIterator = null;
        this.localBucketSet = null;
    }
}

