/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.index;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.internal.cache.CacheMap;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalRowLocation;
import com.pivotal.gemfirexd.internal.engine.access.index.Hash1IndexScanController;
import com.pivotal.gemfirexd.internal.engine.access.operations.GlobalHashIndexDeleteOperation;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import java.io.Serializable;
import java.util.HashSet;

public final class GlobalHashIndexScanController
extends Hash1IndexScanController {
    private RegionKey gfKey;

    @Override
    public int getType() {
        return 2;
    }

    @Override
    protected void initEnumerator() throws StandardException {
        this.observer = GemFireXDQueryObserverHolder.getInstance();
        if (this.baseRegion == null) {
            this.baseRegion = this.openConglom.getGemFireContainer().getRegion();
        }
        assert (this.baseRegion != null && this.baseRegion instanceof PartitionedRegion);
        if (GemFireXDUtils.TraceIndex | GemFireXDUtils.TraceQuery) {
            GfxdIndexManager.traceIndex("GlobalHashIndexScanController: startKey=%s stopKey=%s qualifier=%s for index container %s", new Object[]{this.init_startKeyValue, this.init_stopKeyValue, this.init_qualifier, this.openConglom.getGemFireContainer()});
        }
        if ((this.openMode & 0x400000) != 0) {
            this.hasNext = true;
            if (this.init_startKeyValue == null && this.init_stopKeyValue == null) {
                this.init_scanColumnList = null;
            } else {
                if (this.init_startKeyValue != this.init_stopKeyValue && RowUtil.compare(this.init_startKeyValue, this.init_stopKeyValue) != 0) {
                    this.failScan();
                }
                if (this.baseRegion.getDataPolicy().withPartitioning()) {
                    if (this.regionKeysSet == null) {
                        this.regionKeysSet = new HashSet();
                    }
                    DataValueDescriptor[] startKeyValueCopy = new DataValueDescriptor[this.init_startKeyValue.length];
                    for (int i = 0; i < this.init_startKeyValue.length; ++i) {
                        startKeyValueCopy[i] = this.init_startKeyValue[i].getClone();
                    }
                    this.regionKeysSet.add(this.getRegionKey(startKeyValueCopy));
                }
            }
        } else if (this.init_startKeyValue != null && this.init_stopKeyValue != null && this.init_startKeyValue.length == this.openConglom.getConglomerate().keyColumns) {
            if (this.init_startKeyValue != this.init_stopKeyValue && RowUtil.compare(this.init_startKeyValue, this.init_stopKeyValue) != 0) {
                this.failScan();
            }
            this.currentKey = this.init_startKeyValue;
            this.gfKey = this.openConglom.newGlobalKeyObject(this.init_startKeyValue);
            this.getRowLocation(this.gfKey);
        } else if (this.init_startKeyValue == null && this.init_stopKeyValue == null) {
            this.gfKeysIterator = this.baseRegion.keySet().iterator();
            this.init_scanColumnList = null;
            this.hasNext = true;
        } else {
            this.failScan();
        }
    }

    private void failScan() {
        GemFireXDUtils.throwAssert("The global hash index does not support this search operation with startKey {" + RowUtil.toString(this.init_startKeyValue) + "} stopKey {" + RowUtil.toString(this.init_stopKeyValue) + '}');
    }

    @Override
    public boolean delete() throws StandardException {
        GlobalHashIndexDeleteOperation.doMe(this.openConglom.getTransaction(), this.txState, this.openConglom.getGemFireContainer(), this.gfKey, false);
        return true;
    }

    @Override
    protected void postProcessSearchCondition() throws StandardException {
        if ((this.openMode & 0x400000) == 0) {
            if (this.init_startKeyValue != null && this.containRowLocation(this.init_startKeyValue)) {
                this.init_startKeyValue = this.removeRowLocation(this.init_startKeyValue);
            }
            if (this.init_stopKeyValue != null && this.containRowLocation(this.init_stopKeyValue)) {
                this.init_stopKeyValue = this.removeRowLocation(this.init_stopKeyValue);
            }
        }
    }

    @Override
    protected boolean getRowLocation(Object key) throws StandardException {
        if (GemFireXDUtils.TraceIndex) {
            GfxdIndexManager.traceIndex("%s: getting row location for key=%s", this.toString(), key);
        }
        try {
            CacheMap cache = this.baseContainer.getGlobalIndexCache();
            Object routingObject = null;
            if (cache != null) {
                routingObject = cache.get(key);
            }
            if (routingObject == null) {
                Object value = this.baseRegion.get(key);
                if (GemFireXDUtils.TraceIndex) {
                    GfxdIndexManager.traceIndex("%s: got row location for key=%s: %s", this.toString(), key, value);
                }
                if (this.statNumRowsVisited != null) {
                    this.statNumRowsVisited[0] = this.statNumRowsVisited[0] + 1;
                }
                if (value == null) {
                    this.currentRowLocation = null;
                    this.checkCancelInProgress();
                    this.hasNext = false;
                    ++this.statNumDeletedRowsVisited;
                } else {
                    assert (value instanceof GlobalRowLocation);
                    this.currentRowLocation = (GlobalRowLocation)value;
                    this.hasNext = true;
                    ++this.statNumRowsQualified;
                    if (cache != null) {
                        cache.put(key, value);
                        if (this.observer != null) {
                            this.observer.afterPuttingInCached((Serializable)key, value);
                        }
                    }
                }
            } else {
                if (GemFireXDUtils.TraceIndex) {
                    GfxdIndexManager.traceIndex("%s: got routingObject from cache for key=%s: %s", this.toString(), key, routingObject);
                }
                GlobalRowLocation grl = new GlobalRowLocation(-1, (Integer)routingObject);
                this.currentRowLocation = grl;
                this.hasNext = true;
                GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
                if (observer != null) {
                    observer.beforeReturningCachedVal((Serializable)key, routingObject);
                }
            }
            return this.hasNext;
        }
        catch (GemFireException gfeex) {
            throw Misc.processGemFireException(gfeex, gfeex, "lookup of global index for key " + key, true);
        }
    }

    @Override
    public void fetch(DataValueDescriptor[] destRow) throws StandardException {
        assert (this.hasNext);
        if (this.currentKey == null) {
            this.setCurrentKey();
        }
        if (this.init_scanColumnList == null) {
            int i;
            for (i = 0; i < this.currentKey.length; ++i) {
                if (destRow[i] == null) {
                    destRow[i] = this.currentKey[i].getClone();
                    continue;
                }
                destRow[i].setValue(this.currentKey[i]);
            }
            destRow[i].setValue(this.currentRowLocation);
        } else {
            int i = this.init_scanColumnList.anySetBit();
            while (i > -1) {
                if (i == this.currentKey.length) {
                    destRow[i].setValue(this.currentRowLocation);
                } else if (destRow[i] == null) {
                    destRow[i] = this.currentKey[i].getClone();
                } else {
                    destRow[i].setValue(this.currentKey[i]);
                }
                i = this.init_scanColumnList.anySetBit(i);
            }
        }
        this.hasNext = false;
    }

    @Override
    public Object[] getRoutingObjectsForKeys(Object[] regionKeysArray) {
        Object[] routingObjects = new Object[regionKeysArray.length];
        for (int i = 0; i < regionKeysArray.length; ++i) {
            routingObjects[i] = PartitionedRegionHelper.getHashKey((PartitionedRegion)((PartitionedRegion)this.baseRegion), (Object)regionKeysArray[i]);
        }
        return routingObjects;
    }

    @Override
    protected RegionKey getRegionKey(DataValueDescriptor[] keyArray) throws StandardException {
        int size_1 = keyArray.length - 1;
        if (size_1 == 0) {
            return keyArray[0];
        }
        if (keyArray[size_1] instanceof RowLocation) {
            if (size_1 == 1) {
                return keyArray[0];
            }
            DataValueDescriptor[] newKeyValue = new DataValueDescriptor[size_1];
            for (int index = 0; index < size_1; ++index) {
                newKeyValue[index] = keyArray[index];
            }
            return this.openConglom.newGlobalKeyObject(newKeyValue);
        }
        return this.openConglom.newGlobalKeyObject(keyArray);
    }

    @Override
    protected void closeScan() {
        super.closeScan();
        this.gfKey = null;
    }

    public String toString() {
        return "GlobalHashIndexScanController on " + this.openConglom.getGemFireContainer().toString() + ", forReferencedPK=" + ((this.openMode & 0x400000) != 0);
    }
}

