/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.diag;

import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.ConnectionUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionInfo;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.vti.VTICosting;
import com.pivotal.gemfirexd.internal.vti.VTIEnvironment;
import com.pivotal.gemfirexd.internal.vti.VTITemplate;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class TransactionTable
extends VTITemplate
implements VTICosting {
    private TransactionInfo[] transactionTable;
    boolean initialized;
    int currentRow;
    private boolean wasNull;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("XID", 12, false, 15), EmbedResultSetMetaData.getResultColumnDescriptor("GLOBAL_XID", 12, true, 140), EmbedResultSetMetaData.getResultColumnDescriptor("USERNAME", 12, true, 128), EmbedResultSetMetaData.getResultColumnDescriptor("TYPE", 12, false, 30), EmbedResultSetMetaData.getResultColumnDescriptor("STATUS", 12, false, 8), EmbedResultSetMetaData.getResultColumnDescriptor("FIRST_INSTANT", 12, true, 20), EmbedResultSetMetaData.getResultColumnDescriptor("SQL_TEXT", 12, true, 32672)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    @Override
    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.initialized) {
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            this.transactionTable = lcc.getTransactionExecute().getAccessManager().getTransactionInfo();
            this.initialized = true;
            this.currentRow = -1;
        }
        if (this.transactionTable == null) {
            return false;
        }
        ++this.currentRow;
        while (this.currentRow < this.transactionTable.length) {
            TransactionInfo info = this.transactionTable[this.currentRow];
            if (info != null) {
                return true;
            }
            ++this.currentRow;
        }
        this.transactionTable = null;
        return false;
    }

    @Override
    public void close() {
        this.transactionTable = null;
    }

    @Override
    public String getString(int columnNumber) {
        TransactionInfo info = this.transactionTable[this.currentRow];
        String str = null;
        switch (columnNumber) {
            case 1: {
                str = info.getTransactionIdString();
                break;
            }
            case 2: {
                str = info.getGlobalTransactionIdString();
                break;
            }
            case 3: {
                str = info.getUsernameString();
                break;
            }
            case 4: {
                str = info.getTransactionTypeString();
                break;
            }
            case 5: {
                str = info.getTransactionStatusString();
                break;
            }
            case 6: {
                str = info.getFirstLogInstantString();
                break;
            }
            case 7: {
                str = info.getStatementTextString();
                str = StringUtil.truncate(str, 32672);
                break;
            }
            default: {
                str = null;
            }
        }
        this.wasNull = str == null;
        return str;
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public double getEstimatedRowCount(VTIEnvironment vtiEnvironment) {
        return 10000.0;
    }

    @Override
    public double getEstimatedCostPerInstantiation(VTIEnvironment vtiEnvironment) {
        return 100000.0;
    }

    @Override
    public boolean supportsMultipleInstantiations(VTIEnvironment vtiEnvironment) {
        return false;
    }
}

