/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.callbacks;

import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.pivotal.gemfirexd.callbacks.AsyncEventHelper;
import com.pivotal.gemfirexd.callbacks.AsyncEventListener;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.callbacks.TableMetaData;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.execute.QueryObserverHolder;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.FileInputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLTransientException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DBSynchronizer
implements AsyncEventListener {
    protected String dbUrl;
    protected String userName;
    protected String passwd;
    protected String errorFile;
    protected int numErrorTries = 0;
    protected static final int DEFAULT_ERROR_TRIES = 3;
    protected String transformation;
    protected int keySize;
    protected String driverClass;
    protected Driver driver;
    protected Connection conn;
    private byte isJDBC4Driver = (byte)-1;
    protected static final byte JDBC4DRIVER_UNKNOWN = -1;
    protected static final byte JDBC4DRIVER_FALSE = 0;
    protected static final byte JDBC4DRIVER_TRUE = 1;
    protected volatile boolean shutDown = true;
    protected final AsyncEventHelper helper = AsyncEventHelper.newInstance();
    protected final Logger logger = Logger.getLogger("snappystore");
    protected boolean traceDBSynchronizer = this.helper.traceDBSynchronizer() && this.logger.isLoggable(Level.INFO);
    protected boolean traceDBSynchronizerHA = this.helper.traceDBSynchronizerHA() && this.logger.isLoggable(Level.INFO);
    protected final HashMap<String, PreparedStatement> insertStmntMap = new HashMap();
    protected final HashMap<String, PreparedStatement> updtStmntMap = new HashMap();
    protected final HashMap<String, PreparedStatement> deleteStmntMap = new HashMap();
    protected final HashMap<String, TableMetaData> metadataMap = new HashMap();
    protected final HashMap<String, ResultSetMetaData> pkMetadataMap = new HashMap();
    protected final HashMap<String, PreparedStatement> bulkOpStmntMap = new HashMap();
    protected boolean skipIdentityColumns = true;
    protected static final String DBDRIVER = "driver";
    protected static final String DBURL = "url";
    protected static final String USER = "user";
    protected static final String PASSWORD = "password";
    protected static final String SECRET = "secret";
    protected static final String TRANSFORMATION = "transformation";
    protected static final String KEYSIZE = "keysize";
    protected static final String ERRORFILE = "errorfile";
    protected static final String ERRORTRIES = "errortries";
    protected static final String SKIP_IDENTITY_COLUMNS = "skipIdentityColumns";
    protected static final String Gfxd_DB_SYNCHRONIZER__1 = "DBSynchronizer::processEvents: Exception while fetching prepared statement for event '%s': %s";
    protected static final String Gfxd_DB_SYNCHRONIZER__2 = "DBSynchronizer::processEvents: Unexpected Exception occured while processing Events. The list of unprocessed events is: %s. Attempt will be made to rollback the changes.";
    protected static final String Gfxd_DB_SYNCHRONIZER__3 = "DBSynchronizer::processEvents: Operation failed for event '%s' due to exception: %s";
    protected static final String Gfxd_DB_SYNCHRONIZER__4 = "DBSynchronizer::closeStatements: Exception in closing prepared statement with DML string: %s";
    protected static final String Gfxd_DB_SYNCHRONIZER__5 = "DBSynchronizer::close: Exception in closing SQL Connection: %s";
    protected static final String Gfxd_DB_SYNCHRONIZER__6 = "DBSynchronizer::init: Exception while initializing connection for driver class '%s' and db url = %s";
    protected static final String Gfxd_DB_SYNCHRONIZER__7 = "DBSynchronizer::processEvents: Exception occured while committing '%s' to external DB: %s";
    protected static final String Gfxd_DB_SYNCHRONIZER__8 = "DBSynchronizer::init: Illegal format of init string '%s', expected <driver>,<URL>,...";
    protected static final String Gfxd_DB_SYNCHRONIZER__9 = "DBSynchronizer::init: Exception in loading properties file '%s' for initialization";
    protected static final String Gfxd_DB_SYNCHRONIZER__10 = "DBSynchronizer::init: missing Driver or URL properties in file '%s'";
    protected static final String Gfxd_DB_SYNCHRONIZER__11 = "DBSynchronizer::init: unknown property '%s' in file '%s'";
    protected static final String Gfxd_DB_SYNCHRONIZER__12 = "DBSynchronizer::init: both password and secret properties specified in file '%s'";
    protected static final String Gfxd_DB_SYNCHRONIZER__13 = "DBSynchronizer::init: initialized with URL '%s' using driver class '%s'";
    protected final ConcurrentSkipListMap<ErrorEvent, Object[]> errorTriesMap = new ConcurrentSkipListMap();

    @Override
    public synchronized void close() {
        this.flushErrorEventsToLog();
        this.shutDown = true;
        this.basicClose();
        this.helper.close();
    }

    public final synchronized void basicClose() {
        block3: {
            this.closeStatements(this.insertStmntMap);
            this.closeStatements(this.updtStmntMap);
            this.closeStatements(this.deleteStmntMap);
            this.closeStatements(this.bulkOpStmntMap);
            try {
                if (this.conn != null && !this.conn.isClosed()) {
                    this.conn.close();
                }
            }
            catch (SQLException sqle) {
                if (!this.logger.isLoggable(Level.INFO)) break block3;
                this.helper.logFormat(this.logger, Level.INFO, sqle, Gfxd_DB_SYNCHRONIZER__5, this.conn);
            }
        }
    }

    protected final byte isJDBC4Driver() {
        return this.isJDBC4Driver;
    }

    protected final void setJDBC4Driver(byte status) {
        this.isJDBC4Driver = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeStatements(Map<String, PreparedStatement> psMap) {
        Iterator<Map.Entry<String, PreparedStatement>> itr = psMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, PreparedStatement> entry = itr.next();
            try {
                entry.getValue().close();
            }
            catch (SQLException sqle) {
                if (!this.logger.isLoggable(Level.INFO)) continue;
                this.helper.logFormat(this.logger, Level.INFO, sqle, Gfxd_DB_SYNCHRONIZER__4, entry.getKey());
            }
            finally {
                itr.remove();
            }
        }
    }

    @Override
    public void init(String initParamStr) {
        this.driver = null;
        this.driverClass = null;
        this.dbUrl = null;
        this.userName = null;
        this.passwd = null;
        this.transformation = null;
        this.keySize = 0;
        this.numErrorTries = 0;
        String secret = null;
        if (initParamStr.startsWith("file=")) {
            String propsFile = initParamStr.substring("file=".length());
            FileInputStream fis = null;
            Properties props = new Properties();
            try {
                fis = new FileInputStream(propsFile);
                props.load(fis);
            }
            catch (Exception e) {
                throw this.helper.newRuntimeException(String.format(Gfxd_DB_SYNCHRONIZER__9, propsFile), e);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception exception) {}
            }
            try {
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String key = ((String)entry.getKey()).trim();
                    String value = ((String)entry.getValue()).trim();
                    if (DBDRIVER.equalsIgnoreCase(key)) {
                        this.driverClass = value;
                        continue;
                    }
                    if (DBURL.equalsIgnoreCase(key)) {
                        this.dbUrl = value;
                        continue;
                    }
                    if (USER.equalsIgnoreCase(key)) {
                        this.userName = value;
                        continue;
                    }
                    if (SECRET.equalsIgnoreCase(key)) {
                        secret = value;
                        continue;
                    }
                    if (TRANSFORMATION.equalsIgnoreCase(key)) {
                        this.transformation = value;
                        continue;
                    }
                    if (KEYSIZE.equalsIgnoreCase(key)) {
                        this.keySize = Integer.parseInt(value);
                        continue;
                    }
                    if (PASSWORD.equalsIgnoreCase(key)) {
                        this.passwd = value;
                        continue;
                    }
                    if (ERRORFILE.equalsIgnoreCase(key)) {
                        this.errorFile = value;
                        continue;
                    }
                    if (ERRORTRIES.equalsIgnoreCase(key)) {
                        this.numErrorTries = Integer.parseInt(value);
                        continue;
                    }
                    if (SKIP_IDENTITY_COLUMNS.equalsIgnoreCase(key)) {
                        this.skipIdentityColumns = Boolean.parseBoolean(value);
                        continue;
                    }
                    throw new IllegalArgumentException(String.format(Gfxd_DB_SYNCHRONIZER__11, key, propsFile));
                }
                if (secret != null) {
                    if (this.passwd != null) {
                        throw new IllegalArgumentException(String.format(Gfxd_DB_SYNCHRONIZER__12, propsFile));
                    }
                    AsyncEventHelper.decryptPassword(this.userName, secret, this.transformation, this.keySize);
                    this.passwd = secret;
                } else if (this.passwd != null) {
                    this.passwd = AsyncEventHelper.encryptPassword(this.userName, this.passwd, this.transformation, this.keySize);
                }
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.helper.newRuntimeException(String.format(Gfxd_DB_SYNCHRONIZER__9, propsFile), e);
            }
            if (this.driverClass == null || this.driverClass.length() == 0 || this.dbUrl == null || this.dbUrl.length() == 0) {
                throw new IllegalArgumentException(String.format(Gfxd_DB_SYNCHRONIZER__10, propsFile));
            }
        } else {
            this.inlineInit(initParamStr);
        }
        this.helper.createEventErrorLogger(this.errorFile);
        this.initConnection();
    }

    protected void inlineInit(String initParamStr) {
        this.logger.info("DBSynchronizer::Inline init parameters:" + initParamStr);
        String[] params = initParamStr.split(",");
        if (params.length < 2) {
            throw new IllegalArgumentException(String.format(Gfxd_DB_SYNCHRONIZER__8, initParamStr));
        }
        String password = null;
        String secret = null;
        int paramNo = 1;
        for (String param : params) {
            StringBuilder value;
            if (this.isArgPresent(param = param.trim(), DBDRIVER, value = new StringBuilder())) {
                this.driverClass = value.toString().trim();
            } else if (this.isArgPresent(param, DBURL, value)) {
                this.dbUrl = value.toString().trim();
            } else if (this.isArgPresent(param, "user=", value)) {
                this.userName = value.toString().trim();
            } else if (this.isArgPresent(param, "password=", value)) {
                password = value.toString().trim();
            } else if (this.isArgPresent(param, "transformation=", value)) {
                this.transformation = value.toString();
            } else if (this.isArgPresent(param, "keysize=", value)) {
                this.keySize = Integer.parseInt(value.toString());
            } else if (this.isArgPresent(param, "secret=", value)) {
                secret = value.toString().trim();
            } else if (this.isArgPresent(param, "errorfile=", value)) {
                this.errorFile = value.toString().trim();
            } else if (this.isArgPresent(param, "errortries=", value)) {
                this.numErrorTries = Integer.parseInt(value.toString());
            } else if (this.isArgPresent(param, "skipIdentityColumns=", value)) {
                this.skipIdentityColumns = Boolean.parseBoolean(value.toString());
            } else if (paramNo == 1) {
                this.driverClass = param.trim();
            } else if (paramNo == 2) {
                this.dbUrl = param.trim();
            } else if (paramNo == 3) {
                this.userName = param.trim();
            } else if (paramNo == 4) {
                this.passwd = param.trim();
            }
            ++paramNo;
        }
        try {
            boolean isEncrypted = false;
            try {
                if (secret != null) {
                    this.logger.info("DBSynchronizer::Attempting to decrypt password");
                    AsyncEventHelper.decryptPassword(this.userName, secret, this.transformation, this.keySize);
                    isEncrypted = true;
                }
            }
            catch (Exception e) {
                this.logger.info("DBSynchronizer::Exception decrypting password:" + e.getMessage() + "Provided password was probably not encrypted.");
                isEncrypted = false;
            }
            if (isEncrypted) {
                this.passwd = secret;
            } else if (password != null) {
                this.logger.info("DBSynchronizer::Encrypting the provided password");
                this.passwd = AsyncEventHelper.encryptPassword(this.userName, password, this.transformation, this.keySize);
            } else {
                this.passwd = null;
            }
        }
        catch (Exception e) {
            String maskedPasswdDbUrl = null;
            if (this.dbUrl != null) {
                maskedPasswdDbUrl = DBSynchronizer.maskPassword(this.dbUrl);
            }
            throw this.helper.newRuntimeException(String.format(Gfxd_DB_SYNCHRONIZER__6, this.driverClass, maskedPasswdDbUrl), e);
        }
    }

    protected boolean isArgPresent(String s, String prefix, StringBuilder extracted) {
        if (s.length() > prefix.length() && prefix.equalsIgnoreCase(s.substring(0, prefix.length()))) {
            extracted.append(s.substring(prefix.length()));
            return true;
        }
        return false;
    }

    protected String trimIgnoreCase(String s, String prefix) {
        if (s.length() > prefix.length() && prefix.equalsIgnoreCase(s.substring(0, prefix.length()))) {
            return s.substring(prefix.length());
        }
        return null;
    }

    protected synchronized void initConnection() {
        String maskedPasswordDbUrl = null;
        if (this.dbUrl != null) {
            maskedPasswordDbUrl = DBSynchronizer.maskPassword(this.dbUrl);
        }
        try {
            Class.forName(this.driverClass).newInstance();
            this.driver = DriverManager.getDriver(this.dbUrl);
        }
        catch (Exception e) {
            throw this.helper.newRuntimeException(String.format(Gfxd_DB_SYNCHRONIZER__6, this.driverClass, maskedPasswordDbUrl), e);
        }
        this.instantiateConnection();
        if (this.logger.isLoggable(Level.INFO)) {
            this.helper.logFormat(this.logger, Level.INFO, null, Gfxd_DB_SYNCHRONIZER__13, maskedPasswordDbUrl, this.driverClass);
        }
        this.shutDown = false;
    }

    protected synchronized void instantiateConnection() {
        if (this.driver == null) {
            this.initConnection();
            return;
        }
        String maskedPasswordDbUrl = null;
        try {
            Properties props = new Properties();
            if (this.userName != null) {
                props.put(USER, this.userName);
            }
            if (this.passwd != null) {
                String decPasswd = AsyncEventHelper.decryptPassword(this.userName, this.passwd, this.transformation, this.keySize);
                props.put(PASSWORD, decPasswd);
                decPasswd = null;
            }
            this.conn = this.driver.connect(this.dbUrl, props);
            props.clear();
            try {
                if (this.conn.getTransactionIsolation() < 2 && this.conn.getMetaData().supportsTransactionIsolationLevel(2)) {
                    this.conn.setTransactionIsolation(2);
                    if (this.dbUrl != null) {
                        maskedPasswordDbUrl = DBSynchronizer.maskPassword(this.dbUrl);
                    }
                    this.logger.info("explicitly set the transaction isolation level to READ_COMMITTED for URL: " + maskedPasswordDbUrl);
                }
            }
            catch (SQLException decPasswd) {
                // empty catch block
            }
            this.conn.setAutoCommit(false);
            this.shutDown = false;
        }
        catch (Exception e) {
            if (this.dbUrl != null) {
                maskedPasswordDbUrl = DBSynchronizer.maskPassword(this.dbUrl);
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            throw this.helper.newRuntimeException(String.format(Gfxd_DB_SYNCHRONIZER__6, this.driverClass, maskedPasswordDbUrl), e);
        }
    }

    protected static final String maskPassword(String dbUrl) {
        String maskedPasswordDbUrl = Pattern.compile("(password|passwd|pwd|secret)=[^;]*", 2).matcher(dbUrl).replaceAll("$1=***");
        return maskedPasswordDbUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean processEvents(List<Event> events) {
        boolean completedSucessfully;
        block90: {
            if (this.shutDown) {
                return false;
            }
            QueryObserver observer = QueryObserverHolder.getInstance();
            this.traceDBSynchronizer = this.helper.traceDBSynchronizer() && this.logger.isLoggable(Level.INFO);
            boolean traceDBSynchronizer = this.traceDBSynchronizer;
            this.traceDBSynchronizerHA = this.helper.traceDBSynchronizerHA() && this.logger.isLoggable(Level.INFO);
            boolean traceDBSynchronizerHA = this.traceDBSynchronizerHA;
            completedSucessfully = false;
            String listOfEventsString = null;
            Statement stmt = null;
            PreparedStatement ps = null;
            Statement prevPS = null;
            Object prevEvent = null;
            boolean prevPSHasBatch = false;
            Iterator<Event> itr = events.iterator();
            boolean isPKBased = false;
            boolean prevIsPKBased = false;
            Event event = null;
            Event.Type evType = null;
            String eventString = null;
            String prevEventStr = null;
            try {
                int[] res2;
                SqlExceptionHandler handler;
                while (!(completedSucessfully = !itr.hasNext())) {
                    block87: {
                        event = itr.next();
                        evType = event.getType();
                        if (traceDBSynchronizer || traceDBSynchronizerHA) {
                            eventString = event.toString();
                            if (prevEvent != null) {
                                prevEventStr = prevEvent.toString();
                            }
                        } else {
                            eventString = null;
                            prevEventStr = null;
                        }
                        if (!evType.isBulkOperation()) {
                            isPKBased = true;
                            if (traceDBSynchronizer) {
                                this.logger.info("DBSynchronizer::processEvents :processing PK based event=" + eventString + " Event Type=" + (Object)((Object)evType));
                            }
                            try {
                                switch (evType) {
                                    case AFTER_INSERT: {
                                        ps = this.getExecutableInsertPrepStmntPKBased(event, (PreparedStatement)prevPS);
                                        break block87;
                                    }
                                    case AFTER_UPDATE: {
                                        ps = this.getExecutableUpdatePrepStmntPKBased(event, (PreparedStatement)prevPS);
                                        break block87;
                                    }
                                    case AFTER_DELETE: {
                                        ps = this.getExecutableDeletePrepStmntPKBased(event, (PreparedStatement)prevPS);
                                        break block87;
                                    }
                                    default: {
                                        this.logger.severe("DBSynchronizer::processEvents: unexpected eventType " + (Object)((Object)evType) + " for " + event);
                                        break;
                                    }
                                }
                                continue;
                            }
                            catch (SQLException sqle) {
                                handler = this.handleSQLException(sqle, Gfxd_DB_SYNCHRONIZER__1, null, event, eventString, this.logger, true);
                                if (handler.breakTheLoop()) {
                                    break;
                                }
                                break block87;
                            }
                            catch (RegionDestroyedException rde) {
                                if (!this.logger.isLoggable(Level.INFO)) continue;
                                this.logger.info("DBSynchronizer::processEvents: WBCLEvent " + event + " will  be discarded as the underlying region " + "for the table has been destroyed");
                                continue;
                            }
                        }
                        isPKBased = false;
                        try {
                            ps = this.getExecutablePrepStmntBulkOp(event, (PreparedStatement)prevPS);
                            if (ps == null && stmt == null) {
                                stmt = this.conn.createStatement();
                            }
                        }
                        catch (SQLException sqle) {
                            SqlExceptionHandler handler2 = this.handleSQLException(sqle, Gfxd_DB_SYNCHRONIZER__1, null, event, eventString, this.logger, true);
                            if (handler2.breakTheLoop()) break;
                        }
                        if (traceDBSynchronizer) {
                            this.logger.info("DBSynchronizer::processEvents: processing Bulk DML Event=" + event);
                        }
                    }
                    if (traceDBSynchronizer) {
                        if (eventString == null) {
                            eventString = event.toString();
                        }
                        this.logger.info("DBSynchronizer::processEvents: Statement=" + (ps != null ? ps : stmt) + " for event=" + eventString);
                    }
                    try {
                        block89: {
                            SqlExceptionHandler handler32;
                            if (evType.isBulkInsert()) {
                                block88: {
                                    if (prevPS != null) {
                                        try {
                                            int num;
                                            if (prevPSHasBatch) {
                                                prevPS.addBatch();
                                                if (traceDBSynchronizer || traceDBSynchronizerHA) {
                                                    this.logger.info("DBSynchronizer::processEvents executing batch statement for prepared statement=" + prevPS + " for event=" + prevEventStr);
                                                }
                                                res2 = prevPS.executeBatch();
                                                num = res2.length;
                                                prevPSHasBatch = false;
                                            } else {
                                                num = prevPS.executeUpdate();
                                            }
                                            if (traceDBSynchronizer || traceDBSynchronizerHA) {
                                                this.logger.info("DBSynchronizer::processEvents num rows modified=" + num + " for prepared statement=" + prevPS + " for event=" + prevEventStr);
                                            }
                                            this.helper.removeEventFromFailureMap((Event)prevEvent);
                                            if (observer == null) break block88;
                                            if (prevIsPKBased) {
                                                observer.afterPKBasedDBSynchExecution(prevEvent.getType(), num, prevPS);
                                            } else {
                                                observer.afterBulkOpDBSynchExecution(prevEvent.getType(), num, prevPS, prevEvent.getDMLString());
                                            }
                                        }
                                        catch (SQLException sqle) {
                                            if (prevPSHasBatch) {
                                                try {
                                                    prevPS.clearBatch();
                                                }
                                                catch (SQLException sQLException) {
                                                    // empty catch block
                                                }
                                                prevPSHasBatch = false;
                                            }
                                            if ((handler32 = this.handleSQLException(sqle, Gfxd_DB_SYNCHRONIZER__3, prevPS, (Event)prevEvent, prevEventStr, this.logger, false)).breakTheLoop()) break;
                                        }
                                    }
                                }
                                prevPS = null;
                                prevEvent = null;
                                prevPSHasBatch = false;
                                prevIsPKBased = false;
                                if (traceDBSynchronizer) {
                                    this.logger.info("DBSynchronizer::processEvents executing batch statement for bulk statement=" + ps + " for event=" + eventString);
                                }
                                res2 = ps.executeBatch();
                                int num = res2.length;
                                this.helper.removeEventFromFailureMap(event);
                                if (traceDBSynchronizer || traceDBSynchronizerHA) {
                                    this.logger.info("DBSynchronizer::processEvents total num rows modified=" + num + " for statement=" + (evType.isBulkInsert() ? ps : stmt) + " for event=" + eventString);
                                }
                                if (observer == null) continue;
                                observer.afterBulkOpDBSynchExecution(evType, num, ps, event.getDMLString());
                                continue;
                            }
                            if (prevPS != null && prevPS != ps) {
                                try {
                                    int num;
                                    if (prevPSHasBatch) {
                                        prevPS.addBatch();
                                        if (traceDBSynchronizer) {
                                            this.logger.info("DBSynchronizer::processEvents executing batch statement for prepared statement=" + prevPS + " for event=" + prevEventStr);
                                        }
                                        res2 = prevPS.executeBatch();
                                        num = res2.length;
                                        prevPSHasBatch = false;
                                    } else {
                                        num = prevPS.executeUpdate();
                                    }
                                    if (traceDBSynchronizer || traceDBSynchronizerHA) {
                                        this.logger.info("DBSynchronizer::processEvents total num rows modified=" + num + " for prepared statement=" + prevPS + " for event=" + prevEventStr);
                                    }
                                    this.helper.removeEventFromFailureMap((Event)prevEvent);
                                    if (observer == null) break block89;
                                    if (prevIsPKBased) {
                                        observer.afterPKBasedDBSynchExecution(prevEvent.getType(), num, prevPS);
                                        break block89;
                                    }
                                    observer.afterBulkOpDBSynchExecution(prevEvent.getType(), num, prevPS, prevEvent.getDMLString());
                                }
                                catch (SQLException sqle) {
                                    if (prevPSHasBatch) {
                                        try {
                                            prevPS.clearBatch();
                                        }
                                        catch (SQLException handler32) {
                                            // empty catch block
                                        }
                                        prevPSHasBatch = false;
                                    }
                                    if ((handler32 = this.handleSQLException(sqle, Gfxd_DB_SYNCHRONIZER__3, prevPS, (Event)prevEvent, prevEventStr, this.logger, false)).breakTheLoop()) break;
                                    prevPS = null;
                                    prevEvent = null;
                                    prevPSHasBatch = false;
                                    prevIsPKBased = false;
                                }
                            } else if (prevPS != null && ps != null) {
                                prevPSHasBatch = true;
                                if (traceDBSynchronizer) {
                                    this.logger.info("DBSynchronizer::processEvents added new row as a batch for prepared statement=" + ps + " for event=" + eventString);
                                }
                            }
                        }
                        if (ps == null) {
                            if (traceDBSynchronizer) {
                                this.logger.info("DBSynchronizer::processEvents executing unprepared statement for event=" + eventString);
                            }
                            int n = stmt.executeUpdate(event.getDMLString());
                            if (traceDBSynchronizer || traceDBSynchronizerHA) {
                                this.logger.info("DBSynchronizer::processEvents num rows modified=" + n + " for statement=" + stmt + " for event=" + eventString);
                            }
                            int num = n;
                            this.helper.removeEventFromFailureMap(event);
                            if (observer != null) {
                                observer.afterBulkOpDBSynchExecution(evType, num, stmt, event.getDMLString());
                            }
                        }
                        prevPS = ps;
                        prevEvent = event;
                        prevIsPKBased = isPKBased;
                    }
                    catch (SQLException sqle) {
                        if (prevPS != null && prevPSHasBatch) {
                            try {
                                prevPS.clearBatch();
                            }
                            catch (SQLException n) {
                                // empty catch block
                            }
                        }
                        if (!(handler = this.handleSQLException(sqle, Gfxd_DB_SYNCHRONIZER__3, ps != null ? ps : stmt, event, eventString, this.logger, false)).breakTheLoop()) continue;
                    }
                }
                if (!completedSucessfully) break block90;
                try {
                    int num;
                    block91: {
                        block93: {
                            block92: {
                                if (this.helper.logFineEnabled()) {
                                    if (listOfEventsString == null) {
                                        listOfEventsString = events.toString();
                                    }
                                    this.logger.fine("DBSynchronizer::processEvents: before commit of events=" + listOfEventsString);
                                }
                                if (!prevPSHasBatch) break block92;
                                ps.addBatch();
                                if (traceDBSynchronizer) {
                                    this.logger.info("DBSynchronizer::processEvents executing batch statement for prepared statement=" + ps + " for event=" + eventString);
                                }
                                res2 = ps.executeBatch();
                                num = res2.length;
                                if (event == null) break block91;
                                this.helper.removeEventFromFailureMap(event);
                                if (observer != null) {
                                    if (isPKBased) {
                                        observer.afterPKBasedDBSynchExecution(evType, num, ps);
                                        break block91;
                                    } else {
                                        observer.afterBulkOpDBSynchExecution(evType, num, ps, event.getDMLString());
                                    }
                                }
                                break block91;
                            }
                            if (ps == null || evType.isBulkInsert()) break block93;
                            num = ps.executeUpdate();
                            if (event == null) break block91;
                            this.helper.removeEventFromFailureMap(event);
                            if (observer != null) {
                                if (isPKBased) {
                                    observer.afterPKBasedDBSynchExecution(evType, num, ps);
                                    break block91;
                                } else {
                                    observer.afterBulkOpDBSynchExecution(evType, num, ps, event.getDMLString());
                                }
                            }
                            break block91;
                        }
                        num = 0;
                    }
                    this.helper.removeEventFromFailureMap(event);
                    if ((traceDBSynchronizer || traceDBSynchronizerHA) && ps != null) {
                        this.logger.info("DBSynchronizer::processEvents num rows modified=" + num + " for prepared statement=" + ps + " for event=" + eventString);
                    }
                    this.conn.commit();
                    if (observer != null) {
                        observer.afterCommitDBSynchExecution(events);
                    }
                    if (this.helper.logFineEnabled()) {
                        if (listOfEventsString == null) {
                            listOfEventsString = events.toString();
                        }
                        this.logger.fine("DBSynchronizer::processEvents: committed successfully for events=" + listOfEventsString);
                    }
                }
                catch (SQLException sqle) {
                    if (ps != null && prevPSHasBatch) {
                        try {
                            ps.clearBatch();
                        }
                        catch (SQLException res2) {
                            // empty catch block
                        }
                    }
                    if ((handler = this.handleSQLException(sqle, Gfxd_DB_SYNCHRONIZER__7, ps != null ? ps : stmt, event, eventString, this.logger, true)) != SqlExceptionHandler.IGNORE) {
                        completedSucessfully = false;
                    }
                }
            }
            catch (Exception e) {
                if (this.logger != null && this.logger.isLoggable(Level.SEVERE) && (event == null || !this.helper.skipFailureLogging(event))) {
                    StringBuilder sb = new StringBuilder();
                    if (event != null) {
                        if (eventString == null) {
                            eventString = event.toString();
                        }
                        sb.append("[FAILED: ").append(eventString).append(" ]");
                    }
                    while (itr.hasNext()) {
                        sb.append("[ ").append(itr.next().toString()).append(" ]");
                    }
                    this.helper.logFormat(this.logger, Level.SEVERE, e, Gfxd_DB_SYNCHRONIZER__2, sb.toString());
                }
                SqlExceptionHandler.CLEANUP.execute(this);
                completedSucessfully = false;
            }
        }
        if (completedSucessfully) {
            this.flushErrorEventsToLog();
        }
        if (this.helper.traceExecute()) {
            this.logger.info("DBSynchronizer::processEvents: processed " + events.size() + " events, success=" + completedSucessfully);
        }
        return completedSucessfully;
    }

    private void flushErrorEventsToLog() {
        for (ErrorEvent ee : this.errorTriesMap.keySet()) {
            Object[] tries = this.errorTriesMap.get(ee);
            if (tries == null || tries[1] == null) continue;
            try {
                this.helper.logEventError(ee.ev, (SQLException)tries[1]);
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.WARNING)) continue;
                this.helper.log(this.logger, Level.WARNING, e, e.getMessage());
            }
        }
        this.errorTriesMap.clear();
    }

    @SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    protected PreparedStatement getExecutablePrepStmntBulkOp(Event event, PreparedStatement prevPS) throws SQLException {
        String dmlString = event.getDMLString();
        if (event.hasParameters() || !this.skipIdentityColumns && event.tableHasAutogeneratedColumns()) {
            PreparedStatement ps;
            if (!this.skipIdentityColumns && event.tableHasAutogeneratedColumns() && event.getType().isBulkInsert()) {
                dmlString = AsyncEventHelper.getInsertString(event.getTableName(), event.getResultSetMetaData(), false);
            }
            if ((ps = this.bulkOpStmntMap.get(dmlString)) == null) {
                if (this.traceDBSynchronizer) {
                    this.logger.info("DBSynchronizer::getExecutablePrepStmntBulkOp: preparing '" + dmlString + "' for event: " + event);
                }
                ps = this.conn.prepareStatement(dmlString);
                this.bulkOpStmntMap.put(dmlString, ps);
            }
            this.helper.setParamsInBulkPreparedStatement(event, event.getType(), ps, prevPS, this);
            return ps;
        }
        return null;
    }

    @SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    protected PreparedStatement getExecutableInsertPrepStmntPKBased(Event pkEvent, PreparedStatement prevPS) throws SQLException {
        boolean skipAutoGenCols;
        String tableName = pkEvent.getTableName();
        PreparedStatement ps = this.insertStmntMap.get(tableName);
        TableMetaData tableMetaData = pkEvent.getResultSetMetaData();
        boolean bl = skipAutoGenCols = this.skipIdentityColumns && pkEvent.tableHasAutogeneratedColumns();
        if (ps == null || tableMetaData != this.metadataMap.get(tableName)) {
            String dmlString = AsyncEventHelper.getInsertString(tableName, tableMetaData, skipAutoGenCols);
            if (this.traceDBSynchronizer) {
                this.logger.info("DBSynchronizer::getExecutableInsertPrepStmntPKBased: preparing '" + dmlString + "' for event: " + pkEvent);
            }
            ps = this.conn.prepareStatement(dmlString);
            this.insertStmntMap.put(tableName, ps);
            this.metadataMap.put(tableName, tableMetaData);
        } else if (prevPS == ps) {
            ps.addBatch();
        }
        ResultSet row = pkEvent.getNewRowsAsResultSet();
        int paramIndex = 1;
        for (int colIdx = 1; colIdx <= tableMetaData.getColumnCount(); ++colIdx) {
            if (skipAutoGenCols && tableMetaData.isAutoIncrement(colIdx)) continue;
            this.helper.setColumnInPrepStatement(tableMetaData.getColumnType(colIdx), ps, row, colIdx, paramIndex, this);
            ++paramIndex;
        }
        return ps;
    }

    @SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    protected PreparedStatement getExecutableDeletePrepStmntPKBased(Event pkEvent, PreparedStatement prevPS) throws SQLException {
        String tableName = pkEvent.getTableName();
        PreparedStatement ps = this.deleteStmntMap.get(tableName);
        ResultSet pkResultSet = pkEvent.getPrimaryKeysAsResultSet();
        ResultSetMetaData pkMetaData = pkResultSet.getMetaData();
        if (ps == null || pkMetaData != this.pkMetadataMap.get(tableName)) {
            String dmlString = AsyncEventHelper.getDeleteString(tableName, pkMetaData);
            if (this.traceDBSynchronizer) {
                this.logger.info("DBSynchronizer::getExecutableInsertPrepStmntPKBased: preparing '" + dmlString + "' for event: " + pkEvent);
            }
            ps = this.conn.prepareStatement(dmlString);
            this.deleteStmntMap.put(tableName, ps);
            this.pkMetadataMap.put(tableName, pkMetaData);
        } else if (prevPS == ps) {
            ps.addBatch();
        }
        this.setKeysInPrepStatement(pkResultSet, pkMetaData, ps, 1);
        return ps;
    }

    @SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    protected PreparedStatement getExecutableUpdatePrepStmntPKBased(Event pkEvent, PreparedStatement prevPS) throws SQLException {
        int paramIndex;
        String tableName = pkEvent.getTableName();
        ResultSet updatedRow = pkEvent.getNewRowsAsResultSet();
        TableMetaData updateMetaData = (TableMetaData)updatedRow.getMetaData();
        int numUpdatedCols = updateMetaData.getColumnCount();
        StringBuilder searchKeyBuff = new StringBuilder(tableName);
        for (paramIndex = 1; paramIndex <= numUpdatedCols; ++paramIndex) {
            searchKeyBuff.append('_');
            searchKeyBuff.append(updateMetaData.getTableColumnPosition(paramIndex));
        }
        String searchKey = searchKeyBuff.toString();
        ResultSet pkValues = pkEvent.getPrimaryKeysAsResultSet();
        ResultSetMetaData pkMetaData = pkValues.getMetaData();
        PreparedStatement ps = this.updtStmntMap.get(searchKey);
        if (ps == null || pkMetaData != this.pkMetadataMap.get(tableName)) {
            String dmlString = AsyncEventHelper.getUpdateString(tableName, pkMetaData, updateMetaData);
            if (this.traceDBSynchronizer) {
                this.logger.info("DBSynchronizer::getExecutableInsertPrepStmntPKBased: preparing '" + dmlString + "' for event: " + pkEvent);
            }
            ps = this.conn.prepareStatement(dmlString);
            this.updtStmntMap.put(searchKey, ps);
            this.pkMetadataMap.put(tableName, pkMetaData);
        } else if (prevPS == ps) {
            ps.addBatch();
        }
        for (paramIndex = 1; paramIndex <= numUpdatedCols; ++paramIndex) {
            this.helper.setColumnInPrepStatement(updateMetaData.getColumnType(paramIndex), ps, updatedRow, paramIndex, paramIndex, this);
        }
        this.setKeysInPrepStatement(pkValues, pkMetaData, ps, paramIndex);
        return ps;
    }

    protected void setKeysInPrepStatement(ResultSet pkValues, ResultSetMetaData pkMetaData, PreparedStatement ps, int startIndex) throws SQLException {
        int numKeyCols = pkMetaData.getColumnCount();
        if (this.traceDBSynchronizer) {
            StringBuilder sb = new StringBuilder().append("DBSynchronizer::setKeysInPrepStatement: setting key {");
            for (int col = 1; col <= numKeyCols; ++col) {
                if (col > 1) {
                    sb.append(',');
                }
                sb.append(pkValues.getObject(col));
            }
            sb.append('}');
            this.logger.info(sb.toString());
        }
        int colIndex = 1;
        while (colIndex <= numKeyCols) {
            this.helper.setColumnInPrepStatement(pkMetaData.getColumnType(colIndex), ps, pkValues, colIndex, startIndex, this);
            ++colIndex;
            ++startIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SqlExceptionHandler handleSQLException(SQLException sqle) {
        SqlExceptionHandler handler;
        String sqlState = sqle.getSQLState();
        if (sqlState == null) {
            if (sqle instanceof BatchUpdateException && sqle.getNextException() != null) {
                sqlState = "42Y96";
            } else {
                try {
                    DBSynchronizer dBSynchronizer = this;
                    synchronized (dBSynchronizer) {
                        if (this.conn == null || this.conn.isClosed()) {
                            return SqlExceptionHandler.REFRESH;
                        }
                    }
                }
                catch (Exception e) {
                    return SqlExceptionHandler.REFRESH;
                }
                return this.checkExceptionString(sqle.toString().toLowerCase(), SqlExceptionHandler.REFRESH);
            }
        }
        if ((handler = this.checkExceptionType(sqle)) != null) {
            return handler;
        }
        if (sqlState.startsWith("23") || sqlState.startsWith("25")) {
            return SqlExceptionHandler.IGNORE;
        }
        if (sqlState.startsWith("42") || sqlState.startsWith("22")) {
            return this.numErrorTries > 0 ? SqlExceptionHandler.IGNORE_BREAK_LOOP : SqlExceptionHandler.IGNORE;
        }
        if (sqlState.startsWith("08")) {
            return SqlExceptionHandler.REFRESH;
        }
        if (sqlState.startsWith("40")) {
            return SqlExceptionHandler.IGNORE_BREAK_LOOP;
        }
        if (sqle instanceof BatchUpdateException && sqle.getNextException() != null) {
            return this.handleSQLException(sqle.getNextException());
        }
        try {
            DBSynchronizer dBSynchronizer = this;
            synchronized (dBSynchronizer) {
                if (this.conn == null || this.conn.isClosed()) {
                    return SqlExceptionHandler.REFRESH;
                }
            }
        }
        catch (Exception e) {
            return SqlExceptionHandler.REFRESH;
        }
        return this.checkExceptionString(sqle.toString().toLowerCase(), SqlExceptionHandler.REFRESH);
    }

    protected SqlExceptionHandler checkExceptionType(SQLException sqle) {
        if (sqle != null) {
            if (sqle instanceof SQLNonTransientConnectionException) {
                return SqlExceptionHandler.REFRESH;
            }
            if (sqle instanceof SQLIntegrityConstraintViolationException) {
                return SqlExceptionHandler.IGNORE;
            }
            if (sqle instanceof SQLNonTransientException) {
                return this.numErrorTries > 0 ? SqlExceptionHandler.IGNORE_BREAK_LOOP : SqlExceptionHandler.IGNORE;
            }
            if (sqle instanceof SQLTransientException) {
                return SqlExceptionHandler.IGNORE_BREAK_LOOP;
            }
            if (sqle instanceof BatchUpdateException) {
                return this.checkExceptionType(sqle.getNextException());
            }
        }
        return null;
    }

    protected SqlExceptionHandler checkExceptionString(String message, SqlExceptionHandler defaultHandler) {
        if (message.contains("constraint")) {
            return SqlExceptionHandler.IGNORE;
        }
        if (message.contains("syntax")) {
            return this.numErrorTries > 0 ? SqlExceptionHandler.IGNORE_BREAK_LOOP : SqlExceptionHandler.IGNORE;
        }
        if (message.contains("connect")) {
            return SqlExceptionHandler.REFRESH;
        }
        return defaultHandler;
    }

    protected SqlExceptionHandler handleSQLException(SQLException sqle, String format, Statement stmt, Event event, String eventString, Logger logger, boolean logWarning) throws SQLException {
        SqlExceptionHandler handler = this.handleSQLException(sqle);
        if (event != null && this.numErrorTries > 0) {
            ErrorEvent ee = new ErrorEvent();
            ee.ev = event;
            ee.errortime = System.currentTimeMillis();
            Object[] tries = this.errorTriesMap.get(ee);
            if (tries != null) {
                Integer numTries = (Integer)tries[0];
                if (numTries >= this.numErrorTries) {
                    handler = SqlExceptionHandler.IGNORE;
                    logWarning = false;
                }
                tries[0] = numTries + 1;
                tries[1] = sqle;
            } else {
                this.errorTriesMap.put(ee, new Object[]{1, sqle});
            }
        }
        boolean skipLogging = false;
        if (event != null && (logWarning || this.traceDBSynchronizer)) {
            skipLogging = this.helper.skipFailureLogging(event);
            if (eventString == null) {
                eventString = event.toString();
            }
        }
        if (!skipLogging) {
            if (logWarning && logger.isLoggable(Level.WARNING)) {
                this.helper.logFormat(logger, Level.WARNING, sqle, format, eventString, sqle);
                SQLException next = sqle.getNextException();
                if (next != null) {
                    this.helper.logFormat(logger, Level.WARNING, next, format, eventString, sqle.getNextException());
                }
            }
            if (this.traceDBSynchronizer && logger.isLoggable(Level.WARNING)) {
                String stmtStr = stmt != null ? "executing statement=" + stmt : "preparing statement";
                this.helper.log(logger, Level.WARNING, sqle, "DBSynchronizer::processEvents: Exception while " + stmtStr + " for event=" + eventString);
                if (sqle.getNextException() != null) {
                    this.helper.log(logger, Level.WARNING, sqle.getNextException(), "DBSynchronizer::processEvents: next exception");
                }
            }
        }
        handler.execute(this);
        return handler;
    }

    @Override
    public synchronized void start() {
        if (this.shutDown) {
            this.instantiateConnection();
        }
    }

    protected final boolean skipIdentityColumns() {
        return this.skipIdentityColumns;
    }

    protected static enum SqlExceptionHandler {
        IGNORE{

            @Override
            public void execute(DBSynchronizer synchronizer) {
                synchronizer.logger.info("DBSynchronizer::Ignoring error");
            }

            @Override
            public boolean breakTheLoop() {
                return false;
            }
        }
        ,
        IGNORE_BREAK_LOOP{

            @Override
            public boolean breakTheLoop() {
                return true;
            }

            @Override
            public void execute(DBSynchronizer synchronizer) {
            }
        }
        ,
        REFRESH{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(DBSynchronizer synchronizer) {
                DBSynchronizer dBSynchronizer = synchronizer;
                synchronized (dBSynchronizer) {
                    try {
                        if (!synchronizer.conn.isClosed()) {
                            if (synchronizer.helper.logFineEnabled()) {
                                synchronizer.logger.fine("DBSynchronizer::SqlExceptionHandler: before rollback");
                            }
                            synchronizer.conn.rollback();
                            if (synchronizer.helper.logFineEnabled()) {
                                synchronizer.logger.fine("DBSynchronizer::SqlExceptionHandler: after rollback");
                            }
                        }
                    }
                    catch (SQLException sqle) {
                        synchronizer.helper.log(synchronizer.logger, Level.WARNING, sqle, "DBSynchronizer::SqlExceptionHandler: could not successfully rollback");
                    }
                    synchronizer.basicClose();
                    if (!synchronizer.shutDown) {
                        synchronizer.logger.info("DBSynchronizer::Attempting to reconnect to database");
                        synchronizer.instantiateConnection();
                    }
                }
            }
        }
        ,
        CLEANUP{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(DBSynchronizer synchronizer) {
                DBSynchronizer dBSynchronizer = synchronizer;
                synchronized (dBSynchronizer) {
                    try {
                        if (synchronizer.conn != null && !synchronizer.conn.isClosed()) {
                            if (synchronizer.helper.logFineEnabled()) {
                                synchronizer.logger.fine("DBSynchronizer::SqlExceptionHandler: before rollback");
                            }
                            synchronizer.conn.rollback();
                            if (synchronizer.helper.logFineEnabled()) {
                                synchronizer.logger.fine("DBSynchronizer::SqlExceptionHandler: after rollback");
                            }
                        }
                    }
                    catch (SQLException sqle) {
                        synchronizer.helper.log(synchronizer.logger, Level.WARNING, sqle, "DBSynchronizer::SqlExceptionHandler: could not successfully rollback");
                    }
                    synchronizer.basicClose();
                }
            }
        };


        public abstract void execute(DBSynchronizer var1);

        public boolean breakTheLoop() {
            return true;
        }
    }

    private static class ErrorEvent
    implements Comparable {
        Event ev;
        long errortime;

        private ErrorEvent() {
        }

        public int compareTo(Object o) {
            ErrorEvent ee = (ErrorEvent)o;
            if (ee.ev.equals(this.ev)) {
                return 0;
            }
            if (ee.errortime > this.errortime) {
                return -1;
            }
            return 1;
        }
    }
}

