/*
 * Copyright (c) 2010-2015 Pivotal Software, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */

package com.pivotal.gemfirexd.callbacks.impl;

import java.sql.ResultSet;
import com.pivotal.gemfirexd.callbacks.TableMetaData;


/**
 * Represents an event coming from remote site.
 * It has additional information useful for GatewayConflictResolver plugin
 * @author sjigyasu
 *
 */
public interface GatewayEvent {
  /**
   * Type of operation
   */
  public enum GatewayEventType { INSERT, UPDATE, DELETE};

  /**
   * DSID of the origin site of this event 
   * @return DSID
   */
  public int getNewDistributedSystemID();

  /**
   * DSID of the last site that modified the row that
   * this event is attempting to modify.
   * @return DSID
   */
  public int getOldDistributedSystemID();

  /**
   * Timestamp of the row that this event represents 
   * @return Timestemp
   */
  public long getNewTimestamp();

  /**
   * Timestamp of the row that this event is attempting to modify.
   * @return Timestamp
   */
  public long getOldTimestamp();

  /**
   * The DML type that generated this event
   * @return Type
   */
  public GatewayEventType getType();

  /**
   * The row that this event will generate on being applied
   * If the GatewayEventType is GatewayEventType.UPDATE,
   * the row contains only the update columns.
   * @return Row
   */
  public ResultSet getNewRow();

  
  /**
   * Returns indices of columns that will be modified in case of
   * GatewayEventType.UPDATE.
   * @return array of column indices (1-based)
   */
  public int[] getModifiedColumns();
  
  /**
   * The row that this event is attempting to modify
   * @return Row
   */
  public ResultSet getOldRow();

  /**
   * Returns metadata of the row.
   * TODO: Provide custom metadata class
   * @return metadata
   */
  public TableMetaData getTableMetaData();

  /**
   * Schema name of the table 
   * @return schema name
   */
  public String getSchemaName();

  /**
   * Table name
   * @return table name
   */
  public String getTableName();

  /**
   * Returns primary key columns from the event's row
   * @return primary keys
   */
  public ResultSet getPrimaryKeys();

  /**
   * Returns true if this event was generated by a 
   * transactional operation on the origin site
   * @return true if transactional, false otherwise
   */
  public boolean isTransactional();
}
