/*
 * Copyright (c) 2010-2015 Pivotal Software, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */
package swarm;

public class RuntimeEnv {

	private final String name;
	private final String userName;
	private final String buildProperties;
	private final String targets;
	private final String buildPath;
	private final String resultsPath;
	public RuntimeEnv(String name, String userName, String buildProperties,
			String targets, String buildPath, String resultsPath) {
		super();
		this.name = name;
		this.userName = userName;
		this.buildProperties = buildProperties;
		this.targets = targets;
		this.buildPath = buildPath;
		this.resultsPath = resultsPath;
	}
	public String getName() {
		return name;
	}
	public String getUserName() {
		return userName;
	}
	public String getBuildProperties() {
		return buildProperties;
	}
	public String getTargets() {
		return targets;
	}
	public String getBuildPath() {
		return buildPath;
	}
	public String getResultsPath() {
		return resultsPath;
	}
	
	
}
