// Use this include file to create a bridge configuration as per SplitBrainTestSpec 10.3.5.1
// New with quorum partitioning, we will still see host2 as the surviving side
// Note with weighted members, we need a locator on the surviving side (so edge clients can still connect to servers
// host1 has a weight of 23 (2 servers, 1 locator))
// host2 has a weight of 31 (2 servers (1 is the lead member), 2 locators)
// Host1: 2 bridgeServer VMs, each with 2 threads (server VMs, 1 locator)
//        Admin - to monitor SystemMembershipListener and AlertListener events
// Host2: 2 bridgeServer VMs, each with 2 threads and 2 locators
//        (leadMember, client VMs, Coordinator, eligibleCoordinators)
//        Admin - to monitor SystemMembershipListener and AlertListener events
// Host3: 4 client VMs, each with 2 threads
// This includes the INITTASKS to place the Coordinator and leadMembers as expected,
// as well as the drop/restore connection tasks
INCLUDE $JTESTS/hydraconfig/hydraparams1.inc;
INCLUDE $JTESTS/hydraconfig/gemfireprms.inc;

hydra.HostPrms-names          = host1     host2     host3;

hydra.VmPrms-names            = bridgep1  locatorp1 admin1    bridgep2  locatorp2 admin2   edge;
hydra.VmPrms-hostNames        = host1     host1     host1     host2     host2     host2    host3;

hydra.GemFirePrms-names       = bridgep1  locatorp1 admin1    bridgep2  locatorp2 admin2   edge;
hydra.GemFirePrms-hostNames   = host1     host1     host1     host2     host2     host2    host3;

// servers and locators are all in the bridge DS, edges are loners
hydra.GemFirePrms-distributedSystem =  
                                bridgeds  bridgeds  bridgeds  bridgeds  bridgeds  bridgeds loner;

hydra.ClientPrms-names        = bridge1   locator1  admin1    bridge2   locator2   admin2   edgeclient;
hydra.ClientPrms-vmNames      = bridgep1  locatorp1 admin1    bridgep2  locatorp2  admin2   edge;
hydra.ClientPrms-gemfireNames = bridgep1  locatorp1 admin1    bridgep2  locatorp2  admin2   edge;

// Host1 has 2 bridgeServer VMs, each with 2 threads
// Host2 has 2 bridgeServer VMs, each with 2 threads and 2 locators, each with 1 thread
// Host3 hosts 4 client (edge) VMs, each with 2 threads
hydra.ClientPrms-vmQuantities = 2          1        1        2          2        1        4;
hydra.ClientPrms-vmThreads    = 2          1        1        2          1        1        2;

STARTTASK    taskClass   = splitBrain.SplitBrainBB taskMethod = HydraTask_initialize clientNames = bridge1;

//------------------------------------------------------------------------------
// INITIALIZATION WORK (configure locators)
//------------------------------------------------------------------------------

/**
 * Starts the locators and connects them to admin-only distributed systems.
 * Start coordinator first, then other locators
 * Then start the LeadMember, followed by other clients
 */
INITTASK taskClass = splitBrain.SBUtil taskMethod = createLocatorTask
         threadGroups = coordinator;

INITTASK taskClass = splitBrain.SBUtil taskMethod = startAndConnectLocatorTask
         threadGroups = coordinator;

INITTASK taskClass = splitBrain.SBUtil taskMethod = createLocatorTask
         threadGroups = otherLocators;

INITTASK taskClass = splitBrain.SBUtil taskMethod = startAndConnectLocatorTask
         threadGroups = otherLocators;

INITTASK taskClass   = splitBrain.NetworkPartitionTest taskMethod  = HydraTask_initializeBridgeServer
         hydra.ConfigPrms-cacheConfig  = bridge
         hydra.ConfigPrms-regionConfig = bridge
         hydra.ConfigPrms-bridgeConfig = bridge
         hydra.ConfigPrms-diskStoreConfig = disk
         threadGroups = leadMember;

INITTASK taskClass   = splitBrain.NetworkPartitionTest taskMethod  = HydraTask_initializeBridgeServer
         hydra.ConfigPrms-cacheConfig  = bridge
         hydra.ConfigPrms-regionConfig = bridge
         hydra.ConfigPrms-bridgeConfig = bridge
         hydra.ConfigPrms-diskStoreConfig = disk
         threadGroups = bridge1Threads, bridge2Threads;

INITTASK taskClass   = util.AdminHelper taskMethod = HydraTask_initializeAdminDS
         threadGroups = adminDS;

INITTASK taskClass   = splitBrain.NetworkPartitionTest taskMethod  = HydraTask_initializeBridgeClient
         hydra.ConfigPrms-cacheConfig  = edge
         hydra.ConfigPrms-regionConfig = edge
         threadGroups = edgeClients;

TASK     taskClass = splitBrain.SBUtil taskMethod = dropConnection
         maxTimesToRun = 1
         startInterval = 60
         threadGroups = coordinator;

CLOSETASK taskClass = splitBrain.NetworkPartitionTest taskMethod = HydraCloseTask_checkForRegionDestroyedForcedDisconnects
          threadGroups = bridge1Threads, bridge2Threads;

CLOSETASK taskClass = splitBrain.NetworkPartitionTest taskMethod = HydraTask_createSnapshot
          threadGroups = bridge1Threads, bridge2Threads;

CLOSETASK taskClass = splitBrain.NetworkPartitionTest taskMethod = closeCacheAndDisconnectFromDS
          threadGroups = leadMember, bridge1Threads, bridge2Threads;

CLOSETASK taskClass = splitBrain.NetworkPartitionTest taskMethod = HydraEndTask_verifyLosingPartition
          threadGroups = bridge1Threads;

CLOSETASK taskClass = splitBrain.SBUtil taskMethod = restoreConnection
          threadGroups = bridge1Threads;

// Separate out coordinator, must be started first
THREADGROUP coordinator totalThreads = 1 totalVMs = 1 clientNames = locator2;
THREADGROUP otherLocators totalThreads = 1 totalVMs = 1 clientNames = locator2
                          totalThreads = 1 totalVMs = 1 clientNames = locator1;

// Separate out leadMember, must be started first
THREADGROUP leadMember totalThreads = 1 totalVMs = 1 clientNames = bridge2;
THREADGROUP bridge2Threads totalThreads = 3 totalVMs = 2 clientNames = bridge2;
THREADGROUP bridge1Threads totalThreads = 4 totalVMs = 2 clientNames = bridge1;
THREADGROUP adminDS totalThreads = 1 totalVMs = 1 clientNames = admin1
                    totalThreads = 1 totalVMs = 1 clientNames = admin2;

// edge VM threads
THREADGROUP edgeClients totalThreads = 8 totalVMs = 4 clientNames = edgeclient;

// util.AdminVM configuration
util.AdminHelperPrms-systemMembershipListener = splitBrain.SBSystemMembershipListener;
util.AdminHelperPrms-alertListener = splitBrain.SBAlertListener;

// Settings for splitBrain behavior
splitBrain.SplitBrainPrms-losingPartition = host1;
hydra.GemFirePrms-enableNetworkPartitionDetection = true;
hydra.GemFirePrms-disableAutoReconnect = true;
hydra.Prms-manageLocatorAgents = false; // turn off master-managed locators

INCLUDE $JTESTS/util/randomValues.inc;
util.RandomValuesPrms-objectType = byte[];
util.RandomValuesPrms-elementSize = 500;
util.ValueHolderPrms-useExtraObject = true;

util.TestHelperPrms-minTaskGranularitySec = 60;
util.OperationsClientPrms-entryOperations = ONEOF add add getNew getNew update invalidate get destroy putIfAbsent putIfAbsent replace remove FOENO;
util.OperationsClientPrms-upperThreshold = 500;
util.OperationsClientPrms-upperThresholdOperations = ONEOF destroy remove FOENO;
util.OperationsClientPrms-lowerThreshold = 10;
util.OperationsClientPrms-lowerThresholdOperations = ONEOF add getNew putIfAbsent FOENO;

// region, bridge and edge definitions
hydra.CachePrms-names           = bridge                     edge;
hydra.RegionPrms-names          = bridge                     edge;
hydra.RegionPrms-scope          = oneof ack global foeno     local;
hydra.RegionPrms-dataPolicy     = oneof replicate persistent_replicate foeno default;
hydra.RegionPrms-poolName       = none                       brclient;
hydra.RegionPrms-cacheListeners = splitBrain.SBListener;

hydra.BridgePrms-names          = bridge;

hydra.BridgePrms-maxThreads = ONEOF default 16 FOENO; // selector control

// Used only when a persistent data policy is selected
hydra.DiskStorePrms-names = disk;
hydra.DiskStorePrms-queueSize = 0;
hydra.DiskStorePrms-timeInterval = 1000;
hydra.RegionPrms-diskSynchronous = true;

// Pool Config
hydra.PoolPrms-names                  = brclient;
hydra.PoolPrms-readTimeout            = 60000;
hydra.PoolPrms-threadLocalConnections = true;  // see Bug 37157
hydra.PoolPrms-minConnections         = 2;
hydra.PoolPrms-subscriptionEnabled           = true;
hydra.PoolPrms-subscriptionRedundancy   = -1;

// generic test settings
hydra.GemFirePrms-conserveSockets = true;
hydra.GemFirePrms-stopSystemsAfterTest = true;
hydra.Prms-alwaysDoEndTasks = true;

hydra.Prms-totalTaskTimeSec = 300;
hydra.Prms-maxResultWaitSec = 180;
hydra.Prms-haltIfBadResult = true;
hydra.Prms-serialExecution = false;
hydra.Prms-maxClientShutdownWaitSec = 360;
hydra.Prms-finalClientSleepSec = 60;
hydra.Prms-maxEndTaskResultWaitSec = 1800;

