/*
 * Copyright (c) 2010-2015 Pivotal Software, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */
package resman;

import java.util.List;

import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.util.GatewayEventListener;

public class BlockingGListener implements AsyncEventListener, GatewayEventListener {

  
  private volatile boolean draining = false;
  
  
  public void setDraining(boolean b) {
    this.draining = b;
  }
  
  public boolean isDraining() {
    return draining;
  }
  
  @Override
  public boolean processEvents(List events) {
    // TODO Auto-generated method stub
    if(isDraining()) {
      return true;
    } else {
      try {
        Thread.sleep(30000);
      } catch(InterruptedException ie) {
        ie.printStackTrace();
      }
      return false;
    }
  }

  public void close() {
    // TODO Auto-generated method stub

  }

}
