/*
 * Copyright (c) 2010-2015 Pivotal Software, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */

package perffmwk;

import hydra.*;

/**
 *
 * A class used to store keys for performance report generator configuration
 * settings.
 *
 */

public class PerfReportPrms extends BasePrms {

    /**
     *  (String)
     *  Name of the statistics specification file.  Defaults to autogenerated.
     */
    public static Long statisticsSpecification;

    /**
     *  (boolean)
     *  Whether or not to generate a performance report after a test has
     *  completed.  Defaults to true, in which case a formatted summary of
     *  statistics found in the {@link #statisticsSpecification} file is written
     *  to {@link PerfReporter#PERFORMANCE_REPORT_FILE_NAME}.
     */
    public static Long generatePerformanceReport;

    /**
     *  (int)
     *  Number of seconds to wait for a performance report to be complete
     *  before timing out.  Default is 300.
     */
    public static Long maxReportWaitSec;

    /**
     *  (String)
     *  Heap size to use in the performance report generator VM.  Default is
     *  300M.
     */
    public static Long heapSize;

  /**
   * (boolean)
   * Should the generated performance report be "brief"
   */
  public static Long generateBriefReport;

  /**
   *  (boolean)
   *  Whether to use an auto-generated file for stats specification.
   */
  public static Long useAutoGeneratedStatisticsSpecification;
    static {
        setValues( PerfReportPrms.class );
    }

    public static void main( String args[] ) {
        Log.createLogWriter( "prms", "info" );
        dumpKeys();
    }
}
