/*
 * Copyright (c) 2010-2015 Pivotal Software, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */
package hydratest.version.partition;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.partition.PartitionListener;
import com.gemstone.gemfire.cache.partition.PartitionListenerAdapter;

import hydra.Log;
import java.io.Serializable;

public class TestPartitionListener2 implements PartitionListener, Serializable {
  public TestPartitionListener2() {
    Log.getLogWriter().info("Instantiated a TestPartitionListener2");
  }
  public void afterPrimary(int id) {
    Log.getLogWriter().info("TestPartitionListener2 was invoked");
  }
  public void afterRegionCreate(Region region) {
  }

  public void afterBucketRemoved(int bucketId, Iterable<?> keys) {
  }
  
  public void afterBucketCreated(int bucketId, Iterable<?> keys) {
  }
}
