/*
 * Copyright (c) 2010-2015 Pivotal Software, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */
package com.gemstone.gemfire.internal.cache.ha;

import java.util.Map;

import com.gemstone.gemfire.internal.cache.HARegion;

/**
 * Helper class to access the required functions of this package from
 * outside the package.
 * @author Girish Thombare
 */

public class HAHelper
{

  public static String getRegionQueueName(String proxyId)
  {
    return HARegionQueue.createRegionName(proxyId.toString());
  }

  public static HARegionQueue getRegionQueue(HARegion hr)
  {
    return hr.getOwner();
  }

  public static HARegionQueueStats getRegionQueueStats(HARegionQueue hq)
  {
    return hq.getStatistics();
  }
  
  public static Map getDispatchMessageMap(Object mapWrapper)
  {
    return ((MapWrapper)mapWrapper).map;
  }
}
