/*
 * Copyright (c) 2010-2015 Pivotal Software, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */
package com.gemstone.gemfire.cache;

import com.gemstone.gemfire.cache30.BridgeTestCase;

import dunit.SerializableRunnable;

public class ConnectionPoolAutoDUnitTest extends ConnectionPoolDUnitTest {

  public ConnectionPoolAutoDUnitTest(String name) {
    super(name);
  }
  
  public void setUp() throws Exception {
    super.setUp();
    // TODO Auto-generated method stub
    BridgeTestCase.AUTO_LOAD_BALANCE = true;
    invokeInEveryVM(new SerializableRunnable("setupAutoMode") {
      public void run() {
        BridgeTestCase.AUTO_LOAD_BALANCE = true;
      }
    });
  }

  public void tearDown2() throws Exception {
    // TODO Auto-generated method stub
    super.tearDown2();
    BridgeTestCase.AUTO_LOAD_BALANCE  = false;
    invokeInEveryVM(new SerializableRunnable("disableAutoMode") {
      public void run() {
        BridgeTestCase.AUTO_LOAD_BALANCE = false;
      }
    });
  }
  
}
