package s2.adapi.sdk.offerwall.impl;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;

import s2.adapi.sdk.offerwall.S2Log;

public class Utils {

    /**
     * Return if an app given by packageName is installed or not.
     * <queries> tag must be given as belows in AndroidManifest.xml file.
     *      <queries>
     *         <intent>
     *             <action android:name="android.intent.action.MAIN" />
     *             <category android:name="android.intent.category.LAUNCHER" />
     *         </intent>
     *     </queries>
     * @param context Context 객체
     * @param packageName package of the app to be checked
     * @param checkMarket check if the app is installed through the given market
     * @return 설처 여부를 반환
     */
    public static boolean isInstalled(Context context, String packageName, String checkMarket) {
        if (packageName == null || packageName.isEmpty()) {
            return false;
        }

        PackageManager pm = context.getPackageManager();
        try {
            pm.getPackageInfo(packageName, PackageManager.GET_META_DATA);
        }
        catch (Exception e) {
            return false;
        }

        // if checkMarket is not null, then we check the app is installed by the given checkMarket.
        // if checkMarket is '*', then we just check the app is installed from APK directly.
        if (checkMarket != null) {
            String installer = pm.getInstallerPackageName(packageName);
            if (installer == null || installer.isEmpty()) {
                // the app is not installed from any market. (maybe installed from APK.)
                //S2Log.d("## No installer for " + packageName);
                return false;
            }
            else if (checkMarket.equals("*") || checkMarket.equals(installer)) {
                //S2Log.d("## Installer for " + packageName + " : " + installer);
                return true;
            }
            else {
                //S2Log.d("## Installer : " + installer);
                return false;
            }
        }

        return true;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }
}
