package s2.adapi.sdk.offerwall.impl;

import android.content.Context;
import android.content.SharedPreferences;

/**
 * v1.03 (2025.07.24)
 * - webview 가 다시 보여질때 javascript onShow() 를 호출하는 구조를 만듬 (observer pattern)
 * - offerwall 판단 로직에 이벤트 url 종류를 포함시킴
 * - 개인정보 수집 동의 다이알로그 띄우는 기능 및 관련 API 추가
 * v1.04 (2025.07.31)
 * - Android 15 EdgeToEdge 적용 : 하단이 Getsture 방식이면 Edge to Edge, 하단이 버튼 방식이면 Padding 적용
 * v1.05 (2025.08.01)
 * - 개인 정보 수집 동의 다이얼로그를 S2OfferwallView 내에서도 처리함. 거부시 onCloseRequested() 호출함
 * - adid 필수 광고인데 adid 없는 경우 개인정보 설정 화면으로 이동하는 로직 추가
 * v1.06 (2025.08.27
 * - offerwall url : http -> https
 * - placement name URLEncoding() (한글명칭인 경우 대비)
 * v1.07
 * - 라이브러리의 AndroidManifest.xml 파일내에 S2OfferwallActivity 선언 추가함
 * - 주요 메소드에 Javadoc 주석 처리
 */
public class Constants {
    public static boolean IS_DEBUG = true;

    public static final String SDK_VER = "1.07";


    public static final String UTF_8 = "utf-8";

    public static final String INTENT_PLACEMENT_NAME = "placement_nm";

    public static final String INTENT_URL_TO_LOAD = "url_to_load";

    public static final String INTENT_PRESENT_TYPE = "present_type"; // M or P

    public static final String INTENT_PARENT_KEY = "parent_key"; // 2025.07.24

    public static final String EXTRA_PRESENT_POPUP = "P";
    public static final String EXTRA_PRESENT_MAIN = "M";

    public static final String PREF_PUB_USER_NAME = "user_nm";
    public static final String PREF_APP_ID = "app_id";
    public static final String PREF_APPSET_ID = "asid";

    public static final String PREF_CONSENT_YN = "consent_yn";

    public static final String PREF_CONSENT_SKIP = "consent_skip"; // 동의 창 띄울지 말지 설정하기 Y / N(기본값)

    public static SharedPreferences getPreferences(Context context) {
        return context.getSharedPreferences("s2_offerwall", Context.MODE_PRIVATE);
    }
}
