package s2.adapi.sdk.offerwall;

import android.util.Log;

public class S2Log {
    public static final int ERROR = 3;
    public static final int INFO = 2;
    public static final int DEBUG = 1;

    public static final String TAG = "s2api";

    private static int logLevel = INFO;

    public static void setLogLevel(int level) {
        logLevel = level;
    }

    public static void d(String msg) {
        if (logLevel == DEBUG) {
            Log.d(TAG, msg);
        }
    }

    public static void i(String msg) {
        if (logLevel <= INFO) {
            Log.i(TAG, msg);
        }
    }

    public static void e(String msg, Throwable thr) {
        Log.e(TAG, msg, thr);
    }

    public static void e(String msg) {
        Log.e(TAG, msg);
    }
}
