/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.setup.config;

import io.smallrye.metrics.setup.config.PropertyArrayConfiguration;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MetricPercentileConfiguration
extends PropertyArrayConfiguration<Double> {
    private boolean isDisabled = false;
    private static final String CLASS_NAME = MetricPercentileConfiguration.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);

    public MetricPercentileConfiguration(String metricName, Double[] percentileValues) {
        super(metricName, percentileValues);
    }

    public MetricPercentileConfiguration(String metricName, boolean isDisabled) {
        super(metricName, null);
        this.isDisabled = isDisabled;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public static Collection<MetricPercentileConfiguration> parseMetricPercentiles(String input) {
        String[] metricValuePairs;
        ArrayDeque<MetricPercentileConfiguration> metricPercentileConfigCollection = new ArrayDeque<MetricPercentileConfiguration>();
        if (input == null || input.length() == 0) {
            input = "*=";
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            MetricPercentileConfiguration metricPercentileConfiguration;
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            if (keyValueSplit.length == 1) {
                metricPercentileConfiguration = new MetricPercentileConfiguration(metricName, true);
            } else {
                Object[] percentileValues = (Double[])Arrays.asList(keyValueSplit[1].split(",")).stream().map(s -> {
                    if (s.matches("[0][.][0-9]+")) {
                        return Double.parseDouble(s);
                    }
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.logp(Level.FINER, CLASS_NAME, (String)null, "The value \"{0}\" is invalid for the \"{1}\" property. Only values 0.0-1.0 inclusively are accepted.", new Object[]{s, "mp.metrics.distribution.percentiles"});
                    }
                    return null;
                }).filter(d -> d != null && d >= 0.0 && d <= 1.0).toArray(Double[]::new);
                Arrays.sort(percentileValues);
                metricPercentileConfiguration = new MetricPercentileConfiguration(metricName, (Double[])percentileValues);
            }
            metricPercentileConfigCollection.addFirst(metricPercentileConfiguration);
        }
        return metricPercentileConfigCollection;
    }
}

