/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.setup.config;

import io.smallrye.metrics.setup.config.PropertySingleValueConfiguration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HistogramBucketMinConfiguration
extends PropertySingleValueConfiguration<Double> {
    private static final String CLASS_NAME = HistogramBucketMinConfiguration.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);

    public HistogramBucketMinConfiguration(String metricName, Double value) {
        super(metricName, value);
    }

    public static Collection<HistogramBucketMinConfiguration> parse(String input) {
        String[] metricValuePairs;
        ArrayDeque<HistogramBucketMinConfiguration> metricBucketMinMax = new ArrayDeque<HistogramBucketMinConfiguration>();
        if (input == null || input.length() == 0) {
            return null;
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            HistogramBucketMinConfiguration metricBucketConfiguration = null;
            if (keyValueSplit.length != 2) continue;
            if (keyValueSplit[1].matches("[0-9]+[.]*[0-9]*")) {
                Double value = Double.parseDouble(keyValueSplit[1].trim());
                metricBucketConfiguration = new HistogramBucketMinConfiguration(metricName, value);
            } else if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.logp(Level.FINER, CLASS_NAME, (String)null, "The value \"{0}\" is invalid for the \"{1}\" property. Only integer and decimal values are accepted.", new Object[]{keyValueSplit[1], "mp.metrics.distribution.histogram.buckets"});
            }
            if (metricBucketConfiguration == null) continue;
            metricBucketMinMax.addFirst(metricBucketConfiguration);
        }
        return metricBucketMinMax;
    }
}

