/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.legacyapi.interceptors;

import io.smallrye.metrics.SharedMetricRegistries;
import io.smallrye.metrics.SmallRyeMetricsMessages;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIMemberInfoAdapter;
import io.smallrye.metrics.legacyapi.LegacyMetricRegistryAdapter;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Timed;

@Timed
@Interceptor
@Priority(value=1010)
public class TimedInterceptor {
    private MetricRegistry registry;

    @AroundConstruct
    Object timedConstructor(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getConstructor());
    }

    @AroundInvoke
    Object timedMethod(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getMethod());
    }

    @AroundTimeout
    Object timedTimeout(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Member & AnnotatedElement> Object timedCallable(InvocationContext invocationContext, E element) throws Exception {
        Timed timedAnno = ((AnnotatedElement)element).getAnnotation(Timed.class);
        this.registry = timedAnno != null ? SharedMetricRegistries.getOrCreate(timedAnno.scope()) : SharedMetricRegistries.getOrCreate("application");
        Set<MetricID> ids = ((LegacyMetricRegistryAdapter)this.registry).getMemberToMetricMappings().getTimers(new CDIMemberInfoAdapter<AnnotatedElement>().convert(element));
        if (ids == null || ids.isEmpty()) {
            throw SmallRyeMetricsMessages.msg.noMetricMappedForMember(element);
        }
        List contexts = ids.stream().map(metricID -> {
            Timer metric = (Timer)this.registry.getTimers().get(metricID);
            if (metric == null) {
                throw new IllegalStateException("No metric with ID " + metricID + " found in registry");
            }
            return metric;
        }).map(Timer::time).collect(Collectors.toList());
        try {
            Object object = invocationContext.proceed();
            return object;
        }
        finally {
            for (Timer.Context timeContext : contexts) {
                timeContext.stop();
            }
        }
    }
}

