/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.legacyapi;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.smallrye.metrics.SharedMetricRegistries;
import io.smallrye.metrics.legacyapi.MeterHolder;
import io.smallrye.metrics.legacyapi.MetricDescriptor;
import io.smallrye.metrics.legacyapi.MpMetadata;
import io.smallrye.metrics.legacyapi.SnapshotAdapter;
import java.time.Duration;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;

class TimerAdapter
implements Timer,
MeterHolder {
    io.micrometer.core.instrument.Timer globalCompositeTimer;
    io.micrometer.core.instrument.Timer promTimer;
    final MeterRegistry registry;

    TimerAdapter(MeterRegistry registry) {
        this.registry = registry;
    }

    public TimerAdapter register(MpMetadata metadata, MetricDescriptor descriptor, String scope) {
        ThreadLocal<Boolean> threadLocal = SharedMetricRegistries.getThreadLocal(scope);
        threadLocal.set(true);
        if (this.globalCompositeTimer == null || metadata.cleanDirtyMetadata()) {
            HashSet<Tag> tagsSet = new HashSet<Tag>();
            for (Tag t : descriptor.tags()) {
                tagsSet.add(t);
            }
            tagsSet.add(Tag.of((String)"mp_scope", (String)scope));
            this.globalCompositeTimer = io.micrometer.core.instrument.Timer.builder((String)descriptor.name()).description(metadata.getDescription()).tags(tagsSet).publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999}).percentilePrecision(Integer.valueOf(5)).register((MeterRegistry)Metrics.globalRegistry);
            this.promTimer = this.registry.find(descriptor.name()).tags(tagsSet).timer();
            if (this.promTimer == null) {
                this.promTimer = this.globalCompositeTimer;
            }
        }
        threadLocal.set(false);
        return this;
    }

    public void update(long l, TimeUnit timeUnit) {
        this.globalCompositeTimer.record(l, timeUnit);
    }

    public void update(Duration duration) {
        this.globalCompositeTimer.record(duration);
    }

    public <T> T time(Callable<T> callable) throws Exception {
        return (T)this.globalCompositeTimer.wrap(callable).call();
    }

    public void time(Runnable runnable) {
        this.globalCompositeTimer.wrap(runnable).run();
    }

    public SampleAdapter time() {
        return new SampleAdapter(this.globalCompositeTimer, io.micrometer.core.instrument.Timer.start((MeterRegistry)Metrics.globalRegistry));
    }

    public Duration getElapsedTime() {
        return Duration.ofNanos((long)this.promTimer.totalTime(TimeUnit.NANOSECONDS));
    }

    public long getCount() {
        return this.promTimer.count();
    }

    public Snapshot getSnapshot() {
        return new SnapshotAdapter(this.promTimer.takeSnapshot());
    }

    @Override
    public Meter getMeter() {
        return this.globalCompositeTimer;
    }

    public Timer.Sample start() {
        return io.micrometer.core.instrument.Timer.start((MeterRegistry)this.registry);
    }

    public void stop(Timer.Sample sample) {
        sample.stop(this.globalCompositeTimer);
    }

    class SampleAdapter
    implements Timer.Context {
        final io.micrometer.core.instrument.Timer timer;
        final Timer.Sample sample;

        SampleAdapter(io.micrometer.core.instrument.Timer timer, Timer.Sample sample) {
            this.sample = sample;
            this.timer = timer;
        }

        public long stop() {
            return this.sample.stop(this.timer);
        }

        public void close() {
            this.sample.stop(this.timer);
        }
    }
}

