/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.smallrye.metrics.SmallRyeMetricsMessages;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.Locale;
import javax.management.MalformedObjectNameException;
import org.eclipse.microprofile.metrics.MetricID;

public class SmallRyeMetricsMessages_$bundle
implements SmallRyeMetricsMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final SmallRyeMetricsMessages_$bundle INSTANCE = new SmallRyeMetricsMessages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected SmallRyeMetricsMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unknownMetricType$str() {
        return "Unknown metric type";
    }

    @Override
    public final IllegalArgumentException unknownMetricType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownMetricType$str(), new Object[0]));
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String noMetricFoundInRegistry$str() {
        return "SRMET00002: No metric with ID %s found in registry";
    }

    @Override
    public final IllegalStateException noMetricFoundInRegistry(MetricID metricID) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noMetricFoundInRegistry$str(), metricID));
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noMetricMappedForMember$str() {
        return "SRMET00003: No metric mapped for %s";
    }

    @Override
    public final IllegalStateException noMetricMappedForMember(Member member) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noMetricMappedForMember$str(), member));
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToRetrieveParameterName$str() {
        return "SRMET00004: Unable to retrieve name for parameter %s";
    }

    @Override
    public final UnsupportedOperationException unableToRetrieveParameterName(AnnotatedParameter<?> parameter) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unableToRetrieveParameterName$str(), parameter));
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToRetrieveMetricNameForInjectionPoint$str() {
        return "SRMET00005: Unable to retrieve metric name for injection point %s";
    }

    @Override
    public final UnsupportedOperationException unableToRetrieveMetricNameForInjectionPoint(InjectionPoint ip) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unableToRetrieveMetricNameForInjectionPoint$str(), ip));
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noMetricPresent$str() {
        return "SRMET00006: No metric is present";
    }

    @Override
    public final IllegalStateException noMetricPresent() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noMetricPresent$str(), new Object[0]));
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAKeyValuePair$str() {
        return "SRMET00007: Not a valid key=value pair: %s";
    }

    @Override
    public final IllegalArgumentException notAKeyValuePair(String string) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.notAKeyValuePair$str(), string));
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mustNotBeCalled$str() {
        return "SRMET00008: Method must not be called";
    }

    @Override
    public final IllegalStateException mustNotBeCalled() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.mustNotBeCalled$str(), new Object[0]));
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String gaugeWithIdAlreadyExists$str() {
        return "SRMET00009: Gauge with id %s already exists";
    }

    @Override
    public final IllegalArgumentException gaugeWithIdAlreadyExists(MetricID metricID) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.gaugeWithIdAlreadyExists$str(), metricID));
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String metricNameMustNotBeNullOrEmpty$str() {
        return "SRMET00010: Metric name must not be null or empty";
    }

    @Override
    public final IllegalArgumentException metricNameMustNotBeNullOrEmpty() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.metricNameMustNotBeNullOrEmpty$str(), new Object[0]));
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String metricExistsUnderDifferentType$str() {
        return "SRMET00011: Metric %s already exists under a different type (%s)";
    }

    @Override
    public final IllegalStateException metricExistsUnderDifferentType(String name, String existingType) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.metricExistsUnderDifferentType$str(), name, existingType));
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unitDiffersFromPreviousUsage$str() {
        return "SRMET00012: Unit is different from the unit in previous usage (%s)";
    }

    @Override
    public final IllegalStateException unitDiffersFromPreviousUsage(String existingUnit) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unitDiffersFromPreviousUsage$str(), existingUnit));
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String descriptionDiffersFromPreviousUsage$str() {
        return "SRMET00013: Description is different from the description in previous usage";
    }

    @Override
    public final IllegalStateException descriptionDiffersFromPreviousUsage() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.descriptionDiffersFromPreviousUsage$str(), new Object[0]));
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String displayNameDiffersFromPreviousUsage$str() {
        return "SRMET00014: Display name is different from the display name in previous usage";
    }

    @Override
    public final IllegalStateException displayNameDiffersFromPreviousUsage() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.displayNameDiffersFromPreviousUsage$str(), new Object[0]));
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String metricWithNameAlreadyExists$str() {
        return "SRMET00015: A metric with name %s already exists";
    }

    @Override
    public final IllegalStateException metricWithNameAlreadyExists(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.metricWithNameAlreadyExists$str(), name));
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToInferMetricType$str() {
        return "SRMET00016: Unable to infer a metric type";
    }

    @Override
    public final IllegalStateException unableToInferMetricType() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToInferMetricType$str(), new Object[0]));
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownMetricAnnotationType$str() {
        return "SRMET00019: Unknown metric annotation type %s";
    }

    @Override
    public final IllegalArgumentException unknownMetricAnnotationType(Class<?> annotationType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownMetricAnnotationType$str(), annotationType));
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String malformedObjectName$str() {
        return "SRMET00020: Malformed object name";
    }

    @Override
    public final IllegalStateException malformedObjectName(MalformedObjectNameException cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.malformedObjectName$str(), new Object[0]), cause);
        SmallRyeMetricsMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }
}

