/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.smallrye.metrics.SharedMetricRegistries;
import io.smallrye.metrics.exporters.Exporter;
import io.smallrye.metrics.exporters.PrometheusMetricsExporter;
import io.smallrye.metrics.legacyapi.LegacyMetricRegistryAdapter;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.MetricRegistry;

@ApplicationScoped
public class MetricsRequestHandler {
    private static final Map<String, String> corsHeaders = new HashMap<String, String>();
    private static final String TEXT_PLAIN = "text/plain";
    private static final String STAR_STAR = "*/*";
    private static final String SCOPE_PARAM_KEY = "scope";
    private static final String NAME_PARAM_KEY = "name";

    public void handleRequest(String requestPath, String method, Stream<String> acceptHeaders, Map<String, String[]> parameterMap, Responder responder) throws IOException {
        this.handleRequest(requestPath, "/metrics", method, acceptHeaders, parameterMap, responder);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleRequest(String requestPath, String contextRoot, String method, Stream<String> acceptHeaders, Map<String, String[]> parameterMap, Responder responder) throws IOException {
        String output;
        Exporter exporter;
        block19: {
            String[] NameParameters;
            exporter = this.obtainExporter(method, acceptHeaders, responder);
            if (exporter == null) {
                return;
            }
            if (!requestPath.startsWith(contextRoot)) {
                responder.respondWith(500, "The expected context root of metrics is " + contextRoot + ", but a request with a different path was routed to MetricsRequestHandler", Collections.emptyMap());
                return;
            }
            String pathAfterContextRoot = requestPath.substring(contextRoot.length());
            if (pathAfterContextRoot.length() != 0 && !pathAfterContextRoot.equals("/")) {
                responder.respondWith(404, "The expected requests are /metrics, /metric?scope=<scope>, /metric?name=<name> or /metrics?scope=<scope>&name=<name>", Collections.emptyMap());
                return;
            }
            String scope = null;
            String metricName = null;
            String[] scopeParameters = parameterMap.get(SCOPE_PARAM_KEY);
            if (scopeParameters != null && scopeParameters.length != 0) {
                scope = scopeParameters[0];
                if (scopeParameters.length > 0) {
                    // empty if block
                }
                if (!SharedMetricRegistries.doesScopeExist(scope)) {
                    responder.respondWith(404, "Scope " + scope + " not found", Collections.emptyMap());
                    return;
                }
            }
            if ((NameParameters = parameterMap.get(NAME_PARAM_KEY)) != null && NameParameters.length != 0) {
                metricName = NameParameters[0];
                if (NameParameters.length > 0) {
                    // empty if block
                }
            }
            output = null;
            if (scope == null && metricName == null) {
                output = exporter.exportAllScopes();
            } else {
                if (scope != null && metricName == null) {
                    MetricRegistry reg = SharedMetricRegistries.getOrCreate(scope);
                    if (reg instanceof LegacyMetricRegistryAdapter && ((LegacyMetricRegistryAdapter)reg).getPrometheusMeterRegistry().getMeters().size() != 0) {
                        output = exporter.exportOneScope(scope);
                        break block19;
                    } else {
                        responder.respondWith(204, "No data in scope " + scope, Collections.emptyMap());
                        return;
                    }
                }
                if (scope != null && metricName != null) {
                    MetricRegistry registry = SharedMetricRegistries.getOrCreate(scope);
                    if (registry instanceof LegacyMetricRegistryAdapter && ((LegacyMetricRegistryAdapter)registry).getPrometheusMeterRegistry().find(metricName).meters().size() != 0) {
                        output = exporter.exportMetricsByName(scope, metricName);
                        break block19;
                    } else {
                        responder.respondWith(404, "Metric " + metricName + " not found in scope " + scope, Collections.emptyMap());
                        return;
                    }
                }
                if (scope == null && metricName != null) {
                    output = exporter.exportOneMetricAcrossScopes(metricName);
                    if (output == null || output.isEmpty() || output.length() == 0) {
                        responder.respondWith(404, "Metric " + metricName + " not found in any scope  ", Collections.emptyMap());
                        return;
                    }
                } else {
                    responder.respondWith(404, "The expected requests are /metrics, /metric?scope=<scope>, /metric?name=<name> or /metrics?scope=<scope>&name=<name>", Collections.emptyMap());
                    return;
                }
            }
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", exporter.getContentType());
        headers.put("Access-Control-Max-Age", "1209600");
        headers.putAll(corsHeaders);
        responder.respondWith(200, output, headers);
    }

    private Exporter obtainExporter(String method, Stream<String> acceptHeaders, Responder responder) throws IOException {
        if (!method.equals("GET")) {
            responder.respondWith(405, "Only GET method is accepted.", Collections.emptyMap());
            return null;
        }
        if (acceptHeaders == null) {
            return new PrometheusMetricsExporter();
        }
        Optional<String> mt = this.getBestMatchingMediaType(acceptHeaders);
        if (mt.isPresent()) {
            String mediaType = mt.get();
            return new PrometheusMetricsExporter();
        }
        responder.respondWith(406, "Couldn't determine a suitable media type for the given Accept header.", Collections.emptyMap());
        return null;
    }

    Optional<String> getBestMatchingMediaType(Stream<String> acceptHeaders) {
        ArrayList tupleList = new ArrayList();
        acceptHeaders.forEach(h -> {
            String[] headers;
            for (String header : headers = h.split(",")) {
                String[] parts = header.split(";");
                float prio = 1.0f;
                if (parts.length > 1) {
                    for (String x : parts) {
                        if (!x.startsWith("q=")) continue;
                        prio = Float.parseFloat(x.substring(2));
                    }
                }
                WTTuple t = new WTTuple(prio, parts[0]);
                tupleList.add(t);
            }
        });
        WTTuple bestMatchTuple = new WTTuple(-1.0f, null);
        for (WTTuple tuple : tupleList) {
            if (!this.isKnownMediaType(tuple)) continue;
            if (tuple.weight > bestMatchTuple.weight) {
                bestMatchTuple = tuple;
                continue;
            }
            if (tuple.weight != bestMatchTuple.weight || bestMatchTuple.type.equals(TEXT_PLAIN) || !tuple.type.equals(TEXT_PLAIN)) continue;
            bestMatchTuple = tuple;
        }
        if (bestMatchTuple.weight > 0.0f) {
            return bestMatchTuple.type.equals(STAR_STAR) ? Optional.of(TEXT_PLAIN) : Optional.of(bestMatchTuple.type);
        }
        return Optional.empty();
    }

    private boolean isKnownMediaType(WTTuple tuple) {
        return tuple.type.equals(TEXT_PLAIN) || tuple.type.equals(STAR_STAR);
    }

    static {
        corsHeaders.put("Access-Control-Allow-Origin", "*");
        corsHeaders.put("Access-Control-Allow-Headers", "origin, content-type, accept, authorization");
        corsHeaders.put("Access-Control-Allow-Credentials", "true");
        corsHeaders.put("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS, HEAD");
    }

    private static class WTTuple {
        float weight;
        String type;

        WTTuple(float weight, String type) {
            this.weight = weight;
            this.type = type;
        }
    }

    public static interface Responder {
        public void respondWith(int var1, String var2, Map<String, String> var3) throws IOException;
    }
}

