package io.smallrye.metrics;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.management.MalformedObjectNameException;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import java.lang.String;
import org.eclipse.microprofile.metrics.MetricID;
import java.lang.Class;
import java.util.Arrays;
import java.lang.reflect.Member;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;

/**
 * Warning this class consists of generated code.
 */
public class SmallRyeMetricsMessages_$bundle implements SmallRyeMetricsMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected SmallRyeMetricsMessages_$bundle() {}
    public static final SmallRyeMetricsMessages_$bundle INSTANCE = new SmallRyeMetricsMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String unknownMetricType$str() {
        return "Unknown metric type";
    }
    @Override
    public final IllegalArgumentException unknownMetricType() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownMetricType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String noMetricFoundInRegistry$str() {
        return "SRMET00002: No metric with ID %s found in registry";
    }
    @Override
    public final IllegalStateException noMetricFoundInRegistry(final MetricID metricID) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noMetricFoundInRegistry$str(), metricID));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noMetricMappedForMember$str() {
        return "SRMET00003: No metric mapped for %s";
    }
    @Override
    public final IllegalStateException noMetricMappedForMember(final Member member) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noMetricMappedForMember$str(), member));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToRetrieveParameterName$str() {
        return "SRMET00004: Unable to retrieve name for parameter %s";
    }
    @Override
    public final UnsupportedOperationException unableToRetrieveParameterName(final AnnotatedParameter<?> parameter) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unableToRetrieveParameterName$str(), parameter));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToRetrieveMetricNameForInjectionPoint$str() {
        return "SRMET00005: Unable to retrieve metric name for injection point %s";
    }
    @Override
    public final UnsupportedOperationException unableToRetrieveMetricNameForInjectionPoint(final InjectionPoint ip) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unableToRetrieveMetricNameForInjectionPoint$str(), ip));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noMetricPresent$str() {
        return "SRMET00006: No metric is present";
    }
    @Override
    public final IllegalStateException noMetricPresent() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noMetricPresent$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notAKeyValuePair$str() {
        return "SRMET00007: Not a valid key=value pair: %s";
    }
    @Override
    public final IllegalArgumentException notAKeyValuePair(final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notAKeyValuePair$str(), string));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mustNotBeCalled$str() {
        return "SRMET00008: Method must not be called";
    }
    @Override
    public final IllegalStateException mustNotBeCalled() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), mustNotBeCalled$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String gaugeWithIdAlreadyExists$str() {
        return "SRMET00009: Gauge with id %s already exists";
    }
    @Override
    public final IllegalArgumentException gaugeWithIdAlreadyExists(final MetricID metricID) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), gaugeWithIdAlreadyExists$str(), metricID));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String metricNameMustNotBeNullOrEmpty$str() {
        return "SRMET00010: Metric name must not be null or empty";
    }
    @Override
    public final IllegalArgumentException metricNameMustNotBeNullOrEmpty() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), metricNameMustNotBeNullOrEmpty$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String metricExistsUnderDifferentType$str() {
        return "SRMET00011: Metric %s already exists under a different type (%s)";
    }
    @Override
    public final IllegalStateException metricExistsUnderDifferentType(final String name, final String existingType) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), metricExistsUnderDifferentType$str(), name, existingType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unitDiffersFromPreviousUsage$str() {
        return "SRMET00012: Unit is different from the unit in previous usage (%s)";
    }
    @Override
    public final IllegalStateException unitDiffersFromPreviousUsage(final String existingUnit) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unitDiffersFromPreviousUsage$str(), existingUnit));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String descriptionDiffersFromPreviousUsage$str() {
        return "SRMET00013: Description is different from the description in previous usage";
    }
    @Override
    public final IllegalStateException descriptionDiffersFromPreviousUsage() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), descriptionDiffersFromPreviousUsage$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String displayNameDiffersFromPreviousUsage$str() {
        return "SRMET00014: Display name is different from the display name in previous usage";
    }
    @Override
    public final IllegalStateException displayNameDiffersFromPreviousUsage() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), displayNameDiffersFromPreviousUsage$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String metricWithNameAlreadyExists$str() {
        return "SRMET00015: A metric with name %s already exists";
    }
    @Override
    public final IllegalStateException metricWithNameAlreadyExists(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), metricWithNameAlreadyExists$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToInferMetricType$str() {
        return "SRMET00016: Unable to infer a metric type";
    }
    @Override
    public final IllegalStateException unableToInferMetricType() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToInferMetricType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownMetricAnnotationType$str() {
        return "SRMET00019: Unknown metric annotation type %s";
    }
    @Override
    public final IllegalArgumentException unknownMetricAnnotationType(final Class<?> annotationType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownMetricAnnotationType$str(), annotationType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String malformedObjectName$str() {
        return "SRMET00020: Malformed object name";
    }
    @Override
    public final IllegalStateException malformedObjectName(final MalformedObjectNameException cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), malformedObjectName$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
