/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.setup;

import io.smallrye.metrics.OriginAndMetadata;
import io.smallrye.metrics.elementdesc.AnnotationInfo;
import io.smallrye.metrics.elementdesc.BeanInfo;
import io.smallrye.metrics.elementdesc.MemberInfo;
import io.smallrye.metrics.legacyapi.LegacyMetricRegistryAdapter;
import io.smallrye.metrics.legacyapi.TagsUtils;
import io.smallrye.metrics.legacyapi.interceptors.MetricResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Timed;

public class MetricsMetadata {
    private MetricsMetadata() {
    }

    public static List<MetricID> registerMetrics(MetricRegistry registry, MetricResolver resolver, BeanInfo bean, MemberInfo element) {
        MetricResolver.Of<Timed> timed;
        MetricResolver.Of<Counted> counted = resolver.counted(bean, element);
        ArrayList<MetricID> metricIDs = new ArrayList<MetricID>();
        if (counted.isPresent()) {
            AnnotationInfo t = counted.metricAnnotation();
            Metadata metadata = MetricsMetadata.getMetadata(element, counted.metricName(), t.unit(), t.description(), t.displayName(), MetricType.COUNTER);
            Tag[] tags = TagsUtils.parseTagsAsArray(t.tags());
            registry.counter(metadata, tags);
            if (registry instanceof LegacyMetricRegistryAdapter) {
                MetricID metricID = new MetricID(metadata.getName(), MetricsMetadata.appendScopeTags(tags, (LegacyMetricRegistryAdapter)registry));
                metricIDs.add(metricID);
                ((LegacyMetricRegistryAdapter)registry).getMemberToMetricMappings().addMetric(element, metricID, MetricType.COUNTER);
            }
        }
        if ((timed = resolver.timed(bean, element)).isPresent()) {
            AnnotationInfo t = timed.metricAnnotation();
            Metadata metadata = MetricsMetadata.getMetadata(element, timed.metricName(), t.unit(), t.description(), t.displayName(), MetricType.TIMER);
            Tag[] tags = TagsUtils.parseTagsAsArray(t.tags());
            registry.timer(metadata, tags);
            if (registry instanceof LegacyMetricRegistryAdapter) {
                MetricID metricID = new MetricID(metadata.getName(), MetricsMetadata.appendScopeTags(tags, (LegacyMetricRegistryAdapter)registry));
                metricIDs.add(metricID);
                ((LegacyMetricRegistryAdapter)registry).getMemberToMetricMappings().addMetric(element, metricID, MetricType.TIMER);
            }
        }
        return metricIDs;
    }

    public static Metadata getMetadata(Object origin, String name, String unit, String description, String displayName, MetricType type) {
        Metadata metadata = Metadata.builder().withName(name).withType(type).withUnit(unit).withDescription(description).withDisplayName(displayName).build();
        return new OriginAndMetadata(origin, metadata);
    }

    private static Tag[] appendScopeTags(Tag[] tags, LegacyMetricRegistryAdapter adapter) {
        return (Tag[])Stream.concat(Arrays.stream(tags), Arrays.stream(adapter.scopeTagsLegacy())).toArray(Tag[]::new);
    }
}

