/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.legacyapi;

import io.smallrye.metrics.SmallRyeMetricsMessages;
import io.smallrye.metrics.elementdesc.MemberInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricType;

public class MemberToMetricMappings {
    private final Map<MemberInfo, Set<MetricID>> counters = new HashMap<MemberInfo, Set<MetricID>>();
    private final Map<MemberInfo, Set<MetricID>> timers = new HashMap<MemberInfo, Set<MetricID>>();

    public Set<MetricID> getCounters(MemberInfo member) {
        return this.counters.get(member);
    }

    public Set<MetricID> getTimers(MemberInfo member) {
        return this.timers.get(member);
    }

    public void addMetric(MemberInfo member, MetricID metricID, MetricType metricType) {
        switch (metricType) {
            case COUNTER: {
                this.counters.computeIfAbsent(member, id -> new HashSet()).add(metricID);
                break;
            }
            case TIMER: {
                this.timers.computeIfAbsent(member, id -> new HashSet()).add(metricID);
                break;
            }
            default: {
                throw SmallRyeMetricsMessages.msg.unknownMetricType();
            }
        }
    }
}

