/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.legacyapi;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.legacyapi.AnnotatedGaugeAdapter;
import io.smallrye.metrics.legacyapi.CounterAdapter;
import io.smallrye.metrics.legacyapi.GaugeAdapter;
import io.smallrye.metrics.legacyapi.HistogramAdapter;
import io.smallrye.metrics.legacyapi.MemberToMetricMappings;
import io.smallrye.metrics.legacyapi.MeterHolder;
import io.smallrye.metrics.legacyapi.MetricDescriptor;
import io.smallrye.metrics.legacyapi.MpMetadata;
import io.smallrye.metrics.legacyapi.TimerAdapter;
import io.smallrye.metrics.setup.ApplicationNameResolver;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Metric;

public class LegacyMetricRegistryAdapter
implements MetricRegistry {
    private final MetricRegistry.Type type;
    private final MeterRegistry registry;
    protected static final String MP_APPLICATION_NAME_TAG = "mp_app";
    protected static final String MP_APPLICATION_NAME_VAR = "mp.metrics.appName";
    private final Map<MetricDescriptor, MeterHolder> constructedMeters = new ConcurrentHashMap<MetricDescriptor, MeterHolder>();
    private final Map<String, MpMetadata> metadataMap = new ConcurrentHashMap<String, MpMetadata>();
    protected final ConcurrentHashMap<String, io.micrometer.core.instrument.Tag> applicationMPConfigAppNameTagCache;
    protected final ConcurrentHashMap<String, ConcurrentLinkedQueue<MetricID>> applicationMap;
    protected final ApplicationNameResolver appNameResolver;
    private MemberToMetricMappings memberToMetricMappings;
    protected static io.micrometer.core.instrument.Tag[] SERVER_LEVEL_MPCONFIG_APPLICATION_NAME_TAG = null;

    public MeterRegistry getPrometheusMeterRegistry() {
        return this.registry;
    }

    protected void addNameToApplicationMap(MetricID metricID) {
        String appName = this.appNameResolver.getApplicationName();
        this.addNameToApplicationMap(metricID, appName);
    }

    public void addNameToApplicationMap(MetricID metricID, String appName) {
        ConcurrentLinkedQueue newList;
        if (appName == null) {
            return;
        }
        ConcurrentLinkedQueue<Object> list = this.applicationMap.get(appName);
        if (list == null && (list = this.applicationMap.putIfAbsent(appName, newList = new ConcurrentLinkedQueue())) == null) {
            list = newList;
        }
        list.add(metricID);
    }

    public void unRegisterApplicationMetrics() {
        this.unRegisterApplicationMetrics(this.appNameResolver.getApplicationName());
    }

    public void unRegisterApplicationMetrics(String appName) {
        if (appName == null) {
            System.out.println("Application name is null. Cannot unregister metrics for null application.");
            return;
        }
        ConcurrentLinkedQueue<MetricID> list = this.applicationMap.remove(appName);
        if (list != null) {
            for (MetricID metricID : list) {
                this.remove(metricID);
            }
        }
    }

    public LegacyMetricRegistryAdapter(MetricRegistry.Type type, MeterRegistry registry, ApplicationNameResolver appNameResolver) {
        this.appNameResolver = appNameResolver == null ? ApplicationNameResolver.DEFAULT : appNameResolver;
        this.type = type;
        this.registry = registry;
        this.applicationMPConfigAppNameTagCache = new ConcurrentHashMap();
        this.applicationMap = new ConcurrentHashMap();
        if (type == MetricRegistry.Type.APPLICATION) {
            this.memberToMetricMappings = new MemberToMetricMappings();
        }
    }

    private Tags combineApplicationTagsWithMPConfigAppNameTag(Tags tags) {
        return this.combineApplicationTagsWithMPConfigAppNameTag(false, tags);
    }

    private Tags combineApplicationTagsWithMPConfigAppNameTag(boolean isSorted, Tags tags) {
        AbstractMap tagMap;
        io.micrometer.core.instrument.Tag mpConfigAppTag = this.resolveMPConfigAppNameTag();
        AbstractMap abstractMap = tagMap = isSorted ? new TreeMap() : new HashMap();
        if (mpConfigAppTag != null) {
            tagMap.put(mpConfigAppTag.getKey(), mpConfigAppTag.getValue());
            for (io.micrometer.core.instrument.Tag tag : tags) {
                tagMap.put(tag.getKey(), tag.getValue());
            }
            Tags result = Tags.empty();
            for (Map.Entry entry : tagMap.entrySet()) {
                result = result.and((String)entry.getKey(), (String)entry.getValue());
            }
            tags = result;
        }
        return tags;
    }

    private synchronized io.micrometer.core.instrument.Tag resolveMPConfigAppNameTag() {
        String appName = this.appNameResolver.getApplicationName();
        io.micrometer.core.instrument.Tag tag = appName == null ? this.resolveMPConfigAppNameTagByServer() : this.resolveMPConfigAppNameTagByApplication(appName);
        return tag;
    }

    private synchronized io.micrometer.core.instrument.Tag resolveMPConfigAppNameTagByServer() {
        if (SERVER_LEVEL_MPCONFIG_APPLICATION_NAME_TAG == null) {
            SERVER_LEVEL_MPCONFIG_APPLICATION_NAME_TAG = new io.micrometer.core.instrument.Tag[1];
            Optional applicationName = ConfigProvider.getConfig().getOptionalValue(MP_APPLICATION_NAME_VAR, String.class);
            LegacyMetricRegistryAdapter.SERVER_LEVEL_MPCONFIG_APPLICATION_NAME_TAG[0] = applicationName.isPresent() ? io.micrometer.core.instrument.Tag.of((String)MP_APPLICATION_NAME_TAG, (String)((String)applicationName.get())) : null;
        }
        return SERVER_LEVEL_MPCONFIG_APPLICATION_NAME_TAG[0];
    }

    private synchronized io.micrometer.core.instrument.Tag resolveMPConfigAppNameTagByApplication(String appName) {
        io.micrometer.core.instrument.Tag returnTag;
        if (!this.applicationMPConfigAppNameTagCache.containsKey(appName)) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Optional applicationName = ConfigProvider.getConfig((ClassLoader)classLoader).getOptionalValue(MP_APPLICATION_NAME_VAR, String.class);
            io.micrometer.core.instrument.Tag appTag = applicationName.isPresent() ? io.micrometer.core.instrument.Tag.of((String)MP_APPLICATION_NAME_TAG, (String)((String)applicationName.get())) : io.micrometer.core.instrument.Tag.of((String)"null", (String)"null");
            this.applicationMPConfigAppNameTagCache.put(appName, appTag);
        }
        return (returnTag = this.applicationMPConfigAppNameTagCache.get(appName)).getKey().equals("null") ? null : returnTag;
    }

    public LegacyMetricRegistryAdapter(MetricRegistry.Type type, MeterRegistry registry) {
        this(type, registry, ApplicationNameResolver.DEFAULT);
    }

    public <T extends org.eclipse.microprofile.metrics.Metric> T register(String name, T t) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Can not register a pre-constructed Metric with Micrometer");
    }

    public <T extends org.eclipse.microprofile.metrics.Metric> T register(Metadata metadata, T t) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Can not register a pre-constructed Metric with Micrometer");
    }

    public <T extends org.eclipse.microprofile.metrics.Metric> T register(Metadata metadata, T t, Tag ... tags) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Can not register a pre-constructed Metric with Micrometer");
    }

    public Counter counter(String name) {
        return this.internalCounter(this.internalGetMetadata(name, MetricType.COUNTER), new MetricDescriptor(name, this.withAppTags(new Tag[0])));
    }

    public Counter counter(String name, Tag ... tags) {
        return this.internalCounter(this.internalGetMetadata(name, MetricType.COUNTER), new MetricDescriptor(name, this.withAppTags(tags)));
    }

    public Counter counter(MetricID metricID) {
        String name = metricID.getName();
        return this.internalCounter(this.internalGetMetadata(name, MetricType.COUNTER), new MetricDescriptor(name, this.withAppTags(metricID.getTagsAsArray())));
    }

    public Counter counter(Metadata metadata) {
        return this.internalCounter(this.internalGetMetadata(metadata, MetricType.COUNTER), new MetricDescriptor(metadata.getName(), this.withAppTags(new Tag[0])));
    }

    public Counter counter(Metadata metadata, Tag ... tags) {
        return this.internalCounter(this.internalGetMetadata(metadata, MetricType.COUNTER), new MetricDescriptor(metadata.getName(), this.withAppTags(tags)));
    }

    Counter interceptorCounter(Metadata metadata, String ... tags) {
        return this.internalCounter(this.internalGetMetadata(metadata, MetricType.COUNTER), new MetricDescriptor(metadata.getName(), tags));
    }

    Counter injectedCounter(Metric annotation) {
        return this.internalCounter(this.internalGetMetadata(annotation.name(), MetricType.COUNTER).merge(annotation), new MetricDescriptor(annotation.name(), annotation.tags()));
    }

    CounterAdapter internalCounter(MpMetadata metadata, MetricDescriptor id) {
        CounterAdapter result = this.checkCast(CounterAdapter.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new CounterAdapter()));
        this.addNameToApplicationMap(id.toMetricID());
        return result.register(metadata, id, this.registry);
    }

    public ConcurrentGauge concurrentGauge(String name) {
        return null;
    }

    public ConcurrentGauge concurrentGauge(String name, Tag ... tags) {
        return null;
    }

    public ConcurrentGauge concurrentGauge(MetricID metricID) {
        return null;
    }

    public ConcurrentGauge concurrentGauge(Metadata metadata) {
        return null;
    }

    public ConcurrentGauge concurrentGauge(Metadata metadata, Tag ... tags) {
        return null;
    }

    public <T> Gauge<Double> gauge(String name, T o, ToDoubleFunction<T> f) {
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.withAppTags(new Tag[0])), o, f);
    }

    public <T> Gauge<Double> gauge(String name, T o, ToDoubleFunction<T> f, Tag ... tags) {
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.withAppTags(tags)), o, f);
    }

    public <T, R extends Number> Gauge<R> gauge(String name, T o, Function<T, R> f, Tag ... tags) {
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.withAppTags(tags)), o, f);
    }

    public <T, R extends Number> Gauge<R> gauge(MetricID metricID, T o, Function<T, R> f) {
        String name = metricID.getName();
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.withAppTags(new Tag[0])), o, f);
    }

    public <T, R extends Number> Gauge<R> gauge(Metadata metadata, T o, Function<T, R> f, Tag ... tags) {
        String name = metadata.getName();
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.withAppTags(tags)), o, f);
    }

    <T> GaugeAdapter<Double> internalGauge(MpMetadata metadata, MetricDescriptor id, T obj, ToDoubleFunction<T> f) {
        GaugeAdapter.DoubleFunctionGauge result = this.checkCast(GaugeAdapter.DoubleFunctionGauge.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new GaugeAdapter.DoubleFunctionGauge<Object>(obj, f)));
        this.addNameToApplicationMap(id.toMetricID());
        return result.register(metadata, id, this.registry);
    }

    <T, R extends Number> GaugeAdapter<R> internalGauge(MpMetadata metadata, MetricDescriptor id, T obj, Function<T, R> f) {
        GaugeAdapter.FunctionGauge result = this.checkCast(GaugeAdapter.FunctionGauge.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new GaugeAdapter.FunctionGauge(obj, f)));
        this.addNameToApplicationMap(id.toMetricID());
        return result.register(metadata, id, this.registry);
    }

    public <T extends Number> Gauge<T> gauge(String name, Supplier<T> f) {
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.withAppTags(new Tag[0])), f);
    }

    public <T extends Number> Gauge<T> gauge(String name, Supplier<T> f, Tag ... tags) {
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.withAppTags(tags)), f);
    }

    public <T extends Number> Gauge<T> gauge(MetricID metricID, Supplier<T> f) {
        String name = metricID.getName();
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.withAppTags(new Tag[0])), f);
    }

    public <T extends Number> Gauge<T> gauge(Metadata metadata, Supplier<T> f, Tag ... tags) {
        String name = metadata.getName();
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.withAppTags(tags)), f);
    }

    <T extends Number> GaugeAdapter<T> internalGauge(MpMetadata metadata, MetricDescriptor id, Supplier<T> f) {
        GaugeAdapter result = this.checkCast(GaugeAdapter.NumberSupplierGauge.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new GaugeAdapter.NumberSupplierGauge(f)));
        return result.register(metadata, id, this.registry);
    }

    void bindAnnotatedGauge(AnnotatedGaugeAdapter adapter) {
        MetricDescriptor id = new MetricDescriptor(adapter.name(), adapter.tags());
        AnnotatedGaugeAdapter oops = this.checkCast(AnnotatedGaugeAdapter.class, adapter.getMetadata(), this.constructedMeters.putIfAbsent(id, adapter));
        if (oops != null) {
            throw new IllegalArgumentException(String.format("Gauge %s already exists. (existing='%s', new='%s')", adapter.getId(), oops.getTargetName(), adapter.getTargetName()));
        }
        this.metadataMap.put(adapter.name(), adapter.getMetadata());
        adapter.register(id, this.registry);
    }

    public Histogram histogram(String name) {
        return this.internalHistogram(this.internalGetMetadata(name, MetricType.HISTOGRAM), new MetricDescriptor(name, this.withAppTags(new Tag[0])));
    }

    public Histogram histogram(String name, Tag ... tags) {
        return this.internalHistogram(this.internalGetMetadata(name, MetricType.HISTOGRAM), new MetricDescriptor(name, this.withAppTags(tags)));
    }

    public Histogram histogram(MetricID metricID) {
        String name = metricID.getName();
        return this.internalHistogram(this.internalGetMetadata(name, MetricType.HISTOGRAM), new MetricDescriptor(name, this.withAppTags(metricID.getTagsAsArray())));
    }

    public Histogram histogram(Metadata metadata) {
        return this.internalHistogram(this.internalGetMetadata(metadata, MetricType.HISTOGRAM), new MetricDescriptor(metadata.getName(), this.withAppTags(new Tag[0])));
    }

    public Histogram histogram(Metadata metadata, Tag ... tags) {
        return this.internalHistogram(this.internalGetMetadata(metadata, MetricType.HISTOGRAM), new MetricDescriptor(metadata.getName(), this.withAppTags(tags)));
    }

    HistogramAdapter injectedHistogram(Metric annotation) {
        return this.internalHistogram(this.internalGetMetadata(annotation.name(), MetricType.HISTOGRAM).merge(annotation), new MetricDescriptor(annotation.name(), annotation.tags()));
    }

    HistogramAdapter internalHistogram(MpMetadata metadata, MetricDescriptor id) {
        HistogramAdapter result = this.checkCast(HistogramAdapter.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new HistogramAdapter()));
        this.addNameToApplicationMap(id.toMetricID());
        return result.register(metadata, id, this.registry);
    }

    public org.eclipse.microprofile.metrics.Meter meter(String name) {
        return null;
    }

    public org.eclipse.microprofile.metrics.Meter meter(String name, Tag ... tags) {
        return null;
    }

    public org.eclipse.microprofile.metrics.Meter meter(MetricID metricID) {
        return null;
    }

    public org.eclipse.microprofile.metrics.Meter meter(Metadata metadata) {
        return null;
    }

    public org.eclipse.microprofile.metrics.Meter meter(Metadata metadata, Tag ... tags) {
        return null;
    }

    public Timer timer(String name) {
        return this.internalTimer(this.internalGetMetadata(name, MetricType.TIMER), new MetricDescriptor(name, this.withAppTags(new Tag[0])));
    }

    public Timer timer(String name, Tag ... tags) {
        return this.internalTimer(this.internalGetMetadata(name, MetricType.TIMER), new MetricDescriptor(name, this.withAppTags(tags)));
    }

    public Timer timer(MetricID metricID) {
        String name = metricID.getName();
        return this.internalTimer(this.internalGetMetadata(name, MetricType.TIMER), new MetricDescriptor(name, this.withAppTags(metricID.getTagsAsArray())));
    }

    public Timer timer(Metadata metadata) {
        return this.internalTimer(this.internalGetMetadata(metadata, MetricType.TIMER), new MetricDescriptor(metadata.getName(), this.withAppTags(new Tag[0])));
    }

    public Timer timer(Metadata metadata, Tag ... tags) {
        return this.internalTimer(this.internalGetMetadata(metadata, MetricType.TIMER), new MetricDescriptor(metadata.getName(), this.withAppTags(tags)));
    }

    TimerAdapter injectedTimer(Metric annotation) {
        return this.internalTimer(this.internalGetMetadata(annotation.name(), MetricType.TIMER).merge(annotation), new MetricDescriptor(annotation.name(), annotation.tags()));
    }

    TimerAdapter interceptorTimer(Metadata metadata, String ... tags) {
        return this.internalTimer(this.internalGetMetadata(metadata, MetricType.TIMER), new MetricDescriptor(metadata.getName(), tags));
    }

    TimerAdapter internalTimer(MpMetadata metadata, MetricDescriptor id) {
        TimerAdapter result = this.checkCast(TimerAdapter.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new TimerAdapter(this.registry)));
        this.addNameToApplicationMap(id.toMetricID());
        return result.register(metadata, id);
    }

    public SimpleTimer simpleTimer(String name) {
        return null;
    }

    public SimpleTimer simpleTimer(String name, Tag ... tags) {
        return null;
    }

    public SimpleTimer simpleTimer(MetricID metricID) {
        return null;
    }

    public SimpleTimer simpleTimer(Metadata metadata) {
        return null;
    }

    public SimpleTimer simpleTimer(Metadata metadata, Tag ... tags) {
        return null;
    }

    public org.eclipse.microprofile.metrics.Metric getMetric(MetricID metricID) {
        return this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.withAppTags(metricID.getTagsAsArray())));
    }

    public <T extends org.eclipse.microprofile.metrics.Metric> T getMetric(MetricID metricID, Class<T> asType) {
        return (T)((org.eclipse.microprofile.metrics.Metric)asType.cast(this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.withAppTags(metricID.getTagsAsArray())))));
    }

    public Counter getCounter(MetricID metricID) {
        return (Counter)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.withAppTags(metricID.getTagsAsArray())));
    }

    public ConcurrentGauge getConcurrentGauge(MetricID metricID) {
        return (ConcurrentGauge)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.withAppTags(metricID.getTagsAsArray())));
    }

    public Gauge<?> getGauge(MetricID metricID) {
        return (Gauge)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.withAppTags(metricID.getTagsAsArray())));
    }

    public Histogram getHistogram(MetricID metricID) {
        return (Histogram)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.withAppTags(metricID.getTagsAsArray())));
    }

    public org.eclipse.microprofile.metrics.Meter getMeter(MetricID metricID) {
        return (org.eclipse.microprofile.metrics.Meter)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.withAppTags(metricID.getTagsAsArray())));
    }

    public Timer getTimer(MetricID metricID) {
        return (Timer)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.withAppTags(metricID.getTagsAsArray())));
    }

    public SimpleTimer getSimpleTimer(MetricID metricID) {
        return (SimpleTimer)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.withAppTags(metricID.getTagsAsArray())));
    }

    public Metadata getMetadata(String name) {
        return this.metadataMap.get(name);
    }

    TimerAdapter injectedSimpleTimer(Metric annotation) {
        return this.internalSimpleTimer(this.internalGetMetadata(annotation.name(), MetricType.SIMPLE_TIMER).merge(annotation), new MetricDescriptor(annotation.name(), annotation.tags()));
    }

    TimerAdapter internalSimpleTimer(MpMetadata metadata, MetricDescriptor id) {
        TimerAdapter result = this.checkCast(TimerAdapter.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new TimerAdapter(this.registry)));
        return result.register(metadata, id);
    }

    public boolean remove(String name) {
        for (Map.Entry<MetricDescriptor, MeterHolder> e : this.constructedMeters.entrySet()) {
            if (!e.getKey().name().equals(name)) continue;
            this.constructedMeters.remove(e.getKey());
            this.registry.remove(e.getValue().getMeter());
        }
        return this.metadataMap.remove(name) != null;
    }

    public boolean remove(MetricID metricID) {
        return this.internalRemove(new MetricDescriptor(metricID));
    }

    public void removeMatching(MetricFilter metricFilter) {
        for (Map.Entry<MetricDescriptor, MeterHolder> e : this.constructedMeters.entrySet()) {
            MetricID mid = e.getKey().toMetricID();
            if (!metricFilter.matches(mid, (org.eclipse.microprofile.metrics.Metric)e.getValue())) continue;
            this.internalRemove(e.getKey());
        }
    }

    boolean internalRemove(MetricDescriptor match) {
        MeterHolder holder = this.constructedMeters.remove(match);
        if (holder != null) {
            ThreadLocal<Boolean> tlb = null;
            tlb = this.type.equals((Object)MetricRegistry.Type.APPLICATION) ? MetricRegistries.MP_APP_METER_REG_ACCESS : (this.type.equals((Object)MetricRegistry.Type.BASE) ? MetricRegistries.MP_BASE_METER_REG_ACCESS : MetricRegistries.MP_VENDOR_METER_REG_ACCESS);
            tlb.set(true);
            Meter meter = Metrics.globalRegistry.remove(holder.getMeter());
            tlb.set(false);
            if (this.constructedMeters.keySet().stream().noneMatch(id -> id.name.equals(match.name))) {
                this.metadataMap.remove(match.name);
            }
        }
        return holder != null;
    }

    public SortedSet<String> getNames() {
        return new TreeSet<String>(this.metadataMap.keySet());
    }

    public SortedSet<MetricID> getMetricIDs() {
        TreeSet<MetricID> out = new TreeSet<MetricID>();
        for (MetricDescriptor key : this.constructedMeters.keySet()) {
            out.add(key.toMetricID());
        }
        return out;
    }

    public SortedMap<MetricID, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Gauge> getGauges(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.GAUGE, metricFilter);
    }

    public SortedMap<MetricID, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Counter> getCounters(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.COUNTER, metricFilter);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges() {
        return this.getConcurrentGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.CONCURRENT_GAUGE, metricFilter);
    }

    public SortedMap<MetricID, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Histogram> getHistograms(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.HISTOGRAM, metricFilter);
    }

    public SortedMap<MetricID, org.eclipse.microprofile.metrics.Meter> getMeters() {
        return this.getMeters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, org.eclipse.microprofile.metrics.Meter> getMeters(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.METERED, metricFilter);
    }

    public SortedMap<MetricID, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Timer> getTimers(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.TIMER, metricFilter);
    }

    public SortedMap<MetricID, SimpleTimer> getSimpleTimers() {
        return this.getSimpleTimers(MetricFilter.ALL);
    }

    public SortedMap<MetricID, SimpleTimer> getSimpleTimers(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.SIMPLE_TIMER, metricFilter);
    }

    public SortedMap<MetricID, org.eclipse.microprofile.metrics.Metric> getMetrics(MetricFilter filter) {
        TreeMap<MetricID, org.eclipse.microprofile.metrics.Metric> out = new TreeMap<MetricID, org.eclipse.microprofile.metrics.Metric>();
        for (Map.Entry<MetricDescriptor, MeterHolder> e : this.constructedMeters.entrySet()) {
            MetricID mid = e.getKey().toMetricID();
            if (!filter.matches(mid, (org.eclipse.microprofile.metrics.Metric)e.getValue())) continue;
            out.put(e.getKey().toMetricID(), e.getValue());
        }
        return out;
    }

    public <T extends org.eclipse.microprofile.metrics.Metric> SortedMap<MetricID, T> getMetrics(Class<T> ofType, MetricFilter filter) {
        TreeMap<MetricID, org.eclipse.microprofile.metrics.Metric> out = new TreeMap<MetricID, org.eclipse.microprofile.metrics.Metric>();
        for (Map.Entry<MetricDescriptor, MeterHolder> e : this.constructedMeters.entrySet()) {
            MetricID mid;
            if (!e.getValue().getType().equals((Object)MetricType.from(ofType)) || !filter.matches(mid = e.getKey().toMetricID(), (org.eclipse.microprofile.metrics.Metric)e.getValue())) continue;
            out.put(e.getKey().toMetricID(), e.getValue());
        }
        return out;
    }

    public Map<MetricID, org.eclipse.microprofile.metrics.Metric> getMetrics() {
        TreeMap<MetricID, org.eclipse.microprofile.metrics.Metric> out = new TreeMap<MetricID, org.eclipse.microprofile.metrics.Metric>();
        for (Map.Entry<MetricDescriptor, MeterHolder> e : this.constructedMeters.entrySet()) {
            out.put(e.getKey().toMetricID(), e.getValue());
        }
        return out;
    }

    <T extends org.eclipse.microprofile.metrics.Metric> SortedMap<MetricID, T> getMetrics(MetricType type, MetricFilter filter) {
        TreeMap<MetricID, org.eclipse.microprofile.metrics.Metric> out = new TreeMap<MetricID, org.eclipse.microprofile.metrics.Metric>();
        for (Map.Entry<MetricDescriptor, MeterHolder> e : this.constructedMeters.entrySet()) {
            MetricID mid;
            if (e.getValue().getType() != type || !filter.matches(mid = e.getKey().toMetricID(), (org.eclipse.microprofile.metrics.Metric)e.getValue())) continue;
            out.put(e.getKey().toMetricID(), e.getValue());
        }
        return out;
    }

    public Map<String, Metadata> getMetadata() {
        return Collections.unmodifiableMap(this.metadataMap);
    }

    public MetricRegistry.Type getType() {
        return this.type;
    }

    public Tags withAppTags(Tag ... tags) {
        Tags out = Tags.empty();
        for (Tag t : tags) {
            out = out.and(t.getTagName(), t.getTagValue());
        }
        out = this.combineApplicationTagsWithMPConfigAppNameTag(out);
        return out;
    }

    public Tag[] scopeTagsLegacy() {
        return new Tag[]{new Tag("scope", this.type.getName())};
    }

    private MpMetadata internalGetMetadata(String name, MetricType type) {
        MpMetadata result = this.metadataMap.computeIfAbsent(name, k -> new MpMetadata(name, type));
        if (result.type != type) {
            throw new IllegalStateException(String.format("Metric %s already defined using a different type (%s)", name, result.getType()));
        }
        return result;
    }

    private MpMetadata internalGetMetadata(Metadata metadata, MetricType type) {
        MpMetadata result = this.metadataMap.computeIfAbsent(metadata.getName(), k -> MpMetadata.sanitize(metadata, type));
        if (!result.mergeSameType(metadata)) {
            throw new IllegalArgumentException(String.format("Metric %s already defined using a different type (%s)", metadata.getName(), result.getType()));
        }
        if (!result.equals(MpMetadata.sanitize(metadata, type))) {
            throw new IllegalArgumentException(String.format("Existing metadata (%s) does not match with supplied metadata (%s)", result.toString(), metadata.toString()));
        }
        return result;
    }

    <T> T checkCast(Class<T> type, MpMetadata metadata, MeterHolder o) {
        try {
            return type.cast(o);
        }
        catch (ClassCastException cce) {
            throw new IllegalStateException(String.format("Metric %s already defined using a different type (%s)", metadata.name, o.getType().name()), cce);
        }
    }

    public MemberToMetricMappings getMemberToMetricMappings() {
        return this.memberToMetricMappings;
    }
}

