/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.exporters;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.smallrye.metrics.exporters.Exporter;
import io.smallrye.metrics.setup.MPPrometheusMeterRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class OpenMetricsExporter
implements Exporter {
    private final List<MeterRegistry> prometheusRegistryList = Metrics.globalRegistry.getRegistries().stream().filter(registry -> registry instanceof MPPrometheusMeterRegistry).collect(Collectors.toList());

    public OpenMetricsExporter() {
        if (this.prometheusRegistryList == null || this.prometheusRegistryList.size() == 0) {
            throw new IllegalStateException("Prometheus registry was not found in the global registry");
        }
    }

    @Override
    public String exportAllScopes() {
        StringBuilder sb = new StringBuilder();
        for (MeterRegistry meterRegistry : this.prometheusRegistryList) {
            PrometheusMeterRegistry promMeterRegistry = (PrometheusMeterRegistry)meterRegistry;
            sb.append(promMeterRegistry.scrape("application/openmetrics-text; version=1.0.0; charset=utf-8").replaceFirst("\r?\n?# EOF", ""));
        }
        return sb.toString();
    }

    @Override
    public String exportOneScope(MetricRegistry.Type scope) {
        for (MeterRegistry meterRegistry : this.prometheusRegistryList) {
            MPPrometheusMeterRegistry promMeterRegistry = (MPPrometheusMeterRegistry)meterRegistry;
            if (promMeterRegistry.getType() != scope) continue;
            return promMeterRegistry.scrape("application/openmetrics-text; version=1.0.0; charset=utf-8").replaceFirst("\r?\n?# EOF", "");
        }
        return null;
    }

    @Override
    public String exportOneMetric(MetricRegistry.Type scope, MetricID metricID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String exportMetricsByName(MetricRegistry.Type scope, String name) {
        for (MeterRegistry meterRegistry : this.prometheusRegistryList) {
            MPPrometheusMeterRegistry promMeterRegistry = (MPPrometheusMeterRegistry)meterRegistry;
            if (promMeterRegistry.getType() != scope) continue;
            HashSet<String> unitTypesSet = new HashSet<String>();
            unitTypesSet.add("");
            HashSet<String> meterSuffixSet = new HashSet<String>();
            meterSuffixSet.add("");
            for (Meter m : meterRegistry.find(name).meters()) {
                unitTypesSet.add(m.getId().getBaseUnit());
                this.resolveMeterSuffixes(meterSuffixSet, m.getId().getType());
            }
            Set<String> scrapeMeterNames = this.calculateMeterNamesToScrape(name, meterSuffixSet, unitTypesSet);
            return promMeterRegistry.scrape("application/openmetrics-text; version=1.0.0; charset=utf-8", scrapeMeterNames).replaceFirst("\r?\n?# EOF", "");
        }
        return null;
    }

    private String resolvePrometheusName(String input) {
        String output = input;
        if ((output = output.replaceAll("[-+.!?@#$%^&*`'\\s]+", "_")).matches("^[0-9]+.*")) {
            output = "m_" + output;
        }
        if (output.matches("^_+.*")) {
            output = "m_" + output;
        }
        output = output.replaceAll("[^A-Za-z0-9_]", "");
        return output;
    }

    private void resolveMeterSuffixes(Set<String> set, Meter.Type inputType) {
        switch (inputType) {
            case COUNTER: {
                set.add("_total");
                break;
            }
            case DISTRIBUTION_SUMMARY: 
            case TIMER: 
            case LONG_TASK_TIMER: {
                set.add("_count");
                set.add("_sum");
                set.add("_max");
                break;
            }
        }
    }

    private Set<String> calculateMeterNamesToScrape(String name, Set<String> meterSuffixSet, Set<String> unitTypeSet) {
        String promName = this.resolvePrometheusName(name);
        HashSet<String> retSet = new HashSet<String>();
        for (String unit : unitTypeSet) {
            for (String suffix : meterSuffixSet) {
                retSet.add(promName + unit + suffix);
            }
        }
        return retSet;
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }
}

