/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.prometheus.PrometheusConfig;
import io.smallrye.metrics.base.LegacyBaseMetrics;
import io.smallrye.metrics.legacyapi.LegacyMetricRegistryAdapter;
import io.smallrye.metrics.setup.ApplicationNameResolver;
import io.smallrye.metrics.setup.MPPrometheusMeterRegistry;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@ApplicationScoped
public class MetricRegistries {
    protected static final String GLOBAL_TAG_MALFORMED_EXCEPTION = "Malformed list of Global Tags. Tag names must match the following regex [a-zA-Z_][a-zA-Z0-9_]*. Global Tag values must not be empty. Global Tag values MUST escape equal signs `=` and commas `,` with a backslash `\\` ";
    protected static final String GLOBAL_TAGS_VARIABLE = "mp.metrics.tags";
    protected static Tag[] SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS = null;
    public static final ThreadLocal<Boolean> MP_APP_METER_REG_ACCESS = ThreadLocal.withInitial(() -> false);
    public static final ThreadLocal<Boolean> MP_BASE_METER_REG_ACCESS = ThreadLocal.withInitial(() -> false);
    public static final ThreadLocal<Boolean> MP_VENDOR_METER_REG_ACCESS = ThreadLocal.withInitial(() -> false);
    private static final Map<MetricRegistry.Type, MetricRegistry> registries = new ConcurrentHashMap<MetricRegistry.Type, MetricRegistry>();
    static final MeterFilter mpMeterAppRegistryAccessFilter = MeterFilter.accept(id -> MP_APP_METER_REG_ACCESS.get() == true);
    static final MeterFilter mpMeterBaseRegistryAccessFilter = MeterFilter.accept(id -> MP_BASE_METER_REG_ACCESS.get() == true);
    static final MeterFilter mpMeterVendorRegistryAccessFilter = MeterFilter.accept(id -> MP_VENDOR_METER_REG_ACCESS.get() == true);

    @Produces
    @Default
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    @ApplicationScoped
    public MetricRegistry getApplicationRegistry() {
        return MetricRegistries.getOrCreate(MetricRegistry.Type.APPLICATION);
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.BASE)
    @ApplicationScoped
    public MetricRegistry getBaseRegistry() {
        return MetricRegistries.getOrCreate(MetricRegistry.Type.BASE);
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.VENDOR)
    @ApplicationScoped
    public MetricRegistry getVendorRegistry() {
        return MetricRegistries.getOrCreate(MetricRegistry.Type.VENDOR);
    }

    public static MetricRegistry getOrCreate(MetricRegistry.Type type) {
        return MetricRegistries.getOrCreate(type, null);
    }

    public static MetricRegistry getOrCreate(MetricRegistry.Type type, ApplicationNameResolver appNameResolver) {
        return registries.computeIfAbsent(type, t -> new LegacyMetricRegistryAdapter(type, MetricRegistries.resolveMeterRegistry(type), appNameResolver));
    }

    private static MeterRegistry resolveMeterRegistry(MetricRegistry.Type type) {
        MPPrometheusMeterRegistry meterRegistry;
        if (type == MetricRegistry.Type.BASE) {
            meterRegistry = new MPPrometheusMeterRegistry(PrometheusConfig.DEFAULT, MetricRegistry.Type.BASE);
            meterRegistry.config().commonTags(new String[]{"scope", MetricRegistry.Type.BASE.getName()});
            meterRegistry.config().meterFilter(mpMeterBaseRegistryAccessFilter);
        } else if (type == MetricRegistry.Type.APPLICATION) {
            meterRegistry = new MPPrometheusMeterRegistry(PrometheusConfig.DEFAULT, MetricRegistry.Type.APPLICATION);
            meterRegistry.config().commonTags(new String[]{"scope", MetricRegistry.Type.APPLICATION.getName()});
            meterRegistry.config().meterFilter(mpMeterAppRegistryAccessFilter);
        } else if (type == MetricRegistry.Type.VENDOR) {
            meterRegistry = new MPPrometheusMeterRegistry(PrometheusConfig.DEFAULT, MetricRegistry.Type.VENDOR);
            meterRegistry.config().commonTags(new String[]{"scope", MetricRegistry.Type.VENDOR.getName()});
            meterRegistry.config().meterFilter(mpMeterVendorRegistryAccessFilter);
        } else {
            meterRegistry = Metrics.globalRegistry;
        }
        meterRegistry.config().meterFilter(MeterFilter.deny());
        Tag[] globalTags = MetricRegistries.resolveMPConfigGlobalTagsByServer();
        if (globalTags.length != 0) {
            meterRegistry.config().commonTags(Arrays.asList(globalTags));
        }
        Metrics.addRegistry((MeterRegistry)meterRegistry);
        if (type == MetricRegistry.Type.BASE) {
            MP_BASE_METER_REG_ACCESS.set(true);
            new LegacyBaseMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            MP_BASE_METER_REG_ACCESS.set(false);
        }
        return meterRegistry;
    }

    @PreDestroy
    public void cleanUp() {
        registries.remove(MetricRegistry.Type.APPLICATION);
    }

    public static void drop(MetricRegistry.Type type) {
        registries.remove(type);
    }

    public static void dropAll() {
        registries.remove(MetricRegistry.Type.APPLICATION);
        registries.remove(MetricRegistry.Type.BASE);
        registries.remove(MetricRegistry.Type.VENDOR);
    }

    private static synchronized Tag[] resolveMPConfigGlobalTagsByServer() {
        if (SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS == null) {
            Optional globalTags = ConfigProvider.getConfig().getOptionalValue(GLOBAL_TAGS_VARIABLE, String.class);
            SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS = globalTags.isPresent() ? MetricRegistries.parseGlobalTags((String)globalTags.get()) : new Tag[]{};
        }
        return SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS == null ? null : SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS;
    }

    private static Tag[] parseGlobalTags(String globalTags) {
        if (globalTags == null || globalTags.length() == 0) {
            return null;
        }
        String[] kvPairs = globalTags.split("(?<!\\\\),");
        Tag[] arrayOfTags = new Tag[kvPairs.length];
        int count = 0;
        for (String kvString : kvPairs) {
            if (kvString.length() == 0) {
                throw new IllegalArgumentException(GLOBAL_TAG_MALFORMED_EXCEPTION);
            }
            String[] keyValueSplit = kvString.split("(?<!\\\\)=");
            if (keyValueSplit.length != 2 || keyValueSplit[0].length() == 0 || keyValueSplit[1].length() == 0) {
                throw new IllegalArgumentException(GLOBAL_TAG_MALFORMED_EXCEPTION);
            }
            String key = keyValueSplit[0];
            String value = keyValueSplit[1];
            if (!key.matches("[a-zA-Z_][a-zA-Z0-9_]*")) {
                throw new IllegalArgumentException("Invalid Tag name. Tag names must match the following regex [a-zA-Z_][a-zA-Z0-9_]*");
            }
            value = value.replace("\\,", ",");
            value = value.replace("\\=", "=");
            arrayOfTags[count] = Tag.of((String)key, (String)value);
            ++count;
        }
        return arrayOfTags;
    }
}

