/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.OriginAndMetadata;
import io.smallrye.metrics.legacyapi.LegacyMetricRegistryAdapter;
import io.smallrye.metrics.legacyapi.LegacyMetricsExtension;
import io.smallrye.metrics.legacyapi.TagsUtils;
import io.smallrye.metrics.legacyapi.interceptors.MetricName;
import java.util.Arrays;
import java.util.SortedMap;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Metric;

@ApplicationScoped
public class MetricProducer {
    MetricRegistry applicationRegistry = MetricRegistries.getOrCreate(MetricRegistry.Type.APPLICATION);
    @Inject
    MetricName metricName;
    @Inject
    LegacyMetricsExtension metricExtension;

    @Produces
    <T extends Number> Gauge<T> getGauge(InjectionPoint ip) {
        return () -> {
            SortedMap gauges = this.applicationRegistry.getGauges();
            String name = this.metricName.of(ip);
            Tag[] tags = this.getTags(ip);
            MetricID gaugeId = new MetricID(name, MetricProducer.appendScopeTags(tags, (LegacyMetricRegistryAdapter)this.applicationRegistry));
            return (Number)((Gauge)gauges.get(gaugeId)).getValue();
        };
    }

    @Produces
    Counter getCounter(InjectionPoint ip) {
        Metadata metadata = this.getMetadata(ip, MetricType.COUNTER);
        Tag[] tags = this.getTags(ip);
        Counter counter = this.applicationRegistry.counter(metadata, tags);
        return counter;
    }

    @Produces
    Timer getTimer(InjectionPoint ip) {
        Metadata metadata = this.getMetadata(ip, MetricType.TIMER);
        Tag[] tags = this.getTags(ip);
        Timer timer = this.applicationRegistry.timer(metadata, tags);
        return timer;
    }

    private Metadata getMetadata(InjectionPoint ip, MetricType type) {
        OriginAndMetadata metadata;
        Metric metric = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        if (metric != null) {
            Metadata actualMetadata = Metadata.builder().withName(this.metricName.of(ip)).withType(type).withUnit(metric.unit()).withDescription(metric.description()).withDisplayName(metric.displayName()).build();
            metadata = new OriginAndMetadata(ip, actualMetadata);
        } else {
            Metadata actualMetadata = Metadata.builder().withName(this.metricName.of(ip)).withType(type).withUnit("none").withDescription("").withDisplayName("").build();
            metadata = new OriginAndMetadata(ip, actualMetadata);
        }
        return metadata;
    }

    private Tag[] getTags(InjectionPoint ip) {
        Metric metric = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        if (metric != null && metric.tags().length > 0) {
            return TagsUtils.parseTagsAsArray(metric.tags());
        }
        return new Tag[0];
    }

    private static Tag[] appendScopeTags(Tag[] tags, LegacyMetricRegistryAdapter adapter) {
        return (Tag[])Stream.concat(Arrays.stream(tags), Arrays.stream(adapter.scopeTagsLegacy())).toArray(Tag[]::new);
    }
}

