/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.micrometer;

import com.netflix.spectator.atlas.AtlasConfig;
import io.micrometer.appoptics.AppOpticsConfig;
import io.micrometer.appoptics.AppOpticsMeterRegistry;
import io.micrometer.atlas.AtlasMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleConfig;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.micrometer.datadog.DatadogConfig;
import io.micrometer.datadog.DatadogMeterRegistry;
import io.micrometer.dynatrace.DynatraceConfig;
import io.micrometer.dynatrace.DynatraceMeterRegistry;
import io.micrometer.elastic.ElasticConfig;
import io.micrometer.elastic.ElasticMeterRegistry;
import io.micrometer.ganglia.GangliaConfig;
import io.micrometer.ganglia.GangliaMeterRegistry;
import io.micrometer.graphite.GraphiteConfig;
import io.micrometer.graphite.GraphiteMeterRegistry;
import io.micrometer.humio.HumioConfig;
import io.micrometer.humio.HumioMeterRegistry;
import io.micrometer.influx.InfluxConfig;
import io.micrometer.influx.InfluxMeterRegistry;
import io.micrometer.jmx.JmxConfig;
import io.micrometer.jmx.JmxMeterRegistry;
import io.micrometer.kairos.KairosConfig;
import io.micrometer.kairos.KairosMeterRegistry;
import io.micrometer.newrelic.NewRelicConfig;
import io.micrometer.newrelic.NewRelicMeterRegistry;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.micrometer.signalfx.SignalFxConfig;
import io.micrometer.signalfx.SignalFxMeterRegistry;
import io.micrometer.stackdriver.StackdriverConfig;
import io.micrometer.stackdriver.StackdriverMeterRegistry;
import io.micrometer.statsd.StatsdConfig;
import io.micrometer.statsd.StatsdMeterRegistry;
import io.micrometer.wavefront.WavefrontConfig;
import io.micrometer.wavefront.WavefrontMeterRegistry;
import io.smallrye.metrics.micrometer.Backend;
import io.smallrye.metrics.micrometer.RequiresClass;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import org.eclipse.microprofile.config.Config;

@Backend
public class MicrometerBackends {
    public static Class<?>[] classes() {
        return new Class[]{AppOpticsBackendProducer.class, AtlasBackendProducer.class, DatadogBackendProducer.class, ElasticBackendProducer.class, GraphiteBackendProducer.class, GangliaBackendProducer.class, HumioBackendProducer.class, InfluxBackendProducer.class, JmxBackendProducer.class, KairosBackendProducer.class, NewRelicBackendProducer.class, PrometheusBackendProducer.class, SignalFxBackendProducer.class, StackdriverBackendProducer.class, StatsdBackendProducer.class, WavefrontBackendProducer.class};
    }

    public static class SimpleMeterRegistryProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            return new SimpleMeterRegistry(new SimpleConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            }, Clock.SYSTEM);
        }
    }

    @RequiresClass(value={WavefrontMeterRegistry.class, WavefrontConfig.class})
    public static class WavefrontBackendProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            if (!Boolean.parseBoolean(this.config.getOptionalValue("mp.metrics.wavefront.enabled", String.class).orElse("false"))) {
                return null;
            }
            return new WavefrontMeterRegistry(new WavefrontConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            }, Clock.SYSTEM);
        }
    }

    @RequiresClass(value={StatsdMeterRegistry.class, StatsdConfig.class})
    public static class StatsdBackendProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            if (!Boolean.parseBoolean(this.config.getOptionalValue("mp.metrics.statsd.enabled", String.class).orElse("false"))) {
                return null;
            }
            return new StatsdMeterRegistry(new StatsdConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            }, Clock.SYSTEM);
        }
    }

    @RequiresClass(value={SignalFxMeterRegistry.class, SignalFxConfig.class})
    public static class SignalFxBackendProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            if (!Boolean.parseBoolean(this.config.getOptionalValue("mp.metrics.signalfx.enabled", String.class).orElse("false"))) {
                return null;
            }
            return new SignalFxMeterRegistry(new SignalFxConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            }, Clock.SYSTEM);
        }
    }

    @RequiresClass(value={StackdriverMeterRegistry.class, StackdriverConfig.class})
    public static class StackdriverBackendProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            if (!Boolean.parseBoolean(this.config.getOptionalValue("mp.metrics.stackdriver.enabled", String.class).orElse("false"))) {
                return null;
            }
            return new StackdriverMeterRegistry(new StackdriverConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            }, Clock.SYSTEM);
        }
    }

    @RequiresClass(value={PrometheusMeterRegistry.class, PrometheusConfig.class})
    public static class PrometheusBackendProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            if (!Boolean.parseBoolean(this.config.getOptionalValue("mp.metrics.prometheus.enabled", String.class).orElse("true"))) {
                return null;
            }
            return new PrometheusMeterRegistry(new PrometheusConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            });
        }
    }

    @RequiresClass(value={NewRelicMeterRegistry.class, NewRelicConfig.class})
    public static class NewRelicBackendProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            if (!Boolean.parseBoolean(this.config.getOptionalValue("mp.metrics.newrelic.enabled", String.class).orElse("false"))) {
                return null;
            }
            return new NewRelicMeterRegistry(new NewRelicConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            }, Clock.SYSTEM);
        }
    }

    @RequiresClass(value={KairosMeterRegistry.class, KairosConfig.class})
    public static class KairosBackendProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            if (!Boolean.parseBoolean(this.config.getOptionalValue("mp.metrics.kairos.enabled", String.class).orElse("false"))) {
                return null;
            }
            return new KairosMeterRegistry(new KairosConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            }, Clock.SYSTEM);
        }
    }

    @RequiresClass(value={JmxMeterRegistry.class, JmxConfig.class})
    public static class JmxBackendProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            if (!Boolean.parseBoolean(this.config.getOptionalValue("mp.metrics.jmx.enabled", String.class).orElse("false"))) {
                return null;
            }
            return new JmxMeterRegistry(new JmxConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            }, Clock.SYSTEM);
        }
    }

    @RequiresClass(value={InfluxMeterRegistry.class, InfluxConfig.class})
    public static class InfluxBackendProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            if (!Boolean.parseBoolean(this.config.getOptionalValue("mp.metrics.influx.enabled", String.class).orElse("false"))) {
                return null;
            }
            return new InfluxMeterRegistry(new InfluxConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            }, Clock.SYSTEM);
        }
    }

    @RequiresClass(value={HumioMeterRegistry.class, HumioConfig.class})
    public static class HumioBackendProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            if (!Boolean.parseBoolean(this.config.getOptionalValue("mp.metrics.humio.enabled", String.class).orElse("false"))) {
                return null;
            }
            return new HumioMeterRegistry(new HumioConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            }, Clock.SYSTEM);
        }
    }

    @RequiresClass(value={GraphiteMeterRegistry.class, GraphiteConfig.class})
    public static class GraphiteBackendProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            if (!Boolean.parseBoolean(this.config.getOptionalValue("mp.metrics.graphite.enabled", String.class).orElse("false"))) {
                return null;
            }
            return new GraphiteMeterRegistry(new GraphiteConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            }, Clock.SYSTEM);
        }
    }

    @RequiresClass(value={GangliaMeterRegistry.class, GangliaConfig.class})
    public static class GangliaBackendProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            if (!Boolean.parseBoolean(this.config.getOptionalValue("mp.metrics.ganglia.enabled", String.class).orElse("false"))) {
                return null;
            }
            return new GangliaMeterRegistry(new GangliaConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            }, Clock.SYSTEM);
        }
    }

    @RequiresClass(value={ElasticMeterRegistry.class, ElasticConfig.class})
    public static class ElasticBackendProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            if (!Boolean.parseBoolean(this.config.getOptionalValue("mp.metrics.elastic.enabled", String.class).orElse("false"))) {
                return null;
            }
            return new ElasticMeterRegistry(new ElasticConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            }, Clock.SYSTEM);
        }
    }

    @RequiresClass(value={DynatraceMeterRegistry.class, DynatraceConfig.class})
    public static class DynatraceBackendProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            if (!Boolean.parseBoolean(this.config.getOptionalValue("mp.metrics.dynatrace.enabled", String.class).orElse("false"))) {
                return null;
            }
            return new DynatraceMeterRegistry(new DynatraceConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            }, Clock.SYSTEM);
        }
    }

    @RequiresClass(value={DatadogMeterRegistry.class, DatadogConfig.class})
    public static class DatadogBackendProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            if (!Boolean.parseBoolean(this.config.getOptionalValue("mp.metrics.datadog.enabled", String.class).orElse("false"))) {
                return null;
            }
            return new DatadogMeterRegistry(new DatadogConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            }, Clock.SYSTEM);
        }
    }

    @RequiresClass(value={AtlasMeterRegistry.class, AtlasConfig.class})
    public static class AtlasBackendProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            if (!Boolean.parseBoolean(this.config.getOptionalValue("mp.metrics.atlas.enabled", String.class).orElse("false"))) {
                return null;
            }
            return new AtlasMeterRegistry(new AtlasConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            }, Clock.SYSTEM);
        }
    }

    @RequiresClass(value={AppOpticsMeterRegistry.class, AppOpticsConfig.class})
    public static class AppOpticsBackendProducer {
        @Inject
        private Config config;

        @Produces
        @Backend
        public MeterRegistry produce() {
            if (!Boolean.parseBoolean(this.config.getOptionalValue("mp.metrics.appoptics.enabled", String.class).orElse("false"))) {
                return null;
            }
            return new AppOpticsMeterRegistry(new AppOpticsConfig(){

                public String get(String propertyName) {
                    return config.getOptionalValue("mp.metrics." + propertyName, String.class).orElse(null);
                }
            }, Clock.SYSTEM);
        }
    }
}

